/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.impl.resources;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.tipsmod.api.TipsAPI;
import net.darkhax.tipsmod.impl.Constants;
import net.darkhax.tipsmod.impl.client.VanillaScreenIds;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public class ConditionRules<T>
implements Predicate<T> {
    @Nullable
    private final RuleGroup<T> anyOf;
    @Nullable
    private final RuleGroup<T> allOf;
    @Nullable
    private final RuleGroup<T> noneOf;

    private ConditionRules(@Nullable RuleGroup<T> any, @Nullable RuleGroup<T> all, @Nullable RuleGroup<T> none) {
        this.anyOf = any;
        this.allOf = all;
        this.noneOf = none;
    }

    public boolean isEmpty() {
        return this.anyOf == null && this.allOf == null && this.noneOf == null;
    }

    @Override
    public boolean test(T t) {
        return !(this.anyOf != null && !this.anyOf.test(t) || this.allOf != null && !this.allOf.test(t) || this.noneOf != null && !this.noneOf.test(t));
    }

    @Nullable
    public JsonElement writeJson() {
        if (this.anyOf != null && this.allOf == null && this.noneOf == null) {
            return Serializers.STRING.toJSONSet(this.anyOf.entries);
        }
        JsonObject json = new JsonObject();
        if (this.anyOf != null) {
            json.add("any_of", Serializers.STRING.toJSONSet(this.anyOf.entries));
        }
        if (this.allOf != null) {
            json.add("all_of", Serializers.STRING.toJSONSet(this.allOf.entries));
        }
        if (this.noneOf != null) {
            json.add("none_of", Serializers.STRING.toJSONSet(this.noneOf.entries));
        }
        if (!json.keySet().isEmpty()) {
            return json;
        }
        return null;
    }

    public static Predicate<class_437> screenRuleBuilder(String rule) {
        if (rule.equalsIgnoreCase("tipsmod:built-in")) {
            return TipsAPI::canRenderOnScreen;
        }
        if (class_2960.method_20207((String)rule)) {
            class_2960 targetScreen = class_2960.method_12829((String)rule);
            if (targetScreen != null && "minecraft".equalsIgnoreCase(targetScreen.method_12836())) {
                return screen -> VanillaScreenIds.is(targetScreen, screen.getClass());
            }
        } else {
            if (rule.contains(".")) {
                return screen -> rule.equalsIgnoreCase(screen.getClass().getCanonicalName());
            }
            return screen -> rule.equals(screen.getClass().getSimpleName());
        }
        Constants.LOG.error("Screen condition with ID {} is not valid. Only the vanilla screens have IDs.", (Object)rule);
        return screen -> false;
    }

    public static <T> Predicate<class_6880<T>> registryRuleBuilder(Function<class_2960, class_6862<T>> tagBuilder, String rule) {
        if (class_2960.method_20207((String)rule)) {
            class_2960 targetEntryID = class_2960.method_12829((String)rule);
            return targetEntryID == null ? entry -> false : entry -> entry.method_40226(targetEntryID);
        }
        if (ConditionRules.isNamespace(rule)) {
            return entry -> entry.method_40230().map(id -> rule.equalsIgnoreCase(id.method_29177().method_12836())).orElse(false);
        }
        if (rule.startsWith("#") && class_2960.method_20207((String)rule.substring(1))) {
            class_6862 tag = tagBuilder.apply(class_2960.method_12829((String)rule.substring(1)));
            return entry -> entry.method_40220(tag);
        }
        if (rule.startsWith("~")) {
            try {
                Pattern pattern = Pattern.compile(rule);
                return entry -> entry.method_40230().map(key -> pattern.matcher(key.toString()).matches()).orElse(false);
            }
            catch (PatternSyntaxException e) {
                Constants.LOG.error("An invalid Regex pattern was used! Rule '{}' is invalid!", (Object)rule, (Object)e);
                return entry -> false;
            }
        }
        Constants.LOG.error("An invalid pattern was used. Pattern must be a valid resource location, namespace, tag, or regex pattern. '{}'", (Object)rule);
        return entry -> false;
    }

    public static Predicate<Set<class_2960>> resourceLocationsRuleBuilder(String rule) {
        Predicate<class_2960> rlRule = ConditionRules.resourceLocationRuleBuilder(rule);
        return list -> list.stream().anyMatch(rlRule);
    }

    public static Predicate<class_2960> resourceLocationRuleBuilder(String rule) {
        if (class_2960.method_20207((String)rule)) {
            class_2960 targetEntryID = class_2960.method_12829((String)rule);
            return targetEntryID == null ? entry -> false : entry -> entry.equals((Object)targetEntryID);
        }
        if (ConditionRules.isNamespace(rule)) {
            return entry -> rule.equalsIgnoreCase(entry.method_12836());
        }
        if (rule.startsWith("~")) {
            try {
                Pattern pattern = Pattern.compile(rule);
                return entry -> pattern.matcher(entry.toString()).matches();
            }
            catch (PatternSyntaxException e) {
                Constants.LOG.error("An invalid Regex pattern was used! Rule '{}' is invalid!", (Object)rule, (Object)e);
                return entry -> false;
            }
        }
        Constants.LOG.error("An invalid pattern was used. Pattern must be a valid resource location, namespace, or regex pattern. '{}'", (Object)rule);
        return entry -> false;
    }

    private static boolean isNamespace(String input) {
        for (int i = 0; i < input.length(); ++i) {
            if (ConditionRules.allowedInNamespace(input.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean allowedInNamespace(char input) {
        return input == '_' || input == '-' || input >= 'a' && input <= 'z' || input >= '0' && input <= '9' || input == '.';
    }

    @Nullable
    public static <T> ConditionRules<T> fromElement(Function<String, Predicate<T>> ruleBuilder, @Nullable JsonElement element) {
        JsonPrimitive primitive;
        if (element == null) {
            return new ConditionRules<T>(null, null, null);
        }
        if (element instanceof JsonArray || element instanceof JsonPrimitive && (primitive = (JsonPrimitive)element).isString()) {
            Set rules = Serializers.STRING.fromJSONSet(element);
            return new ConditionRules<Object>(new RuleGroup<Object>(v -> ConditionRules.buildRules(ruleBuilder, rules).stream().anyMatch(rule -> rule.test(v)), rules), null, null);
        }
        if (element instanceof JsonObject) {
            Set rules;
            JsonObject obj = (JsonObject)element;
            RuleGroup<Object> anyOf = null;
            RuleGroup<Object> allOf = null;
            RuleGroup<Object> noneOf = null;
            if (obj.has("all_of")) {
                rules = Serializers.STRING.fromJSONSet(obj, "all_of");
                allOf = new RuleGroup<Object>(v -> ConditionRules.buildRules(ruleBuilder, rules).stream().allMatch(rule -> rule.test(v)), rules);
            }
            if (obj.has("none_of")) {
                rules = Serializers.STRING.fromJSONSet(obj, "none_of");
                noneOf = new RuleGroup<Object>(v -> ConditionRules.buildRules(ruleBuilder, rules).stream().noneMatch(rule -> rule.test(v)), rules);
            }
            if (obj.has("any_of")) {
                rules = Serializers.STRING.fromJSONSet(obj, "any_of");
                anyOf = new RuleGroup<Object>(v -> ConditionRules.buildRules(ruleBuilder, rules).stream().anyMatch(rule -> rule.test(v)), rules);
            }
            if (anyOf == null && allOf == null && noneOf == null) {
                Constants.LOG.warn("You have configured a tip with conditions, but none of the conditions were valid! You need an 'any_of', 'all_of', or 'none_of' property. Condition={}", (Object)obj.getAsString());
                return null;
            }
            return new ConditionRules<Object>(anyOf, allOf, noneOf);
        }
        throw new JsonParseException("Condition rules must be a string, string array, or object with an 'all', 'any', or 'none' property.");
    }

    private static <T> List<Predicate<T>> buildRules(Function<String, Predicate<T>> ruleBuilder, Set<String> rules) {
        return rules.stream().map(ruleBuilder).toList();
    }

    public static class RuleGroup<T>
    implements Predicate<T> {
        private final Predicate<T> predicate;
        private final Set<String> entries;

        private RuleGroup(Predicate<T> predicate, Set<String> entries) {
            this.predicate = predicate;
            this.entries = entries;
        }

        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        @Override
        public boolean test(T t) {
            return this.predicate.test(t);
        }
    }
}

