/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.impl.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.darkhax.bookshelf.api.ClientServices;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.data.ITagHelper;
import net.darkhax.bookshelf.api.function.CachedSupplier;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.tipsmod.api.TipsAPI;
import net.darkhax.tipsmod.api.resources.ITip;
import net.darkhax.tipsmod.api.resources.ITipSerializer;
import net.darkhax.tipsmod.impl.TipsModCommon;
import net.darkhax.tipsmod.impl.resources.ConditionRules;
import net.minecraft.class_161;
import net.minecraft.class_1959;
import net.minecraft.class_2561;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_6880;
import net.minecraft.class_746;

public class SimpleTip
implements ITip {
    public static final ITipSerializer<SimpleTip> SERIALIZER = new Serializer();
    private final class_2960 id;
    private final class_2561 title;
    private final class_2561 text;
    private final Optional<Integer> cycleTime;
    private final ConditionRules<class_437> screens;
    private final ConditionRules<class_6880<class_1959>> biome;
    private final ConditionRules<class_6880<class_2874>> dimension;
    private final ConditionRules<Set<class_2960>> advancements;
    private final boolean hasScreenConditions;
    private final boolean hasBiomeConditions;
    private final boolean hasDimensionConditions;
    private final boolean hasAdvancementConditions;
    private final boolean requiresPlayerContext;

    public SimpleTip(class_2960 id, class_2561 title, class_2561 text, Optional<Integer> cycleTime) {
        this(id, title, text, cycleTime, null, null, null, null);
    }

    public SimpleTip(class_2960 id, class_2561 title, class_2561 text, Optional<Integer> cycleTime, ConditionRules<class_437> screens, ConditionRules<class_6880<class_1959>> biomes, ConditionRules<class_6880<class_2874>> dimension, ConditionRules<Set<class_2960>> advancements) {
        this.id = id;
        this.title = title;
        this.text = text;
        this.cycleTime = cycleTime;
        this.screens = screens;
        this.biome = biomes;
        this.dimension = dimension;
        this.advancements = advancements;
        this.hasScreenConditions = this.screens != null && !this.screens.isEmpty();
        this.hasBiomeConditions = this.biome != null && !this.biome.isEmpty();
        this.hasDimensionConditions = this.dimension != null && !this.dimension.isEmpty();
        this.hasAdvancementConditions = this.advancements != null && !this.advancements.isEmpty();
        this.requiresPlayerContext = this.hasBiomeConditions || this.hasDimensionConditions || this.hasAdvancementConditions;
    }

    @Override
    public class_2960 getId() {
        return this.id;
    }

    @Override
    public class_2561 getTitle() {
        return this.title;
    }

    @Override
    public class_2561 getText() {
        return this.text;
    }

    @Override
    public int getCycleTime() {
        return this.cycleTime.orElse(TipsModCommon.CONFIG.defaultCycleTime);
    }

    @Override
    public boolean canDisplayOnScreen(class_437 screen) {
        if (this.hasScreenConditions ? this.screens.test(screen) : TipsAPI.canRenderOnScreen(screen)) {
            if (this.requiresPlayerContext) {
                CachedSupplier completedAdvancements;
                class_746 player = class_310.method_1551().field_1724;
                if (player == null) {
                    return false;
                }
                if (this.hasBiomeConditions && !this.biome.test((class_6880<class_1959>)player.method_37908().method_23753(player.method_24515()))) {
                    return false;
                }
                if (this.hasDimensionConditions && !this.dimension.test((class_6880<class_2874>)player.method_37908().method_40134())) {
                    return false;
                }
                if (this.hasAdvancementConditions && !this.advancements.test((Set)(completedAdvancements = CachedSupplier.cache(() -> ClientServices.CLIENT.getCompletedAdvancements(player).stream().map(class_161::method_688).collect(Collectors.toSet()))).get())) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static final class Serializer
    implements ITipSerializer<SimpleTip> {
        private Serializer() {
        }

        @Override
        public SimpleTip fromJSON(class_2960 id, JsonObject json) {
            class_2561 title = (class_2561)Serializers.TEXT.fromJSON(json, "title", (Object)TipsModCommon.CONFIG.defaultTitle);
            class_2561 text = (class_2561)Serializers.TEXT.fromJSON(json, "tip");
            Optional cycleTime = Serializers.INT.fromJSONOptional(json, "cycleTime");
            if (title == null) {
                throw new JsonParseException("Tip " + id.toString() + " does not have a title. This is required!");
            }
            if (text == null) {
                throw new JsonParseException("Tip " + id.toString() + " does not have text. This is required.");
            }
            JsonObject conditions = json.getAsJsonObject("conditions");
            if (conditions != null) {
                ConditionRules<class_437> screenRules = ConditionRules.fromElement(ConditionRules::screenRuleBuilder, conditions.get("screens"));
                ConditionRules<class_6880<class_1959>> biomeRules = ConditionRules.fromElement(rule -> ConditionRules.registryRuleBuilder(arg_0 -> ((ITagHelper)Services.TAGS).biomeTag(arg_0), rule), conditions.get("biomes"));
                ConditionRules<class_6880<class_2874>> dimensionRules = ConditionRules.fromElement(rule -> ConditionRules.registryRuleBuilder(arg_0 -> ((ITagHelper)Services.TAGS).dimensionTypeTag(arg_0), rule), conditions.get("dimensions"));
                ConditionRules<Set<class_2960>> advancements = ConditionRules.fromElement(ConditionRules::resourceLocationsRuleBuilder, conditions.get("advancements"));
                return new SimpleTip(id, title, text, cycleTime, screenRules, biomeRules, dimensionRules, advancements);
            }
            return new SimpleTip(id, title, text, cycleTime);
        }

        @Override
        public JsonObject toJSON(SimpleTip toWrite) {
            JsonObject json = new JsonObject();
            Serializers.RESOURCE_LOCATION.toJSON(json, "type", (Object)TipsAPI.DEFAULT_SERIALIZER);
            Serializers.TEXT.toJSON(json, "title", (Object)toWrite.title);
            Serializers.TEXT.toJSON(json, "tip", (Object)toWrite.text);
            Serializers.INT.toJSONOptional(json, "cycleTime", toWrite.cycleTime);
            JsonObject conditions = new JsonObject();
            if (toWrite.screens != null && !toWrite.screens.isEmpty()) {
                conditions.add("screens", toWrite.screens.writeJson());
            }
            if (toWrite.biome != null && !toWrite.biome.isEmpty()) {
                conditions.add("biomes", toWrite.biome.writeJson());
            }
            if (toWrite.dimension != null && !toWrite.dimension.isEmpty()) {
                conditions.add("dimensions", toWrite.dimension.writeJson());
            }
            if (toWrite.advancements != null && !toWrite.advancements.isEmpty()) {
                conditions.add("advancements", toWrite.advancements.writeJson());
            }
            if (!conditions.keySet().isEmpty()) {
                json.add("conditions", (JsonElement)conditions);
            }
            return json;
        }
    }
}

