/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalbonemeal.world.level.block.behavior;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fuzs.universalbonemeal.world.level.block.behavior.BonemealBehavior;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1972;
import net.minecraft.class_2222;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2472;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class CoralBehavior
implements BonemealBehavior {
    private static Map<class_2248, class_2248> plantToBlock;

    public boolean method_9651(class_4538 p_54870_, class_2338 p_54871_, class_2680 p_54872_, boolean p_54873_) {
        return p_54870_.method_23753(p_54871_).method_40225(class_1972.field_9408);
    }

    public boolean method_9650(class_1937 p_54875_, class_5819 p_54876_, class_2338 p_54877_, class_2680 p_54878_) {
        return (double)p_54876_.method_43057() < 0.4;
    }

    public void method_9652(class_3218 p_54865_, class_5819 p_54866_, class_2338 p_54867_, class_2680 p_54868_) {
        this.place(p_54865_, p_54867_, p_54868_, p_54866_);
    }

    private boolean place(class_3218 p_54860_, class_2338 p_54861_, class_2680 p_54862_, class_5819 p_54863_) {
        p_54860_.method_8650(p_54861_, false);
        this.dissolve();
        if (this.placeFeature((class_1936)p_54860_, p_54863_, p_54861_, this.getBlockEquivalent(p_54862_, p_54863_).method_9564())) {
            return true;
        }
        p_54860_.method_8652(p_54861_, p_54862_, 3);
        return false;
    }

    public static void invalidate() {
        plantToBlock = null;
    }

    private void dissolve() {
        if (plantToBlock == null) {
            HashMap map = Maps.newHashMap();
            for (class_6880 holder : class_7923.field_41175.method_40286(class_3481.field_15483)) {
                class_2248 block = this.getBlockEquivalent((class_2248)holder.comp_349());
                if (block == null) continue;
                map.put((class_2248)holder.comp_349(), block);
            }
            plantToBlock = map;
        }
    }

    @Nullable
    private class_2248 getBlockEquivalent(class_2248 block) {
        String name = class_7923.field_41175.method_10221((Object)block).method_12832();
        name = name.substring(0, name.indexOf("_coral"));
        for (class_6880 holder : class_7923.field_41175.method_40286(class_3481.field_15461)) {
            if (!class_7923.field_41175.method_10221((Object)((class_2248)holder.comp_349())).method_12832().contains(name)) continue;
            return (class_2248)holder.comp_349();
        }
        return null;
    }

    private class_2248 getBlockEquivalent(class_2680 blockState, class_5819 random) {
        class_2248 block = plantToBlock.get(blockState.method_26204());
        if (block != null) {
            return block;
        }
        return class_7923.field_41175.method_40266(class_3481.field_15461).flatMap(p_204728_ -> p_204728_.method_40243(random)).map(class_6880::comp_349).orElseThrow();
    }

    private boolean placeFeature(class_1936 level, class_5819 random, class_2338 pos, class_2680 blockState) {
        class_2338.class_2339 mutable = pos.method_25503();
        int trunkHeight = random.method_43048(3) + 1;
        if (!this.isValidPosition(level, pos, trunkHeight)) {
            return false;
        }
        for (int j = 0; j < trunkHeight; ++j) {
            if (!this.placeCoralBlock(level, random, (class_2338)mutable, blockState, j == trunkHeight - 1)) {
                return j != 0;
            }
            mutable.method_10098(class_2350.field_11036);
        }
        class_2338 blockpos = mutable.method_10062();
        int arms = random.method_43048(3) + 2;
        ArrayList list = Lists.newArrayList((Iterable)class_2350.class_2353.field_11062);
        Collections.shuffle(list);
        for (class_2350 direction : list.subList(0, arms)) {
            mutable.method_10101((class_2382)blockpos);
            mutable.method_10098(direction);
            int armLength = random.method_43048(5) + 2;
            int i1 = 0;
            for (int j1 = 0; j1 < armLength && this.placeCoralBlock(level, random, (class_2338)mutable, blockState, true); ++j1) {
                mutable.method_10098(class_2350.field_11036);
                if (j1 != 0 && (++i1 < 2 || !(random.method_43057() < 0.25f))) continue;
                mutable.method_10098(direction);
                i1 = 0;
            }
        }
        return true;
    }

    private boolean isValidPosition(class_1936 p_65099_, class_2338 p_65100_, int height) {
        int i = p_65100_.method_10264();
        if (i >= p_65099_.method_31607() + 1 && i + height + 1 < p_65099_.method_31600()) {
            class_2338.class_2339 mutable = new class_2338.class_2339();
            for (int j = 0; j <= height + 4; ++j) {
                int k = j < height ? 0 : (j - height) / 2 + 1;
                for (int l = -k; l <= k; ++l) {
                    for (int i1 = -k; i1 <= k; ++i1) {
                        class_2680 blockstate1 = p_65099_.method_8320((class_2338)mutable.method_25504((class_2382)p_65100_, l, j, i1));
                        if (this.isCoralReplaceable(blockstate1)) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean isCoralReplaceable(class_2680 blockstate1) {
        return blockstate1.method_27852(class_2246.field_10382) || blockstate1.method_26164(class_3481.field_15461) || blockstate1.method_26164(class_3481.field_15488) || blockstate1.method_26164(class_3481.field_15476);
    }

    private boolean placeCoralBlock(class_1936 level, class_5819 random, class_2338 pos, class_2680 blockState, boolean decorateTop) {
        class_2338 blockpos = pos.method_10084();
        class_2680 blockstate = level.method_8320(pos);
        if (this.isCoralReplaceable(blockstate) && this.isCoralReplaceable(level.method_8320(blockpos))) {
            level.method_8652(pos, blockState, 3);
            if (decorateTop) {
                if (random.method_43057() < 0.25f) {
                    class_7923.field_41175.method_40266(class_3481.field_15488).flatMap(p_204731_ -> p_204731_.method_40243(random)).map(class_6880::comp_349).ifPresent(p_204720_ -> level.method_8652(blockpos, p_204720_.method_9564(), 2));
                } else if (random.method_43057() < 0.05f) {
                    level.method_8652(blockpos, (class_2680)class_2246.field_10476.method_9564().method_11657((class_2769)class_2472.field_11472, (Comparable)Integer.valueOf(random.method_43048(4) + 1)), 2);
                }
            }
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_2338 blockpos1;
                if (!(random.method_43057() < 0.2f) || !level.method_8320(blockpos1 = pos.method_10093(direction)).method_27852(class_2246.field_10382)) continue;
                class_7923.field_41175.method_40266(class_3481.field_15476).flatMap(p_204728_ -> p_204728_.method_40243(random)).map(class_6880::comp_349).ifPresent(p_204725_ -> {
                    class_2680 blockstate1 = p_204725_.method_9564();
                    if (blockstate1.method_28498((class_2769)class_2222.field_9933)) {
                        blockstate1 = (class_2680)blockstate1.method_11657((class_2769)class_2222.field_9933, (Comparable)direction);
                    }
                    level.method_8652(blockpos1, blockstate1, 2);
                });
            }
            return true;
        }
        return false;
    }
}

