/*
 * Decompiled with CFR 0.152.
 */
package net.trueHorse.wildToolAccess;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.trueHorse.wildToolAccess.ItemAccess;
import net.trueHorse.wildToolAccess.PlayerInventoryAccess;
import net.trueHorse.wildToolAccess.config.WildToolAccessConfig;

public class AccessBar {
    private final class_310 client;
    private final Class<?> classToAccess;
    private final class_3414 selectionSoundEvent;
    private ArrayList<class_1799> stacks = new ArrayList();
    private int selectedAccessSlotIndex = 0;
    private class_1799 lastSwappedOutTool = class_1799.field_8037;
    private final class_2960 textures;

    public AccessBar(Class<?> classToAccess, class_3414 selectionSoundEvent, class_2960 textures, class_310 client) {
        this.client = client;
        this.classToAccess = classToAccess;
        this.selectionSoundEvent = selectionSoundEvent;
        this.textures = textures;
    }

    public void updateAccessStacks() {
        class_1661 inv = this.client.field_1724.method_31548();
        this.stacks.clear();
        ArrayList<class_1799> itemStacks = new ArrayList<class_1799>(((PlayerInventoryAccess)inv).getAllMainStacksOfType(this.classToAccess));
        if (itemStacks.isEmpty() || WildToolAccessConfig.getBoolValue("leadingEmptySlot")) {
            this.stacks.add(class_1799.field_8037);
        }
        if (WildToolAccessConfig.getBoolValue("lastSwappedOutFirst")) {
            class_1799 prioStack;
            int prioStackSlot = inv.method_7395(this.lastSwappedOutTool);
            class_1799 class_17992 = prioStack = prioStackSlot == -1 ? class_1799.field_8037 : inv.method_5438(prioStackSlot);
            if (prioStack != class_1799.field_8037) {
                this.stacks.add(prioStack);
                itemStacks.remove(prioStack);
            }
        }
        this.stacks.addAll(itemStacks);
    }

    public void scrollInAccessBar(double scrollAmount) {
        int barSize = this.stacks.size();
        int slotsToScroll = (int)Math.signum(scrollAmount);
        this.selectedAccessSlotIndex = Math.floorMod(this.selectedAccessSlotIndex - slotsToScroll, barSize);
    }

    public void selectItem() {
        class_1661 inv = this.client.field_1724.method_31548();
        int slotSwapIsLockedTo = WildToolAccessConfig.getIntValue("lockSwappingToSlot");
        int slotToSwap = slotSwapIsLockedTo >= 1 && slotSwapIsLockedTo <= class_1661.method_7368() ? slotSwapIsLockedTo - 1 : inv.field_7545;
        class_1799 selectedHotbarSlotStack = inv.method_5438(slotToSwap);
        class_1799 selectedAccessbarStack = this.stacks.get(this.selectedAccessSlotIndex);
        if (selectedAccessbarStack != class_1799.field_8037 && !class_1799.method_7973((class_1799)selectedHotbarSlotStack, (class_1799)selectedAccessbarStack)) {
            int accessbarStackPos = inv.field_7547.indexOf((Object)selectedAccessbarStack);
            int slotToTheRight = (slotToSwap + 1) % 9;
            boolean putToTheRight = WildToolAccessConfig.getBoolValue("putToTheRightIfPossible") && inv.method_5438(slotToTheRight) == class_1799.field_8037;
            BiConsumer<Integer, Integer> swapSlots = (slot1, slot2) -> this.client.field_1761.method_2906(this.client.field_1724.field_7512.field_7763, slot1.intValue(), slot2.intValue(), class_1713.field_7791, (class_1657)this.client.field_1724);
            if (accessbarStackPos < 9) {
                swapSlots.accept(9, slotToSwap);
                if (putToTheRight) {
                    swapSlots.accept(9, slotToTheRight);
                }
                swapSlots.accept(9, accessbarStackPos);
                swapSlots.accept(9, slotToSwap);
            } else {
                swapSlots.accept(accessbarStackPos, slotToSwap);
                if (putToTheRight) {
                    swapSlots.accept(accessbarStackPos, slotToTheRight);
                }
            }
            int hotbarSlotToSelect = WildToolAccessConfig.getIntValue("hotbarSlotAfterSwap");
            if (hotbarSlotToSelect >= 1 && hotbarSlotToSelect <= class_1661.method_7368()) {
                inv.field_7545 = hotbarSlotToSelect - 1;
            }
            this.client.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)this.selectionSoundEvent, (float)1.0f, (float)1.0f));
            if (((ItemAccess)selectedHotbarSlotStack.method_7909()).isOfAccessType(this.classToAccess)) {
                this.lastSwappedOutTool = selectedHotbarSlotStack.method_7972();
            }
        }
    }

    public void resetSelection() {
        class_1661 inv = this.client.field_1724.method_31548();
        if (WildToolAccessConfig.getBoolValue("heldItemSelected") && ((ItemAccess)inv.method_5438(inv.field_7545).method_7909()).isOfAccessType(this.classToAccess)) {
            this.updateAccessStacks();
            this.selectedAccessSlotIndex = this.stacks.indexOf(inv.method_5438(inv.field_7545));
        } else {
            this.selectedAccessSlotIndex = 0;
        }
    }

    public int getSelectedAccessSlotIndex() {
        return this.selectedAccessSlotIndex;
    }

    public void setSelectedAccessSlotIndex(int selectedAccessSlotIndex) {
        this.selectedAccessSlotIndex = selectedAccessSlotIndex;
    }

    public ArrayList<class_1799> getStacks() {
        return this.stacks;
    }

    public class_2960 getTextures() {
        return this.textures;
    }
}

