/*
 * Decompiled with CFR 0.152.
 */
package net.trueHorse.wildToolAccess;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import net.trueHorse.wildToolAccess.InGameHudAccess;
import net.trueHorse.wildToolAccess.WildToolAccessSoundEvents;
import net.trueHorse.wildToolAccess.commands.WildToolAccessCommands;
import net.trueHorse.wildToolAccess.config.WildToolAccessConfig;

public class WildToolAccessClient
implements ClientModInitializer {
    private static class_304 access1Binding;
    private static class_304 access2Binding;
    private static boolean access1WasPressed;
    private static boolean access2WasPressed;

    public void onInitializeClient() {
        WildToolAccessConfig.loadCofigs();
        WildToolAccessConfig.loadStuffItems();
        WildToolAccessSoundEvents.registerAll();
        WildToolAccessSoundEvents.updateSoundEventsAsConfigured();
        WildToolAccessCommands.registerCommands();
        access1Binding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.wildtoolaccess.access1", class_3675.class_307.field_1668, 82, "key.categories.inventory"));
        access2Binding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.wildtoolaccess.access2", class_3675.class_307.field_1668, -1, "key.categories.inventory"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            InGameHudAccess hudAcc = (InGameHudAccess)client.field_1705;
            if (!WildToolAccessConfig.getBoolValue("toggleMode")) {
                if (access1Binding.method_1434() && access2Binding.method_1434()) {
                    return;
                }
                if (access1Binding.method_1434() != access1WasPressed) {
                    this.onAccessBindingHeldStatusChanged(access1Binding, hudAcc);
                }
                if (access2Binding.method_1434() != access2WasPressed) {
                    this.onAccessBindingHeldStatusChanged(access2Binding, hudAcc);
                }
                access1WasPressed = access1Binding.method_1434();
                access2WasPressed = access2Binding.method_1434();
            } else {
                while (access1Binding.method_1436()) {
                    this.onToggleBarBindingPressed(1, hudAcc);
                }
                while (access2Binding.method_1436()) {
                    this.onToggleBarBindingPressed(2, hudAcc);
                }
            }
        });
    }

    private void onAccessBindingHeldStatusChanged(class_304 accessBinding, InGameHudAccess hudAcc) {
        if (accessBinding.method_1434()) {
            hudAcc.openAccessbar(accessBinding == access1Binding ? 1 : 2);
        } else if (hudAcc.getOpenAccessBar() != null) {
            hudAcc.closeOpenAccessbar(true);
        }
    }

    private void onToggleBarBindingPressed(int barNum, InGameHudAccess hudAcc) {
        if (hudAcc.getOpenAccessBar() != null) {
            if (hudAcc.isBarWithNumberOpen(barNum)) {
                hudAcc.closeOpenAccessbar(true);
            } else {
                hudAcc.openAccessbar(barNum);
            }
        } else {
            hudAcc.openAccessbar(barNum);
        }
    }
}

