/*
 * Decompiled with CFR 0.152.
 */
package net.trueHorse.wildToolAccess.commands;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1792;
import net.minecraft.class_2164;
import net.minecraft.class_2287;
import net.minecraft.class_2290;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.trueHorse.wildToolAccess.AccessType;
import net.trueHorse.wildToolAccess.StuffPlaceholder;
import net.trueHorse.wildToolAccess.commands.arguments.AccessTypeArgument;
import net.trueHorse.wildToolAccess.commands.arguments.AccessTypeArgumentType;
import net.trueHorse.wildToolAccess.config.WildToolAccessConfig;

public class WildToolAccessCommand {
    private static final class_2164 STUFF_FILE_NOT_FOUND = new class_2164((class_2561)class_2561.method_43471((String)"command.wildtoolaccess.stuff.file_not_found"));
    private static final class_2164 COULDNT_WRITE_TO_STUFF = new class_2164((class_2561)class_2561.method_43471((String)"command.wildtoolaccess.stuff.couldnt_write"));
    private static final class_2164 PROB_COULDNT_READ_STUFF = new class_2164((class_2561)class_2561.method_43471((String)"command.wildtoolaccess.stuff.probably_couldnt_read"));

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"wta").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"stuff").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"item", (ArgumentType)class_2287.method_9776((class_7157)registryAccess)).executes(context -> WildToolAccessCommand.executeModifyStuff(WildToolAccessCommand.getItemListFromItemArgument((CommandContext<FabricClientCommandSource>)context), Operation.ADD, (FabricClientCommandSource)context.getSource())))).then(ClientCommandManager.argument((String)"type", (ArgumentType)new AccessTypeArgumentType(registryAccess)).suggests((context, builder) -> {
            for (AccessType enumType : AccessType.values()) {
                builder.suggest(enumType.name().toLowerCase());
            }
            return builder.buildFuture();
        }).executes(context -> WildToolAccessCommand.executeModifyStuff(WildToolAccessCommand.getItemListFromAccessTypeArgument((CommandContext<FabricClientCommandSource>)context, registryAccess), Operation.ADD, (FabricClientCommandSource)context.getSource())))).then(ClientCommandManager.literal((String)"inventory").executes(context -> WildToolAccessCommand.executeModifyStuff(WildToolAccessCommand.getItemListFromInventory((CommandContext<FabricClientCommandSource>)context), Operation.ADD, (FabricClientCommandSource)context.getSource()))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"item", (ArgumentType)class_2287.method_9776((class_7157)registryAccess)).executes(context -> WildToolAccessCommand.executeModifyStuff(WildToolAccessCommand.getItemListFromItemArgument((CommandContext<FabricClientCommandSource>)context), Operation.REMOVE, (FabricClientCommandSource)context.getSource())))).then(ClientCommandManager.argument((String)"type", (ArgumentType)new AccessTypeArgumentType(registryAccess)).suggests((context, builder) -> {
            for (AccessType enumType : AccessType.values()) {
                builder.suggest(enumType.name().toLowerCase());
            }
            return builder.buildFuture();
        }).executes(context -> WildToolAccessCommand.executeModifyStuff(WildToolAccessCommand.getItemListFromAccessTypeArgument((CommandContext<FabricClientCommandSource>)context, registryAccess), Operation.REMOVE, (FabricClientCommandSource)context.getSource())))).then(ClientCommandManager.literal((String)"inventory").executes(context -> WildToolAccessCommand.executeModifyStuff(WildToolAccessCommand.getItemListFromInventory((CommandContext<FabricClientCommandSource>)context), Operation.REMOVE, (FabricClientCommandSource)context.getSource())))).then(ClientCommandManager.literal((String)"all").executes(context -> WildToolAccessCommand.executeClearStuff((FabricClientCommandSource)context.getSource()))))).then(ClientCommandManager.literal((String)"list").executes(context -> WildToolAccessCommand.executePrintStuff((FabricClientCommandSource)context.getSource())))).then(ClientCommandManager.literal((String)"reset").executes(context -> WildToolAccessCommand.executeResetStuff((FabricClientCommandSource)context.getSource())))));
    }

    private static int executeModifyStuff(ArrayList<class_2960> itemIds, Operation operation, FabricClientCommandSource source) {
        JsonObject obj;
        if (!WildToolAccessConfig.STUFF_FILE.exists()) {
            WildToolAccessConfig.createStuffFileWithValuesEmpty();
        }
        try {
            obj = class_3518.method_15255((Reader)new FileReader(WildToolAccessConfig.STUFF_FILE));
        }
        catch (FileNotFoundException e) {
            throw STUFF_FILE_NOT_FOUND;
        }
        JsonArray vals = class_3518.method_15261((JsonObject)obj, (String)"values");
        class_2561 feedback = operation.apply(itemIds, vals, source);
        try {
            FileWriter fwriter = new FileWriter(WildToolAccessConfig.STUFF_FILE);
            BufferedWriter bwriter = new BufferedWriter(fwriter);
            bwriter.write(obj.toString());
            bwriter.close();
            fwriter.close();
            source.sendFeedback(feedback);
        }
        catch (FileNotFoundException e) {
            throw STUFF_FILE_NOT_FOUND;
        }
        catch (IOException e) {
            throw COULDNT_WRITE_TO_STUFF;
        }
        catch (Exception e) {
            throw PROB_COULDNT_READ_STUFF;
        }
        WildToolAccessConfig.loadStuffItems();
        return 1;
    }

    private static int executeClearStuff(FabricClientCommandSource source) {
        WildToolAccessConfig.createStuffFileWithValuesEmpty();
        source.sendFeedback((class_2561)class_2561.method_43471((String)"command.wildtoolaccess.stuff.cleared"));
        return 1;
    }

    private static int executeResetStuff(FabricClientCommandSource source) {
        WildToolAccessConfig.resetStuffFile();
        source.sendFeedback((class_2561)class_2561.method_43471((String)"command.wildtoolaccess.stuff.cleared"));
        return 1;
    }

    private static int executePrintStuff(FabricClientCommandSource source) {
        if (!WildToolAccessConfig.STUFF_FILE.exists()) {
            source.sendFeedback((class_2561)class_2561.method_43471((String)"command.wildtoolaccess.stuff.no_stuff"));
        } else {
            try {
                JsonObject obj = class_3518.method_15255((Reader)new FileReader(WildToolAccessConfig.STUFF_FILE));
                JsonArray vals = class_3518.method_15261((JsonObject)obj, (String)"values");
                if (vals.isEmpty()) {
                    source.sendFeedback((class_2561)class_2561.method_43471((String)"command.wildtoolaccess.stuff.no_stuff"));
                }
                vals.forEach(val -> source.sendFeedback(class_2561.method_30163((String)val.getAsString())));
            }
            catch (FileNotFoundException e) {
                throw STUFF_FILE_NOT_FOUND;
            }
        }
        return 1;
    }

    private static ArrayList<class_2960> getItemListFromItemArgument(CommandContext<FabricClientCommandSource> context) {
        ArrayList<class_2960> list = new ArrayList<class_2960>();
        list.add(class_7923.field_41178.method_10221((Object)((class_2290)context.getArgument("item", class_2290.class)).method_9785()));
        return list;
    }

    private static ArrayList<class_2960> getItemListFromAccessTypeArgument(CommandContext<FabricClientCommandSource> context, class_7157 registryAccess) {
        ArrayList<class_2960> itemIdsOfType = new ArrayList<class_2960>();
        Class<?> type = ((AccessTypeArgument)context.getArgument("type", AccessTypeArgument.class)).getType();
        if (type == StuffPlaceholder.class) {
            itemIdsOfType.addAll(WildToolAccessConfig.getStuffItems().stream().map(arg_0 -> ((class_7922)class_7923.field_41178).method_10221(arg_0)).toList());
        } else {
            List<class_2960> allItemIds = registryAccess.method_41699(class_7924.field_41197).method_46754().map(class_5321::method_29177).toList();
            for (class_2960 id : allItemIds) {
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
                if (!type.isAssignableFrom(item.getClass())) continue;
                itemIdsOfType.add(id);
            }
        }
        return itemIdsOfType;
    }

    private static ArrayList<class_2960> getItemListFromInventory(CommandContext<FabricClientCommandSource> context) {
        ArrayList<class_2960> ids = new ArrayList<class_2960>();
        ((FabricClientCommandSource)context.getSource()).getClient().field_1724.method_31548().field_7547.forEach(stack -> {
            if (!stack.method_7960()) {
                ids.add(class_7923.field_41178.method_10221((Object)stack.method_7909()));
            }
        });
        return ids;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Operation {
        ADD{

            @Override
            protected class_2561 apply(ArrayList<class_2960> ids, JsonArray vals, FabricClientCommandSource source) {
                ArrayList<class_2960> addedIds = new ArrayList<class_2960>(ids);
                ids.forEach(id -> {
                    if (vals.remove((JsonElement)new JsonPrimitive(id.toString()))) {
                        source.sendFeedback((class_2561)class_2561.method_43469((String)"command.wildtoolaccess.stuff.already_contains", (Object[])new Object[]{id.toString()}));
                        addedIds.remove(id);
                    }
                    vals.add((JsonElement)new JsonPrimitive(id.toString()));
                });
                return class_2561.method_43469((String)"command.wildtoolaccess.stuff.added", (Object[])new Object[]{addedIds});
            }
        }
        ,
        REMOVE{

            @Override
            protected class_2561 apply(ArrayList<class_2960> ids, JsonArray vals, FabricClientCommandSource source) {
                ArrayList<class_2960> removedIds = new ArrayList<class_2960>(ids);
                ids.forEach(id -> {
                    if (!vals.remove((JsonElement)new JsonPrimitive(id.toString()))) {
                        source.sendFeedback((class_2561)class_2561.method_43469((String)"command.wildtoolaccess.stuff.does_not_contain", (Object[])new Object[]{id.toString()}));
                        removedIds.remove(id);
                    }
                });
                return class_2561.method_43469((String)"command.wildtoolaccess.stuff.removed", (Object[])new Object[]{removedIds});
            }
        };


        protected abstract class_2561 apply(ArrayList<class_2960> var1, JsonArray var2, FabricClientCommandSource var3);
    }
}

