/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.fabric;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Optional;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.Version;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_437;
import xaeroplus.XaeroPlus;
import xaeroplus.fabric.util.FabricWaystonesHelperInit;
import xaeroplus.fabric.util.XPShaderResourceReloadListener;
import xaeroplus.fabric.util.compat.IncompatibleMinimapWarningScreen;
import xaeroplus.fabric.util.compat.VersionCheckResult;
import xaeroplus.fabric.util.compat.XaeroPlusMinimapCompatibilityChecker;
import xaeroplus.settings.Settings;
import xaeroplus.util.DataFolderResolveUtil;
import xaeroplus.util.XaeroPlusGameTest;

public class XaeroPlusFabric
implements ClientModInitializer {
    public static void initialize() {
        if (XaeroPlus.initialized.compareAndSet(false, true)) {
            XaeroPlus.LOGGER.info("Initializing XaeroPlus");
            if (!XaeroPlusMinimapCompatibilityChecker.versionCheckResult.minimapCompatible()) {
                XaeroPlus.LOGGER.error("Incompatible Xaero Minimap version detected! Expected: {} Actual: {}", (Object)XaeroPlusMinimapCompatibilityChecker.versionCheckResult.expectedVersion().getFriendlyString(), (Object)XaeroPlusMinimapCompatibilityChecker.versionCheckResult.anyPresentMinimapVersion().map(Version::getFriendlyString).orElse("None!"));
                return;
            }
            XaeroPlus.initializeSettings();
            Settings.REGISTRY.getKeybindings().forEach(KeyBindingHelper::registerKeyBinding);
            FabricWaystonesHelperInit.doInit();
            if (System.getenv("XP_CI_TEST") != null) {
                class_310.method_1551().execute(XaeroPlusGameTest::applyMixinsTest);
            }
        }
    }

    public void onInitializeClient() {
        XaeroPlusFabric.initialize();
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            VersionCheckResult versionCheckResult = XaeroPlusMinimapCompatibilityChecker.versionCheckResult;
            if (versionCheckResult.minimapCompatible()) {
                return;
            }
            Optional<Version> anyPresentVersion = versionCheckResult.minimapVersion().or(versionCheckResult::betterPvpVersion);
            class_310.method_1551().method_1507((class_437)new IncompatibleMinimapWarningScreen(anyPresentVersion, versionCheckResult.expectedVersion()));
        });
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"xaeroDataDir").executes(c -> {
            ((FabricClientCommandSource)c.getSource()).sendFeedback(DataFolderResolveUtil.getCurrentDataDirPath());
            return 1;
        })));
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new XPShaderResourceReloadListener());
    }
}

