/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.fabric.util.compat;

import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import xaeroplus.XaeroPlus;
import xaeroplus.fabric.util.compat.VersionCheckResult;

public class XaeroPlusMinimapCompatibilityChecker {
    public static VersionCheckResult versionCheckResult = XaeroPlusMinimapCompatibilityChecker.versionCheck();

    private static VersionCheckResult versionCheck() {
        try {
            SemanticVersion compatibleMinimapVersion = SemanticVersion.parse((String)XaeroPlusMinimapCompatibilityChecker.getCompatibleMinimapVersion());
            Optional<Version> minimapVersion = XaeroPlusMinimapCompatibilityChecker.getVersion("xaerominimap");
            Optional<Version> betterPvpVersion = XaeroPlusMinimapCompatibilityChecker.getVersion("xaerobetterpvp");
            return new VersionCheckResult(minimapVersion, betterPvpVersion, (Version)compatibleMinimapVersion);
        }
        catch (VersionParsingException e) {
            throw new RuntimeException(e);
        }
    }

    private static Optional<Version> getVersion(String modId) {
        try {
            return FabricLoader.getInstance().getAllMods().stream().filter(modContainer -> modContainer.getMetadata().getId().equals(modId)).map(modContainer -> modContainer.getMetadata().getVersion()).map(ver -> {
                try {
                    return Version.parse((String)ver.getFriendlyString());
                }
                catch (VersionParsingException e) {
                    return null;
                }
            }).findFirst();
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Failed to check version for {}", (Object)modId, (Object)e);
            return Optional.empty();
        }
    }

    private static String getCompatibleMinimapVersion() {
        return ((ModContainer)FabricLoader.getInstance().getModContainer("xaeroplus").get()).getMetadata().getCustomValue("minimap_version").getAsString();
    }
}

