/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import xaero.map.gui.GuiMap;
import xaeroplus.Globals;
import xaeroplus.feature.render.ChunkHighlightProvider;
import xaeroplus.feature.render.HighlightDrawBuffer;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.GuiMapHelper;

public class DrawFeature {
    private final AsyncLoadingCache<Long, LongList> chunkRenderCache;
    private final ChunkHighlightProvider chunkHighlightProvider;
    private final HighlightDrawBuffer drawBuffer = new HighlightDrawBuffer();

    public DrawFeature(ChunkHighlightProvider chunkHighlightProvider) {
        this.chunkHighlightProvider = chunkHighlightProvider;
        this.chunkRenderCache = this.createChunkHighlightRenderCache(chunkHighlightProvider);
    }

    private AsyncLoadingCache<Long, LongList> createChunkHighlightRenderCache(ChunkHighlightProvider chunkHighlightProvider) {
        return Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).refreshAfterWrite(500L, TimeUnit.MILLISECONDS).executor((Executor)Globals.cacheRefreshExecutorService.get()).removalListener((k, v, cause) -> this.markDrawBuffersStale()).buildAsync(k -> this.loadFeatureHighlightsInWindow(chunkHighlightProvider));
    }

    private LongList loadFeatureHighlightsInWindow(ChunkHighlightProvider chunkHighlightProvider) {
        int windowSize;
        int windowZ;
        int windowX;
        Optional<GuiMap> guiMapOptional = GuiMapHelper.getGuiMap();
        if (guiMapOptional.isPresent()) {
            GuiMap guiMap = guiMapOptional.get();
            windowX = GuiMapHelper.getGuiMapCenterRegionX(guiMap);
            windowZ = GuiMapHelper.getGuiMapCenterRegionZ(guiMap);
            windowSize = GuiMapHelper.getGuiMapRegionSize(guiMap);
        } else {
            windowX = ChunkUtils.getPlayerRegionX();
            windowZ = ChunkUtils.getPlayerRegionZ();
            windowSize = Math.max(3, Globals.minimapScaleMultiplier);
        }
        return chunkHighlightProvider.chunkHighlightSupplier().getHighlights(windowX, windowZ, windowSize, Globals.getCurrentDimensionId());
    }

    public int colorInt() {
        return this.chunkHighlightProvider.colorSupplier().getAsInt();
    }

    public void invalidateCache() {
        this.chunkRenderCache.synchronous().invalidateAll();
    }

    public LongList getChunkHighlights() {
        return this.chunkRenderCache.get((Object)0L).getNow(LongList.of());
    }

    public HighlightDrawBuffer getDrawBuffer() {
        return this.drawBuffer;
    }

    public void markDrawBuffersStale() {
        this.drawBuffer.markStale();
    }

    public void closeDrawBuffers() {
        this.drawBuffer.close();
    }
}

