/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.IntSupplier;
import net.lenni0451.lambdaevents.EventHandler;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.Matrix4f;
import xaero.common.HudMod;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaeroplus.XaeroPlus;
import xaeroplus.event.DimensionSwitchEvent;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.feature.render.ChunkHighlightProvider;
import xaeroplus.feature.render.ChunkHighlightSupplier;
import xaeroplus.feature.render.DrawFeature;
import xaeroplus.feature.render.HighlightDrawBuffer;
import xaeroplus.feature.render.HighlightShader;
import xaeroplus.feature.render.MinimapBackgroundDrawHelper;
import xaeroplus.feature.render.XaeroPlusShaders;
import xaeroplus.settings.Settings;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;

public class DrawManager {
    private final Object2ObjectMap<String, DrawFeature> chunkHighlightDrawFeatures = new Object2ObjectOpenHashMap();
    private final List<String> sortedKeySet = new ArrayList<String>();

    public DrawManager() {
        XaeroPlus.EVENT_BUS.register((Object)this);
    }

    public synchronized void registerChunkHighlightProvider(String id, ChunkHighlightSupplier chunkHighlightSupplier, IntSupplier colorSupplier) {
        this.unregisterChunkHighlightProvider(id);
        this.chunkHighlightDrawFeatures.put((Object)id, (Object)new DrawFeature(new ChunkHighlightProvider(chunkHighlightSupplier, colorSupplier)));
        this.sortedKeySet.add(id);
        this.sortedKeySet.sort(Comparator.naturalOrder());
    }

    public synchronized void unregisterChunkHighlightProvider(String id) {
        this.sortedKeySet.remove(id);
        DrawFeature feature = (DrawFeature)this.chunkHighlightDrawFeatures.remove((Object)id);
        if (feature != null) {
            class_310.method_1551().execute(feature::closeDrawBuffers);
        }
    }

    public synchronized void registerChunkHighlightProvider(Class<?> clazz, ChunkHighlightSupplier chunkHighlightSupplier, IntSupplier colorSupplier) {
        this.registerChunkHighlightProvider(clazz.getName(), chunkHighlightSupplier, colorSupplier);
    }

    public synchronized void unregisterChunkHighlightProvider(Class<?> clazz) {
        this.unregisterChunkHighlightProvider(clazz.getName());
    }

    @EventHandler
    public void onDimensionChange(DimensionSwitchEvent event) {
        this.chunkHighlightDrawFeatures.values().forEach(DrawFeature::invalidateCache);
    }

    @EventHandler
    public void onXaeroWorldChange(XaeroWorldChangeEvent event) {
        this.chunkHighlightDrawFeatures.values().forEach(DrawFeature::invalidateCache);
    }

    public synchronized void drawMinimapFeatures(int minViewMapTileChunkCoordX, int maxViewMapTileChunkCoordX, int minViewMapTileChunkCoordZ, int maxViewMapTileChunkCoordZ, int chunkX, int chunkZ, int tileX, int tileZ, int insideX, int insideZ, class_4587 matrixStack, class_4588 overlayBufferBuilder, MinimapRendererHelper helper) {
        if (HudMod.INSTANCE.isFairPlay()) {
            return;
        }
        matrixStack.method_22903();
        matrixStack.method_46416((float)(-(chunkX * 64) - tileX * 16 - insideX), (float)(-(chunkZ * 64) - tileZ * 16 - insideZ), 0.0f);
        matrixStack.method_22905(16.0f, 16.0f, 1.0f);
        if (Settings.REGISTRY.highlightShader.get()) {
            this.drawMinimapFeaturesShader(matrixStack);
        } else {
            this.drawMinimapFeaturesImmediate(minViewMapTileChunkCoordX, maxViewMapTileChunkCoordX, minViewMapTileChunkCoordZ, maxViewMapTileChunkCoordZ, matrixStack, overlayBufferBuilder, helper);
        }
        matrixStack.method_22909();
    }

    public synchronized void drawMinimapFeaturesImmediate(int minViewMapTileChunkCoordX, int maxViewMapTileChunkCoordX, int minViewMapTileChunkCoordZ, int maxViewMapTileChunkCoordZ, class_4587 matrixStack, class_4588 overlayBufferBuilder, MinimapRendererHelper helper) {
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        for (int i = 0; i < this.sortedKeySet.size(); ++i) {
            DrawFeature feature;
            String k = this.sortedKeySet.get(i);
            if (k == null || (feature = (DrawFeature)this.chunkHighlightDrawFeatures.get((Object)k)) == null) continue;
            feature.closeDrawBuffers();
            int color = feature.colorInt();
            float a = ColorHelper.getA(color);
            if (a == 0.0f) {
                return;
            }
            float r = ColorHelper.getR(color);
            float g = ColorHelper.getG(color);
            float b = ColorHelper.getB(color);
            LongList highlights = feature.getChunkHighlights();
            for (int j = 0; j < highlights.size(); ++j) {
                long highlight = highlights.getLong(j);
                int chunkPosX = ChunkUtils.longToChunkX(highlight);
                int chunkPosZ = ChunkUtils.longToChunkZ(highlight);
                int mapTileChunkX = ChunkUtils.chunkCoordToMapTileChunkCoord(chunkPosX);
                int mapTileChunkZ = ChunkUtils.chunkCoordToMapTileChunkCoord(chunkPosZ);
                if (mapTileChunkX < minViewMapTileChunkCoordX || mapTileChunkX > maxViewMapTileChunkCoordX || mapTileChunkZ < minViewMapTileChunkCoordZ || mapTileChunkZ > maxViewMapTileChunkCoordZ) continue;
                helper.addColoredRectToExistingBuffer(matrix, overlayBufferBuilder, (float)chunkPosX, (float)chunkPosZ, 1, 1, r, g, b, a);
            }
        }
    }

    public synchronized void drawMinimapFeaturesShader(class_4587 matrixStack) {
        XaeroPlusShaders.ensureShaders();
        HighlightShader shader = XaeroPlusShaders.HIGHLIGHT_SHADER;
        if (shader == null) {
            return;
        }
        shader.setMapViewMatrix(matrixStack.method_23760().method_23761());
        RenderSystem.enableBlend();
        for (int i = 0; i < this.sortedKeySet.size(); ++i) {
            DrawFeature feature;
            String k = this.sortedKeySet.get(i);
            if (k == null || (feature = (DrawFeature)this.chunkHighlightDrawFeatures.get((Object)k)) == null) continue;
            int color = feature.colorInt();
            float a = ColorHelper.getA(color);
            if (a == 0.0f) {
                return;
            }
            float r = ColorHelper.getR(color);
            float g = ColorHelper.getG(color);
            float b = ColorHelper.getB(color);
            shader.setHighlightColor(r, g, b, a);
            LongList highlights = feature.getChunkHighlights();
            HighlightDrawBuffer drawBuffer = feature.getDrawBuffer();
            if (drawBuffer.needsRefresh(false)) {
                drawBuffer.refresh(highlights, false);
            }
            drawBuffer.render();
        }
        RenderSystem.disableBlend();
    }

    public synchronized void drawWorldMapFeatures(double minBlockX, double maxBlockX, double minBlockZ, double maxBlockZ, int flooredCameraX, int flooredCameraZ, class_4587 matrixStack, class_4588 overlayBuffer) {
        if (HudMod.INSTANCE.isFairPlay()) {
            return;
        }
        matrixStack.method_22903();
        matrixStack.method_46416((float)(-flooredCameraX), (float)(-flooredCameraZ), 1.0f);
        matrixStack.method_22905(16.0f, 16.0f, 1.0f);
        if (Settings.REGISTRY.highlightShader.get()) {
            this.drawWorldMapFeaturesShader(matrixStack);
        } else {
            this.drawWorldMapFeaturesImmediate(minBlockX, maxBlockX, minBlockZ, maxBlockZ, matrixStack, overlayBuffer);
        }
        matrixStack.method_22909();
    }

    public synchronized void drawWorldMapFeaturesShader(class_4587 matrixStack) {
        XaeroPlusShaders.ensureShaders();
        HighlightShader shader = XaeroPlusShaders.HIGHLIGHT_SHADER;
        if (shader == null) {
            return;
        }
        shader.setMapViewMatrix(matrixStack.method_23760().method_23761());
        RenderSystem.enableBlend();
        for (int i = 0; i < this.sortedKeySet.size(); ++i) {
            DrawFeature feature;
            String k = this.sortedKeySet.get(i);
            if (k == null || (feature = (DrawFeature)this.chunkHighlightDrawFeatures.get((Object)k)) == null) continue;
            int color = feature.colorInt();
            float a = ColorHelper.getA(color);
            if (a == 0.0f) {
                return;
            }
            float r = ColorHelper.getR(color);
            float g = ColorHelper.getG(color);
            float b = ColorHelper.getB(color);
            shader.setHighlightColor(r, g, b, a);
            LongList highlights = feature.getChunkHighlights();
            HighlightDrawBuffer drawBuffer = feature.getDrawBuffer();
            if (drawBuffer.needsRefresh(true)) {
                drawBuffer.refresh(highlights, true);
            }
            drawBuffer.render();
        }
        RenderSystem.disableBlend();
    }

    public synchronized void drawWorldMapFeaturesImmediate(double minBlockX, double maxBlockX, double minBlockZ, double maxBlockZ, class_4587 matrixStack, class_4588 overlayBuffer) {
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        for (int i = 0; i < this.sortedKeySet.size(); ++i) {
            DrawFeature feature;
            String k = this.sortedKeySet.get(i);
            if (k == null || (feature = (DrawFeature)this.chunkHighlightDrawFeatures.get((Object)k)) == null) continue;
            feature.closeDrawBuffers();
            int color = feature.colorInt();
            float a = ColorHelper.getA(color);
            if (a == 0.0f) {
                return;
            }
            float r = ColorHelper.getR(color);
            float g = ColorHelper.getG(color);
            float b = ColorHelper.getB(color);
            LongList highlights = feature.getChunkHighlights();
            for (int j = 0; j < highlights.size(); ++j) {
                long highlight = highlights.getLong(j);
                int chunkPosX = ChunkUtils.longToChunkX(highlight);
                int chunkPosZ = ChunkUtils.longToChunkZ(highlight);
                int blockX = ChunkUtils.chunkCoordToCoord(chunkPosX);
                int blockZ = ChunkUtils.chunkCoordToCoord(chunkPosZ);
                if ((double)blockX < minBlockX - 32.0 || (double)blockX > maxBlockX || (double)blockZ < minBlockZ - 32.0 || (double)blockZ > maxBlockZ) continue;
                float left = chunkPosX;
                float top = chunkPosZ;
                float right = left + 1.0f;
                float bottom = top + 1.0f;
                MinimapBackgroundDrawHelper.fillIntoExistingBuffer(matrix, overlayBuffer, left, top, right, bottom, r, g, b, a);
            }
        }
    }
}

