/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.highlights;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import org.rfresh.sqlite.JDBC;
import xaero.map.WorldMap;
import xaeroplus.XaeroPlus;
import xaeroplus.feature.render.highlights.ChunkHighlightData;
import xaeroplus.feature.render.highlights.db.DatabaseMigrator;
import xaeroplus.util.ChunkUtils;

public class ChunkHighlightDatabase
implements Closeable {
    public static int MAX_HIGHLIGHTS_LIST = 25000;
    private final Connection connection;
    protected final String databaseName;
    private static final DatabaseMigrator MIGRATOR = new DatabaseMigrator();

    public ChunkHighlightDatabase(String worldId, String databaseName) {
        this.databaseName = databaseName;
        try {
            Class<JDBC> jdbcClass = JDBC.class;
            Path dbPath = WorldMap.saveFolder.toPath().resolve(worldId).resolve(databaseName + ".db");
            boolean shouldRunMigrations = dbPath.toFile().exists();
            this.connection = DriverManager.getConnection("jdbc:rfresh_sqlite:" + dbPath);
            if (shouldRunMigrations) {
                MIGRATOR.migrate(dbPath, databaseName, this.connection);
            }
            this.createMetadataTable();
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error while creating chunk highlight database: {} for worldId: {}", new Object[]{databaseName, worldId, e});
            throw new RuntimeException(e);
        }
    }

    public void initializeDimension(class_5321<class_1937> dimension) {
        this.createHighlightsTableIfNotExists(dimension);
    }

    private String getTableName(class_5321<class_1937> dimension) {
        return dimension.method_29177().toString();
    }

    private void createMetadataTable() {
        try (Statement statement = this.connection.createStatement();){
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS metadata (id INTEGER PRIMARY KEY, version INTEGER)");
            statement.executeUpdate("INSERT OR REPLACE INTO metadata (id, version) VALUES (0, 1)");
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error creating metadata table for db: {}", (Object)this.databaseName);
            throw new RuntimeException(e);
        }
    }

    private void createHighlightsTableIfNotExists(class_5321<class_1937> dimension) {
        try (Statement statement = this.connection.createStatement();){
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS \"" + this.getTableName(dimension) + "\" (x INTEGER, z INTEGER, foundTime INTEGER)");
            statement.executeUpdate("DROP INDEX IF EXISTS \"unique_xz" + this.getTableName(dimension) + "\"");
            statement.executeUpdate("CREATE UNIQUE INDEX IF NOT EXISTS \"unique_xz_" + this.getTableName(dimension) + "\" ON \"" + this.getTableName(dimension) + "\" (x, z)");
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error creating highlights table for db: {} in dimension: {}", (Object)this.databaseName, (Object)dimension.method_29177());
            throw new RuntimeException(e);
        }
    }

    public void insertHighlightList(List<ChunkHighlightData> chunks, class_5321<class_1937> dimension) {
        if (chunks.isEmpty()) {
            return;
        }
        if (chunks.size() > MAX_HIGHLIGHTS_LIST) {
            Lists.partition(chunks, (int)MAX_HIGHLIGHTS_LIST).forEach(l -> this.insertHighlightsListInternal((List<ChunkHighlightData>)l, dimension));
        } else {
            this.insertHighlightsListInternal(chunks, dimension);
        }
    }

    private void insertHighlightsListInternal(List<ChunkHighlightData> chunks, class_5321<class_1937> dimension) {
        try {
            String statement = "INSERT OR IGNORE INTO \"" + this.getTableName(dimension) + "\" VALUES ";
            statement = statement + chunks.stream().map(chunk -> "(" + chunk.x() + ", " + chunk.z() + ", " + chunk.foundTime() + ")").collect(Collectors.joining(", "));
            try (Statement stmt = this.connection.createStatement();){
                stmt.executeUpdate(statement);
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error inserting {} chunks into {} database in dimension: {}", new Object[]{chunks.size(), this.databaseName, dimension.method_29177(), e});
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<ChunkHighlightData> getHighlightsInWindow(class_5321<class_1937> dimension, int regionXMin, int regionXMax, int regionZMin, int regionZMax) {
        try (Statement statement = this.connection.createStatement();){
            ArrayList<ChunkHighlightData> arrayList;
            block15: {
                ResultSet resultSet = statement.executeQuery("SELECT * FROM \"" + this.getTableName(dimension) + "\" WHERE x >= " + ChunkUtils.regionCoordToChunkCoord(regionXMin) + " AND x <= " + ChunkUtils.regionCoordToChunkCoord(regionXMax) + " AND z >= " + ChunkUtils.regionCoordToChunkCoord(regionZMin) + " AND z <= " + ChunkUtils.regionCoordToChunkCoord(regionZMax));
                try {
                    ArrayList<ChunkHighlightData> chunks = new ArrayList<ChunkHighlightData>();
                    while (resultSet.next()) {
                        chunks.add(new ChunkHighlightData(resultSet.getInt("x"), resultSet.getInt("z"), resultSet.getInt("foundTime")));
                    }
                    arrayList = chunks;
                    if (resultSet == null) break block15;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return arrayList;
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error getting chunks from {} database in dimension: {}, window: {}-{}, {}-{}", new Object[]{this.databaseName, dimension.method_29177(), regionXMin, regionXMax, regionZMin, regionZMax, e});
            return Collections.emptyList();
        }
    }

    public void removeHighlight(int x, int z, class_5321<class_1937> dimension) {
        try (Statement statement = this.connection.createStatement();){
            statement.executeUpdate("DELETE FROM \"" + this.getTableName(dimension) + "\" WHERE x = " + x + " AND z = " + z);
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error while removing highlight from {} database in dimension: {}, at {}, {}", new Object[]{this.databaseName, dimension.method_29177(), x, z, e});
        }
    }

    @Override
    public void close() {
        try {
            this.connection.close();
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.warn("Failed closing {} database connection", (Object)this.databaseName, (Object)e);
        }
    }
}

