/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.highlights;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xaero.map.MapProcessor;
import xaero.map.core.XaeroWorldMapCore;
import xaero.map.gui.GuiMap;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.feature.render.highlights.ChunkHighlightCache;
import xaeroplus.feature.render.highlights.ChunkHighlightCacheDimensionHandler;
import xaeroplus.feature.render.highlights.ChunkHighlightDatabase;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.GuiMapHelper;

public class ChunkHighlightSavingCache
implements ChunkHighlightCache {
    @Nullable
    private ChunkHighlightDatabase database = null;
    @Nullable
    private String currentWorldId;
    private boolean worldCacheInitialized = false;
    @Nullable
    private final String databaseName;
    @Nullable
    private ListeningExecutorService executorService;
    private final Map<class_5321<class_1937>, ChunkHighlightCacheDimensionHandler> dimensionCacheMap = new ConcurrentHashMap<class_5321<class_1937>, ChunkHighlightCacheDimensionHandler>(3);
    int tickCounter = 0;

    public ChunkHighlightSavingCache(@NotNull String databaseName) {
        this.databaseName = databaseName;
    }

    @Override
    public boolean addHighlight(int x, int z) {
        try {
            ChunkHighlightCacheDimensionHandler cacheForCurrentDimension = this.getCacheForCurrentDimension();
            if (cacheForCurrentDimension == null) {
                throw new RuntimeException("Didn't find cache for current dimension");
            }
            cacheForCurrentDimension.addHighlight(x, z);
            return true;
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.debug("Error adding highlight to {} disk cache: {}, {}", new Object[]{this.databaseName, x, z, e});
            return false;
        }
    }

    public void addHighlight(int x, int z, long foundTime, class_5321<class_1937> dimension) {
        if (dimension == null) {
            return;
        }
        ChunkHighlightCacheDimensionHandler cacheForDimension = this.getCacheForDimension(dimension, true);
        if (cacheForDimension == null) {
            return;
        }
        cacheForDimension.addHighlight(x, z, foundTime);
    }

    @Override
    public boolean removeHighlight(int x, int z) {
        try {
            ChunkHighlightCacheDimensionHandler cacheForCurrentDimension = this.getCacheForCurrentDimension();
            if (cacheForCurrentDimension == null) {
                throw new RuntimeException("Didn't find cache for current dimension");
            }
            cacheForCurrentDimension.removeHighlight(x, z);
            return true;
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.debug("Error removing highlight from {} disk cache: {}, {}", new Object[]{this.databaseName, x, z, e});
            return false;
        }
    }

    @Override
    public boolean isHighlighted(int chunkPosX, int chunkPosZ, class_5321<class_1937> dimensionId) {
        if (dimensionId == null) {
            return false;
        }
        ChunkHighlightCacheDimensionHandler cacheForDimension = this.getCacheForDimension(dimensionId, false);
        if (cacheForDimension == null) {
            return false;
        }
        return cacheForDimension.isHighlighted(chunkPosX, chunkPosZ, dimensionId);
    }

    public boolean isHighlighted(int chunkPosX, int chunkPosZ) {
        ChunkHighlightCacheDimensionHandler cacheForDimension = this.getCacheForDimension(ChunkUtils.getActualDimension(), false);
        if (cacheForDimension == null) {
            return false;
        }
        return cacheForDimension.isHighlighted(chunkPosX, chunkPosZ, ChunkUtils.getActualDimension());
    }

    @Override
    public LongList getHighlightsSnapshot(class_5321<class_1937> dimensionId) {
        if (dimensionId == null) {
            return LongList.of();
        }
        ChunkHighlightCacheDimensionHandler cacheForDimension = this.getCacheForDimension(dimensionId, false);
        if (cacheForDimension == null) {
            return LongList.of();
        }
        return cacheForDimension.getHighlightsSnapshot(dimensionId);
    }

    @Override
    public void handleWorldChange() {
        Futures.whenAllComplete(this.saveAllChunks()).call(() -> {
            this.reset();
            this.initializeWorld();
            this.loadChunksInActualDimension();
            return null;
        }, (Executor)Globals.cacheRefreshExecutorService.get());
    }

    public synchronized void reset() {
        this.worldCacheInitialized = false;
        this.currentWorldId = null;
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        if (this.database != null) {
            this.database.close();
        }
        this.dimensionCacheMap.clear();
        this.database = null;
    }

    private List<ListenableFuture<?>> saveAllChunks() {
        if (!this.worldCacheInitialized) {
            return Collections.emptyList();
        }
        return this.getAllCaches().stream().map(ChunkHighlightCacheDimensionHandler::writeAllHighlightsToDatabase).collect(Collectors.toList());
    }

    public ChunkHighlightCacheDimensionHandler getCacheForCurrentDimension() {
        if (!this.worldCacheInitialized) {
            return null;
        }
        return this.getCacheForDimension(ChunkUtils.getActualDimension(), true);
    }

    private ChunkHighlightCacheDimensionHandler initializeDimensionCacheHandler(class_5321<class_1937> dimension) {
        if (dimension == null) {
            return null;
        }
        ChunkHighlightDatabase db = this.database;
        ListeningExecutorService executor = this.executorService;
        if (db == null || executor == null) {
            XaeroPlus.LOGGER.error("Unable to initialize {} disk cache handler for: {}, database or executor is null", (Object)this.databaseName, (Object)dimension.method_29177());
            return null;
        }
        ChunkHighlightCacheDimensionHandler cacheHandler = new ChunkHighlightCacheDimensionHandler(dimension, db, executor);
        db.initializeDimension(dimension);
        this.dimensionCacheMap.put(dimension, cacheHandler);
        return cacheHandler;
    }

    public ChunkHighlightCacheDimensionHandler getCacheForDimension(class_5321<class_1937> dimension, boolean create) {
        if (!this.worldCacheInitialized) {
            return null;
        }
        if (dimension == null) {
            return null;
        }
        ChunkHighlightCacheDimensionHandler dimensionCache = this.dimensionCacheMap.get(dimension);
        if (dimensionCache == null) {
            if (!create) {
                return null;
            }
            XaeroPlus.LOGGER.info("Initializing {} disk cache for dimension: {}", (Object)this.databaseName, (Object)dimension.method_29177());
            dimensionCache = this.initializeDimensionCacheHandler(dimension);
        }
        return dimensionCache;
    }

    private List<ChunkHighlightCacheDimensionHandler> getAllCaches() {
        return new ArrayList<ChunkHighlightCacheDimensionHandler>(this.dimensionCacheMap.values());
    }

    public List<ChunkHighlightCacheDimensionHandler> getCachesExceptDimension(class_5321<class_1937> dimension) {
        ArrayList<ChunkHighlightCacheDimensionHandler> caches = new ArrayList<ChunkHighlightCacheDimensionHandler>(this.dimensionCacheMap.size());
        for (Map.Entry<class_5321<class_1937>, ChunkHighlightCacheDimensionHandler> entry : this.dimensionCacheMap.entrySet()) {
            if (entry.getKey().equals(dimension)) continue;
            caches.add(entry.getValue());
        }
        return caches;
    }

    private synchronized void initializeWorld() {
        try {
            MapProcessor mapProcessor = XaeroWorldMapCore.currentSession.getMapProcessor();
            if (mapProcessor == null) {
                return;
            }
            String worldId = mapProcessor.getCurrentWorldId();
            if (worldId == null) {
                return;
            }
            this.currentWorldId = worldId;
            this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(this.databaseName + "-DiskCache").setUncaughtExceptionHandler((t, e) -> XaeroPlus.LOGGER.error("Uncaught exception handler in {}", (Object)t.getName(), (Object)e)).build()));
            this.database = new ChunkHighlightDatabase(worldId, this.databaseName);
            this.initializeDimensionCacheHandler((class_5321<class_1937>)class_1937.field_25179);
            this.initializeDimensionCacheHandler((class_5321<class_1937>)class_1937.field_25180);
            this.initializeDimensionCacheHandler((class_5321<class_1937>)class_1937.field_25181);
            this.worldCacheInitialized = true;
            this.loadChunksInActualDimension();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadChunksInActualDimension() {
        ChunkHighlightCacheDimensionHandler cacheForCurrentDimension = this.getCacheForCurrentDimension();
        if (cacheForCurrentDimension == null) {
            return;
        }
        cacheForCurrentDimension.setWindow(ChunkUtils.actualPlayerRegionX(), ChunkUtils.actualPlayerRegionZ(), this.getMinimapRegionWindowSize());
    }

    @Override
    public void onEnable() {
        if (!this.worldCacheInitialized) {
            this.initializeWorld();
        }
    }

    @Override
    public void onDisable() {
        Futures.whenAllComplete(this.saveAllChunks()).call(() -> {
            this.reset();
            return null;
        }, (Executor)Globals.cacheRefreshExecutorService.get());
    }

    @Override
    public Long2LongMap getHighlightsState() {
        return null;
    }

    @Override
    public void loadPreviousState(Long2LongMap state) {
    }

    public int getMinimapRegionWindowSize() {
        return Math.max(3, Globals.minimapScaleMultiplier);
    }

    @Override
    public void handleTick() {
        if (!this.worldCacheInitialized) {
            return;
        }
        if (this.tickCounter > 2400) {
            this.tickCounter = 0;
        }
        if (this.tickCounter++ % 30 != 0) {
            return;
        }
        if (this.tickCounter % 1200 == 0) {
            this.getAllCaches().forEach(ChunkHighlightCacheDimensionHandler::writeAllHighlightsToDatabase);
            return;
        }
        Optional<GuiMap> guiMapOptional = GuiMapHelper.getGuiMap();
        if (guiMapOptional.isPresent()) {
            GuiMap guiMap = guiMapOptional.get();
            class_5321<class_1937> mapDimension = Globals.getCurrentDimensionId();
            int mapCenterX = GuiMapHelper.getGuiMapCenterRegionX(guiMap);
            int mapCenterZ = GuiMapHelper.getGuiMapCenterRegionZ(guiMap);
            int mapSize = GuiMapHelper.getGuiMapRegionSize(guiMap);
            ChunkHighlightCacheDimensionHandler cacheForDimension = this.getCacheForDimension(mapDimension, true);
            if (cacheForDimension != null) {
                cacheForDimension.setWindow(mapCenterX, mapCenterZ, mapSize);
            }
            this.getCachesExceptDimension(mapDimension).forEach(cache -> cache.setWindow(0, 0, 0));
        } else {
            ChunkHighlightCacheDimensionHandler cacheForDimension = this.getCacheForDimension(Globals.getCurrentDimensionId(), true);
            if (cacheForDimension != null) {
                cacheForDimension.setWindow(ChunkUtils.getPlayerRegionX(), ChunkUtils.getPlayerRegionZ(), this.getMinimapRegionWindowSize());
            }
            this.getCachesExceptDimension(Globals.getCurrentDimensionId()).forEach(cache -> cache.setWindow(0, 0, 0));
        }
    }
}

