/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.highlights;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import net.lenni0451.lambdaevents.EventHandler;
import xaeroplus.XaeroPlus;
import xaeroplus.event.ClientTickEvent;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.feature.render.highlights.ChunkHighlightCache;
import xaeroplus.feature.render.highlights.ChunkHighlightLocalCache;
import xaeroplus.feature.render.highlights.ChunkHighlightSavingCache;

public class SavableHighlightCacheInstance {
    private ChunkHighlightCache cache;
    private final String dbName;

    public SavableHighlightCacheInstance(String dbName) {
        this.dbName = dbName;
        this.cache = new ChunkHighlightLocalCache();
    }

    public ChunkHighlightCache get() {
        return this.cache;
    }

    public void onEnable() {
        XaeroPlus.EVENT_BUS.register((Object)this);
        this.cache.onEnable();
    }

    public void onDisable() {
        this.cache.onDisable();
        XaeroPlus.EVENT_BUS.unregister((Object)this);
    }

    public void setDiskCache(boolean disk, boolean enabled) {
        try {
            Long2LongMap map = this.cache.getHighlightsState();
            this.cache.onDisable();
            this.cache = disk ? new ChunkHighlightSavingCache(this.dbName) : new ChunkHighlightLocalCache();
            if (enabled) {
                this.cache.onEnable();
                if (map != null) {
                    this.cache.loadPreviousState(map);
                }
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error setting {} cache [{} {}]", new Object[]{this.dbName, disk, enabled, e});
        }
    }

    @EventHandler
    public void onXaeroWorldChange(XaeroWorldChangeEvent event) {
        this.cache.handleWorldChange();
    }

    @EventHandler
    public void onClientTickEvent(ClientTickEvent.Post event) {
        this.cache.handleTick();
    }
}

