/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_634;
import net.minecraft.class_638;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaero.map.MapProcessor;
import xaero.map.region.MapRegion;
import xaero.map.world.MapDimension;
import xaero.map.world.MapWorld;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.feature.extensions.CustomMapProcessor;
import xaeroplus.settings.Settings;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.DataFolderResolveUtil;

@Mixin(value={MapProcessor.class}, remap=false)
public abstract class MixinMapProcessor
implements CustomMapProcessor {
    @Shadow
    private String currentWorldId;
    @Shadow
    private String currentDimId;
    @Shadow
    private String currentMWId;
    @Unique
    private String xaeroPlus$prevWorldId;
    @Unique
    private String xaeroPlus$prevDimId;
    @Unique
    private String xaeroPlus$prevMWId;
    @Unique
    private static final String LOCK_ID = UUID.randomUUID().toString();
    @Shadow
    private class_638 world;
    @Unique
    private static final ThreadLocal<Boolean> xaeroPlus$getLeafRegionActualDimSignal = ThreadLocal.withInitial(() -> false);
    @Unique
    private static final ThreadLocal<Boolean> xaeroPlus$getCurrentDimensionActualDimSignal = ThreadLocal.withInitial(() -> false);

    @Override
    public ThreadLocal<Boolean> xaeroPlus$getLeafRegionActualDimSignal() {
        return xaeroPlus$getLeafRegionActualDimSignal;
    }

    @Override
    public ThreadLocal<Boolean> xaeroPlus$getCurrentDimensionActualDimSignal() {
        return xaeroPlus$getLeafRegionActualDimSignal;
    }

    @Shadow
    public abstract String getDimensionName(class_5321<class_1937> var1);

    @Inject(method={"getMainId(ILnet/minecraft/client/multiplayer/ClientPacketListener;)Ljava/lang/String;"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    private void getMainId(int version, class_634 connection, CallbackInfoReturnable<String> cir) {
        DataFolderResolveUtil.resolveDataFolder(connection, cir);
    }

    @Inject(method={"getDimensionName"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void getDimensionName(class_5321<class_1937> id, CallbackInfoReturnable<String> cir) {
        if (!Globals.nullOverworldDimensionFolder && id == class_1937.field_25179) {
            cir.setReturnValue((Object)"DIM0");
        }
    }

    @Redirect(method={"run"}, at=@At(value="INVOKE", target="Ljava/lang/Thread;sleep(J)V"))
    public void decreaseThreadSleepTime(long millis) throws InterruptedException {
        Thread.sleep(5L);
    }

    @Redirect(method={"updateWorldSynced"}, at=@At(value="INVOKE", target="Ljava/nio/file/Path;resolve(Ljava/lang/String;)Ljava/nio/file/Path;"))
    public Path replaceLockPath(Path instance, String other) {
        return Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve(LOCK_ID + ".lock");
    }

    @Inject(method={"updateWorldSynced"}, at={@At(value="INVOKE", target="Lxaero/map/MapProcessor;popRenderPause(ZZ)V", ordinal=0)})
    public void fireWorldChangedEvent(CallbackInfo ci) {
        XaeroPlus.EVENT_BUS.call((Object)new XaeroWorldChangeEvent(this.currentWorldId, this.currentDimId, this.currentMWId));
    }

    @Inject(method={"getCurrentDimension"}, at={@At(value="HEAD")}, cancellable=true)
    public void getActualDimIfSignalSet(CallbackInfoReturnable<String> cir) {
        if (xaeroPlus$getCurrentDimensionActualDimSignal.get().booleanValue()) {
            cir.setReturnValue((Object)this.getDimensionName(ChunkUtils.getActualDimension()));
        }
    }

    @WrapOperation(method={"getLeafMapRegion"}, at={@At(value="INVOKE", target="Lxaero/map/world/MapWorld;getCurrentDimension()Lxaero/map/world/MapDimension;", ordinal=0)})
    public MapDimension getLeafMapRegionActualDimensionIfSignalled(MapWorld instance, Operation<MapDimension> original) {
        class_638 world = this.world;
        if (this.xaeroPlus$getLeafRegionActualDimSignal().get().booleanValue() && world != null && this.xaeroPlus$prevDimId != null && this.xaeroPlus$prevDimId.equals(this.getDimensionName((class_5321<class_1937>)world.method_27983()))) {
            return instance.getDimension(world.method_27983());
        }
        return (MapDimension)original.call(new Object[]{instance});
    }

    @Redirect(method={"getLeafMapRegion"}, at=@At(value="NEW", target="(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lxaero/map/world/MapDimension;IIIIZLnet/minecraft/core/Registry;)Lxaero/map/region/MapRegion;"), remap=true)
    public MapRegion createMapRegionInActualDimensionIfSignalled(String worldId, String dimId, String mwId, MapDimension dim, int x, int z, int caveLayer, int initialVersion, boolean normalMapData, class_2378 biomeRegistry) {
        class_638 world = this.world;
        if (this.xaeroPlus$getLeafRegionActualDimSignal().get().booleanValue() && world != null && this.xaeroPlus$prevDimId != null && this.xaeroPlus$prevDimId.equals(this.getDimensionName((class_5321<class_1937>)world.method_27983()))) {
            worldId = this.xaeroPlus$prevWorldId;
            dimId = this.xaeroPlus$prevDimId;
            mwId = this.xaeroPlus$prevMWId;
        }
        return new MapRegion(worldId, dimId, mwId, dim, x, z, caveLayer, initialVersion, normalMapData, biomeRegistry);
    }

    @WrapOperation(method={"updateWorldSynced"}, at={@At(value="INVOKE", target="Lxaero/map/world/MapWorld;getCurrentDimension()Lxaero/map/world/MapDimension;", ordinal=0)}, slice={@Slice(from=@At(value="INVOKE", target="Lxaero/map/MapProcessor;releaseLocksIfNeeded()V", ordinal=0))})
    public MapDimension updateWorldSyncedGetActualDimension(MapWorld mapWorld, Operation<MapDimension> original) {
        class_638 world = this.world;
        return Settings.REGISTRY.writesWhileDimSwitched.get() && world != null && mapWorld.isMultiplayer() ? mapWorld.getDimension(world.method_27983()) : (MapDimension)original.call(new Object[]{mapWorld});
    }

    @WrapOperation(method={"updateWorldSynced"}, at={@At(value="FIELD", target="Lxaero/map/MapProcessor;currentWorldId:Ljava/lang/String;", opcode=181, ordinal=0)})
    public void storePrevWorldVarStates(MapProcessor instance, String value, Operation<Void> original) {
        class_638 world = this.world;
        if (world != null && this.getDimensionName((class_5321<class_1937>)world.method_27983()).equals(this.currentDimId)) {
            this.xaeroPlus$prevWorldId = this.currentWorldId;
            this.xaeroPlus$prevDimId = this.currentDimId;
            this.xaeroPlus$prevMWId = this.currentMWId;
        }
        original.call(new Object[]{instance, value});
    }
}

