/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Objects;
import java.util.zip.ZipOutputStream;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaero.map.WorldMap;
import xaero.map.file.MapSaveLoad;
import xaero.map.region.LeveledRegion;
import xaero.map.region.MapRegion;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.settings.Settings;

@Mixin(value={MapSaveLoad.class}, remap=false)
public abstract class MixinMapSaveLoad {
    @Inject(method={"getOldFolder"}, at={@At(value="HEAD")}, cancellable=true)
    public void getOldFolder(String oldUnfixedMainId, String dim, CallbackInfoReturnable<Path> cir) {
        if (!Globals.nullOverworldDimensionFolder) {
            if (oldUnfixedMainId == null) {
                cir.setReturnValue(null);
            }
            String dimIdFixed = Objects.equals(dim, "null") ? "0" : dim;
            cir.setReturnValue((Object)WorldMap.saveFolder.toPath().resolve(oldUnfixedMainId + "_" + dimIdFixed));
        }
    }

    @Redirect(method={"saveRegion"}, at=@At(value="NEW", args={"class=java/io/DataOutputStream"}))
    public DataOutputStream replaceSaveRegionZipOutputStream(OutputStream out, @Local(name={"zipOut"}) ZipOutputStream zipOut, @Share(value="zipOutShare") LocalRef<ZipOutputStream> zipOutShare) {
        if (!Settings.REGISTRY.fastZipWrite.get()) {
            return new DataOutputStream(out);
        }
        Globals.zipFastByteBuffer.reset();
        zipOutShare.set((Object)zipOut);
        return new DataOutputStream(Globals.zipFastByteBuffer);
    }

    @Inject(method={"saveRegion"}, at={@At(value="INVOKE", target="Ljava/util/zip/ZipOutputStream;closeEntry()V")})
    public void saveRegionWriteZipOutputStream(MapRegion region, int extraAttempts, CallbackInfoReturnable<Boolean> cir, @Local(name={"zipOut"}) ZipOutputStream zipOut) throws IOException {
        if (!Settings.REGISTRY.fastZipWrite.get()) {
            return;
        }
        Globals.zipFastByteBuffer.writeTo(zipOut);
        Globals.zipFastByteBuffer.reset();
    }

    @Inject(method={"saveRegion"}, at={@At(value="INVOKE", target="Ljava/io/DataOutputStream;close()V")})
    public void closeZipOutputStream(MapRegion region, int extraAttempts, CallbackInfoReturnable<Boolean> cir, @Share(value="zipOutShare") LocalRef<ZipOutputStream> zipOutShare) throws IOException {
        if (!Settings.REGISTRY.fastZipWrite.get()) {
            return;
        }
        ((ZipOutputStream)zipOutShare.get()).close();
    }

    @Redirect(method={"run"}, at=@At(value="INVOKE", target="Lxaero/map/region/LeveledRegion;isAllCachePrepared()Z", ordinal=0))
    public boolean redirectCacheSaveFailCrash(LeveledRegion instance) {
        boolean value = instance.isAllCachePrepared();
        if (!value) {
            XaeroPlus.LOGGER.warn("LeveledRegion cache not prepared. Attempting to repair crash");
            instance.setRecacheHasBeenRequested(false, "crash fix");
        }
        return value;
    }
}

