/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import it.unimi.dsi.fastutil.doubles.DoubleArrayFIFOQueue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_5321;
import net.minecraft.class_822;
import net.minecraft.class_898;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointVisibilityType;
import xaero.common.minimap.waypoints.render.WaypointsIngameRenderer;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.render.WaypointFilterParams;
import xaeroplus.feature.extensions.CustomWaypointsIngameRenderer;
import xaeroplus.settings.Settings;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;

@Mixin(value={WaypointsIngameRenderer.class}, remap=false)
public class MixinWaypointsIngameRenderer
implements CustomWaypointsIngameRenderer {
    @Shadow
    private List<Waypoint> sortingList;
    @Shadow
    private WaypointFilterParams filterParams;
    @Unique
    List<Waypoint> beaconWaypoints = new ArrayList<Waypoint>();
    @Unique
    final Predicate<Waypoint> beaconViewFilter = w -> {
        boolean deathpoints = this.filterParams.deathpoints;
        if (!(w.isDisabled() || w.getVisibility() == WaypointVisibilityType.WORLD_MAP_LOCAL || w.getVisibility() == WaypointVisibilityType.WORLD_MAP_GLOBAL || w.getPurpose().isDeath() && !deathpoints)) {
            double offX = (double)w.getX(this.filterParams.dimDiv) - this.filterParams.cameraPos.field_1352 + 0.5;
            double offZ = (double)w.getZ(this.filterParams.dimDiv) - this.filterParams.cameraPos.field_1350 + 0.5;
            double distanceScale = this.filterParams.dimensionScaleDistance ? class_310.method_1551().field_1687.method_8597().comp_646() : 1.0;
            double unscaledDistance2D = Math.sqrt(offX * offX + offZ * offZ);
            double distance2D = unscaledDistance2D * distanceScale;
            double waypointsDistance = this.filterParams.waypointsDistance;
            double waypointsDistanceMin = this.filterParams.waypointsDistanceMin;
            return w.isDestination() || (w.getPurpose().isDeath() || w.isGlobal() || w.isTemporary() && this.filterParams.temporaryWaypointsGlobal || waypointsDistance == 0.0 || !(distance2D > waypointsDistance)) && (waypointsDistanceMin == 0.0 || !(unscaledDistance2D < waypointsDistanceMin));
        }
        return false;
    };
    @Unique
    long xaeroPlus$lastSpeedUpdate = 0L;
    @Unique
    public final DoubleArrayFIFOQueue xaeroPlus$speedQueue = new DoubleArrayFIFOQueue(15);

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lxaero/hud/minimap/waypoint/render/WaypointDeleter;begin()V")})
    public void preferOwWaypointsRemoveSubworldText(MinimapSession session, float partial, MinimapProcessor minimap, Matrix4f waypointsProjection, Matrix4f worldModelView, CallbackInfo ci, @Local(name={"subworldName"}) LocalRef<String> subWorldNameRef) {
        if (!Settings.REGISTRY.owAutoWaypointDimension.get()) {
            return;
        }
        if (subWorldNameRef.get() == null) {
            return;
        }
        class_5321<class_1937> actualDimension = ChunkUtils.getActualDimension();
        class_5321 currentWpWorldDim = session.getWorldManager().getCurrentWorld().getDimId();
        if (actualDimension == class_1937.field_25180 && currentWpWorldDim == class_1937.field_25179) {
            subWorldNameRef.set(null);
        }
    }

    @Inject(method={"renderWaypointsIterator"}, at={@At(value="HEAD")})
    public void collectBeaconWaypointsList(class_4587 matrixStack, class_4587 matrixStackOverlay, MinimapRendererHelper helper, Iterator<Waypoint> iter, double d3, double d4, double d5, class_1297 entity, class_287 bufferbuilder, class_289 tessellator, double dimDiv, double actualEntityX, double actualEntityY, double actualEntityZ, double smoothEntityY, double fov, int screenHeight, float cameraAngleYaw, float cameraAnglePitch, Vector3f lookVector, double clampDepth, class_4597.class_4598 renderTypeBuffer, class_4588 waypointBackgroundConsumer, class_327 fontrenderer, Matrix4f waypointsProjection, int screenWidth, boolean detailedDisplayAllowed, double minDistance, String subworldName, CallbackInfo ci) {
        this.beaconWaypoints = this.sortingList.stream().filter(this.beaconViewFilter).sorted().collect(Collectors.toList());
    }

    @Override
    public void renderWaypointBeacons(MinimapSession minimapSession, class_4587 matrixStack, float tickDelta) {
        double dimDiv = minimapSession.getDimensionHelper().getDimensionDivision(minimapSession.getWorldManager().getCurrentWorld());
        this.beaconWaypoints.forEach(w -> this.renderWaypointBeacon((Waypoint)w, dimDiv, tickDelta, matrixStack));
        this.beaconWaypoints.clear();
    }

    @Unique
    public void renderWaypointBeacon(Waypoint waypoint, double dimDiv, float tickDelta, class_4587 matrixStack) {
        class_243 waypointVec;
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        class_243 playerVec = mc.field_1724.method_19538();
        double xzDistance = playerVec.method_1022(waypointVec = new class_243((double)waypoint.getX(dimDiv), playerVec.field_1351, (double)waypoint.getZ(dimDiv)));
        if (xzDistance < (double)Settings.REGISTRY.waypointBeaconDistanceMin.getAsInt()) {
            return;
        }
        int farScale = Settings.REGISTRY.waypointBeaconScaleMin.getAsInt();
        double maxRenderDistance = Math.min((Integer)mc.field_1690.method_42503().method_41753() << 4, farScale == 0 ? Integer.MAX_VALUE : farScale << 4);
        if (xzDistance > maxRenderDistance) {
            class_243 delta = waypointVec.method_1020(playerVec).method_1029();
            waypointVec = playerVec.method_1019(new class_243(delta.field_1352 * maxRenderDistance, delta.field_1351 * maxRenderDistance, delta.field_1350 * maxRenderDistance));
        }
        class_898 entityRenderDispatcher = mc.method_1561();
        class_4184 camera = entityRenderDispatcher.field_4686;
        class_4604 frustum = mc.field_1769.field_27740;
        if (camera == null || frustum == null) {
            return;
        }
        double viewX = camera.method_19326().method_10216();
        double viewZ = camera.method_19326().method_10215();
        double x = waypointVec.field_1352 - viewX;
        double z = waypointVec.field_1350 - viewZ;
        double y = -100.0;
        if (!frustum.method_23093(new class_238(waypointVec.field_1352 - 1.0, -100.0, waypointVec.field_1350 - 1.0, waypointVec.field_1352 + 1.0, 500.0, waypointVec.field_1350 + 1.0))) {
            return;
        }
        int color = waypoint.getWaypointColor().getHex();
        class_4597.class_4598 entityVertexConsumers = mc.method_22940().method_23000();
        long time = mc.field_1687.method_8510();
        matrixStack.method_22903();
        matrixStack.method_22904(x, -100.0, z);
        class_822.method_3545((class_4587)matrixStack, (class_4597)entityVertexConsumers, (class_2960)class_822.field_4338, (float)tickDelta, (float)1.0f, (long)time, (int)0, (int)355, (float[])ColorHelper.getColorRGBA(color), (float)0.2f, (float)0.25f);
        matrixStack.method_22909();
    }

    @ModifyArg(method={"renderWaypointIngame"}, at=@At(value="INVOKE", target="Lxaero/common/minimap/waypoints/render/WaypointsIngameRenderer;drawAsOverlay(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/PoseStack;Lxaero/common/minimap/render/MinimapRendererHelper;Lxaero/common/minimap/waypoints/Waypoint;Lxaero/common/settings/ModSettings;Lcom/mojang/blaze3d/vertex/BufferBuilder;Lcom/mojang/blaze3d/vertex/Tesselator;Lnet/minecraft/client/gui/Font;Ljava/lang/String;Ljava/lang/String;FZLnet/minecraft/client/renderer/MultiBufferSource$BufferSource;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lorg/joml/Matrix4f;IIDDZLjava/lang/String;)V"), index=9, remap=true)
    public String modifyDistanceText(String text, @Local(argsOnly=true) Waypoint waypoint) {
        if (!Settings.REGISTRY.waypointEta.get()) {
            return text;
        }
        if (text.isBlank()) {
            return text;
        }
        long eta = this.getEtaSecondsToReachWaypoint(waypoint);
        if (eta <= 0L) {
            return text;
        }
        Object etaText = " - ";
        if (eta > 86400L) {
            int days = (int)(eta / 86400L);
            int hours = (int)(eta % 86400L / 3600L);
            etaText = (String)etaText + days + "d";
            if (hours > 0) {
                etaText = (String)etaText + " " + hours + "h";
            }
        } else if (eta > 3600L) {
            int hours = (int)(eta / 3600L);
            int minutes = (int)(eta % 3600L / 60L);
            etaText = (String)etaText + hours + "h";
            if (minutes > 0) {
                etaText = (String)etaText + " " + minutes + "m";
            }
        } else if (eta > 60L) {
            int minutes = (int)(eta / 60L);
            int seconds = (int)(eta % 60L);
            etaText = (String)etaText + minutes + "m";
            if (seconds > 0) {
                etaText = (String)etaText + " " + seconds + "s";
            }
        } else {
            etaText = (String)etaText + eta + "s";
        }
        return text + (String)etaText;
    }

    @Unique
    public long getEtaSecondsToReachWaypoint(Waypoint waypoint) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return 0L;
        }
        try {
            class_243 playerVec = mc.field_1724.method_19538();
            MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
            if (minimapSession == null) {
                return 0L;
            }
            double dimDiv = minimapSession.getDimensionHelper().getDimensionDivision(minimapSession.getWorldManager().getCurrentWorld());
            int wpX = waypoint.getX(dimDiv);
            int wpZ = waypoint.getZ(dimDiv);
            double directionX = (double)wpX - playerVec.field_1352;
            double directionZ = (double)wpZ - playerVec.field_1350;
            double movementX = playerVec.field_1352 - mc.field_1724.field_6038;
            double movementZ = playerVec.field_1350 - mc.field_1724.field_5989;
            double dot = directionX * movementX + directionZ * movementZ;
            double distance = Math.sqrt(directionX * directionX + directionZ * directionZ);
            double speed = this.xaeroPlus$speedQueue.isEmpty() ? 0.0 : this.xaeroPlus$avgSpeed(this.xaeroPlus$speedQueue);
            double cos = dot / (distance * speed);
            double time = distance / speed;
            double etaTicks = time / cos;
            double etaSeconds = etaTicks / 20.0;
            long updateDeltaMs = System.currentTimeMillis() - this.xaeroPlus$lastSpeedUpdate;
            if (updateDeltaMs > 50L) {
                this.xaeroPlus$lastSpeedUpdate = System.currentTimeMillis();
                double s = Math.sqrt(movementX * movementX + movementZ * movementZ);
                if (s > 0.0 || mc.field_1724.field_6012 % 4 == 0) {
                    this.xaeroPlus$speedQueue.enqueue(s);
                } else if (!this.xaeroPlus$speedQueue.isEmpty()) {
                    this.xaeroPlus$speedQueue.dequeueDouble();
                }
                while (this.xaeroPlus$speedQueue.size() > 10) {
                    this.xaeroPlus$speedQueue.dequeueDouble();
                }
            }
            if (etaSeconds == Double.POSITIVE_INFINITY || etaSeconds == Double.NEGATIVE_INFINITY || Double.isNaN(etaSeconds)) {
                return 0L;
            }
            return (long)etaSeconds;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    @Unique
    private double xaeroPlus$avgSpeed(DoubleArrayFIFOQueue speedQueue) {
        double sum = 0.0;
        for (int i = 0; i < speedQueue.size(); ++i) {
            double v = speedQueue.dequeueDouble();
            speedQueue.enqueue(v);
            sum += v;
        }
        double s = sum / (double)speedQueue.size();
        if (s < 0.05) {
            return 0.0;
        }
        return s;
    }
}

