/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import xaeroplus.Globals;
import xaeroplus.module.Module;
import xaeroplus.settings.Settings;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;

public class Highways
extends Module {
    private int highwaysColor = ColorHelper.getColor(0, 0, 255, 100);
    private static final IntSet ringRoads = Highways.chunkSetFromPosList(200, 500, 1000, 1500, 2000, 2500, 5000, 7500, 10000, 15000, 20000, 25000, 50000, 62500, 100000, 125000, 250000, 500000, 750000, 1000000, 1250000, 1568852, 1875000, 2500000, 3750000);
    private static final IntSet diamonds = Highways.chunkSetFromPosList(2500, 5000, 25000, 50000, 125000, 250000, 500000, 3750000);
    private static final int fiftyK = ChunkUtils.posToChunkPos(50000);

    @Override
    public void onEnable() {
        Globals.drawManager.registerChunkHighlightProvider(this.getClass(), this::getWindowedHighlightsSnapshot, this::getHighwayColor);
    }

    @Override
    public void onDisable() {
        Globals.drawManager.unregisterChunkHighlightProvider(this.getClass());
    }

    public boolean isHighwayChunk(int x, int z, class_5321<class_1937> dimension) {
        int zAbs;
        if (x == 0 || z == 0) {
            return true;
        }
        int xAbs = Math.abs(x);
        if (xAbs == (zAbs = Math.abs(z))) {
            return true;
        }
        if (dimension == class_1937.field_25180) {
            if (ringRoads.contains(xAbs) && z >= -xAbs && z <= xAbs) {
                return true;
            }
            if (ringRoads.contains(zAbs) && x >= -zAbs && x <= zAbs) {
                return true;
            }
            if (diamonds.contains(xAbs + zAbs)) {
                return true;
            }
            if (xAbs < fiftyK && zAbs < fiftyK) {
                if (xAbs * 16 % 5000 == 0) {
                    return true;
                }
                if (zAbs * 16 % 5000 == 0) {
                    return true;
                }
            }
        }
        return false;
    }

    public LongList getWindowedHighlightsSnapshot(int windowRegionX, int windowRegionZ, int windowRegionSize, class_5321<class_1937> dimension) {
        int minChunkX = ChunkUtils.regionCoordToChunkCoord(windowRegionX - windowRegionSize);
        int maxChunkX = ChunkUtils.regionCoordToChunkCoord(windowRegionX + windowRegionSize);
        int minChunkZ = ChunkUtils.regionCoordToChunkCoord(windowRegionZ - windowRegionSize);
        int maxChunkZ = ChunkUtils.regionCoordToChunkCoord(windowRegionZ + windowRegionSize);
        LongArrayList chunks = new LongArrayList(8);
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                if (!this.isHighwayChunk(x, z, dimension)) continue;
                chunks.add(ChunkUtils.chunkPosToLong(x, z));
            }
        }
        return chunks;
    }

    public int getHighwayColor() {
        return this.highwaysColor;
    }

    public void setRgbColor(int color) {
        this.highwaysColor = ColorHelper.getColorWithAlpha(color, Settings.REGISTRY.highwaysColorAlphaSetting.getAsInt());
    }

    public void setAlpha(double a) {
        this.highwaysColor = ColorHelper.getColorWithAlpha(this.highwaysColor, (int)a);
    }

    private static IntOpenHashSet chunkSetFromPosList(int ... pos) {
        IntOpenHashSet set = new IntOpenHashSet(pos.length);
        for (int i = 0; i < pos.length; ++i) {
            set.add(ChunkUtils.posToChunkPos(pos[i]));
        }
        return set;
    }
}

