/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import net.lenni0451.lambdaevents.EventHandler;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2334;
import net.minecraft.class_2338;
import net.minecraft.class_2423;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2812;
import net.minecraft.class_2818;
import net.minecraft.class_5321;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.event.ChunkBlockUpdateEvent;
import xaeroplus.event.ChunkBlocksUpdateEvent;
import xaeroplus.event.ChunkDataEvent;
import xaeroplus.feature.render.highlights.SavableHighlightCacheInstance;
import xaeroplus.module.Module;
import xaeroplus.settings.Settings;
import xaeroplus.util.ChunkScanner;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;

public class Portals
extends Module {
    private final SavableHighlightCacheInstance portalsCache = new SavableHighlightCacheInstance("XaeroPlusPortals");
    private int portalsColor = ColorHelper.getColor(0, 255, 0, 100);
    private static final ReferenceSet<class_2248> PORTAL_BLOCKS = ReferenceOpenHashSet.of((Object[])new class_2248[]{class_2246.field_10027, class_2246.field_10613, class_2246.field_10316, class_2246.field_10398});

    public void setDiskCache(boolean disk) {
        this.portalsCache.setDiskCache(disk, this.isEnabled());
    }

    @Override
    public void onEnable() {
        Globals.drawManager.registerChunkHighlightProvider(this.getClass(), this::getHighlightsSnapshot, this::getPortalsColor);
        this.portalsCache.onEnable();
        this.searchAllLoadedChunks();
    }

    @Override
    public void onDisable() {
        this.portalsCache.onDisable();
        Globals.drawManager.unregisterChunkHighlightProvider(this.getClass());
    }

    @EventHandler
    public void onChunkData(ChunkDataEvent event) {
        this.findPortalInChunkAsync((class_2791)event.chunk());
    }

    @EventHandler
    public void onMultiBlockUpdate(ChunkBlocksUpdateEvent event) {
        event.packet().method_30621(this::handleBlockChange);
    }

    @EventHandler
    public void onBlockUpdate(ChunkBlockUpdateEvent event) {
        this.handleBlockChange(event.packet().method_11309(), event.packet().method_11308());
    }

    private void findPortalInChunkAsync(class_2791 chunk) {
        this.findPortalInChunkAsync(chunk, 0);
    }

    private void findPortalInChunkAsync(class_2791 chunk, int waitMs) {
        if (chunk == null) {
            return;
        }
        Globals.moduleExecutorService.get().execute(() -> {
            try {
                Thread.sleep(waitMs);
                int iterations = 0;
                while (iterations++ < 3 && !this.findPortalInChunk(chunk)) {
                    Thread.sleep(500L);
                }
            }
            catch (Throwable e) {
                XaeroPlus.LOGGER.debug("Error searching for portal in chunk: {}, {}", new Object[]{chunk.method_12004().field_9181, chunk.method_12004().field_9180, e});
            }
        });
    }

    private boolean findPortalInChunk(class_2791 chunk) {
        boolean chunkHadPortal = this.portalsCache.get().isHighlighted(chunk.method_12004().field_9181, chunk.method_12004().field_9180, ChunkUtils.getActualDimension());
        boolean hasPortal = ChunkScanner.chunkContainsBlocks(chunk, PORTAL_BLOCKS, this.mc.field_1687.method_31607());
        if (hasPortal) {
            return this.portalsCache.get().addHighlight(chunk.method_12004().field_9181, chunk.method_12004().field_9180);
        }
        if (chunkHadPortal) {
            this.portalsCache.get().removeHighlight(chunk.method_12004().field_9181, chunk.method_12004().field_9180);
        }
        return true;
    }

    private boolean findPortalAtBlockPos(class_2338 pos) {
        if (this.mc.field_1687 == null) {
            return false;
        }
        int chunkX = ChunkUtils.posToChunkPos(pos.method_10263());
        int chunkZ = ChunkUtils.posToChunkPos(pos.method_10260());
        class_2818 worldChunk = this.mc.field_1687.method_2935().method_12126(chunkX, chunkZ, false);
        if (worldChunk == null || worldChunk instanceof class_2812) {
            return false;
        }
        class_2680 blockState = worldChunk.method_8320(pos);
        return blockState.method_26204() instanceof class_2423 || blockState.method_26204() instanceof class_2334;
    }

    private void searchAllLoadedChunks() {
        if (this.mc.field_1687 == null) {
            return;
        }
        int renderDist = (Integer)this.mc.field_1690.method_42503().method_41753();
        int xMin = ChunkUtils.getPlayerChunkX() - renderDist;
        int xMax = ChunkUtils.getPlayerChunkX() + renderDist;
        int zMin = ChunkUtils.getPlayerChunkZ() - renderDist;
        int zMax = ChunkUtils.getPlayerChunkZ() + renderDist;
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                class_2818 chunk = this.mc.field_1687.method_2935().method_12126(x, z, false);
                if (chunk instanceof class_2812) continue;
                this.findPortalInChunkAsync((class_2791)chunk);
            }
        }
    }

    private void handleBlockChange(class_2338 pos, class_2680 state) {
        int chunkX = ChunkUtils.posToChunkPos(pos.method_10263());
        int chunkZ = ChunkUtils.posToChunkPos(pos.method_10260());
        if (this.portalsCache.get().isHighlighted(chunkX, chunkZ, ChunkUtils.getActualDimension())) {
            if (this.findPortalAtBlockPos(pos)) {
                if (this.mc.field_1687 == null || this.mc.field_1687.method_2935() == null) {
                    return;
                }
                class_2818 worldChunk = this.mc.field_1687.method_2935().method_12126(chunkX, chunkZ, false);
                if (worldChunk != null && !(worldChunk instanceof class_2812)) {
                    this.findPortalInChunkAsync((class_2791)worldChunk, 250);
                }
            }
        } else if (state.method_26204() instanceof class_2423 || state.method_26204() instanceof class_2334) {
            this.portalsCache.get().addHighlight(chunkX, chunkZ);
        }
    }

    public int getPortalsColor() {
        return this.portalsColor;
    }

    public void setRgbColor(int color) {
        this.portalsColor = ColorHelper.getColorWithAlpha(color, Settings.REGISTRY.portalsAlphaSetting.getAsInt());
    }

    public void setAlpha(double a) {
        this.portalsColor = ColorHelper.getColorWithAlpha(this.portalsColor, (int)a);
    }

    public boolean isPortalChunk(int chunkPosX, int chunkPosZ, class_5321<class_1937> dimensionId) {
        return this.portalsCache.get().isHighlighted(chunkPosX, chunkPosZ, dimensionId);
    }

    public LongList getHighlightsSnapshot(int windowRegionX, int windowRegionZ, int windowRegionSize, class_5321<class_1937> dimension) {
        return this.portalsCache.get().getHighlightsSnapshot(dimension);
    }
}

