/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import com.google.common.hash.Hashing;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.lenni0451.lambdaevents.EventHandler;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.set.WaypointSet;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.minimap.world.MinimapWorldManager;
import xaero.hud.minimap.world.container.MinimapWorldContainer;
import xaero.hud.minimap.world.container.MinimapWorldRootContainer;
import xaero.hud.path.XaeroPath;
import xaeroplus.XaeroPlus;
import xaeroplus.event.ClientTickEvent;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.mixin.client.AccessorWaypointSet;
import xaeroplus.module.Module;
import xaeroplus.util.BlayWaystonesHelper;
import xaeroplus.util.ColorHelper;
import xaeroplus.util.FabricWaystonesHelper;
import xaeroplus.util.WaystonesHelper;

public class WaystoneSync
extends Module {
    private final BlayWaystonesHelper blayWaystonesHelper = new BlayWaystonesHelper();
    private ColorHelper.WaystoneColor color = ColorHelper.WaystoneColor.RANDOM;
    private boolean separateWaypointSet = false;
    private int visibilityType = 0;

    @Override
    public void onEnable() {
        if (WaystonesHelper.isWaystonesPresent()) {
            this.blayWaystonesHelper.subscribeWaystonesEvent();
        }
        if (WaystonesHelper.isFabricWaystonesPresent()) {
            FabricWaystonesHelper.subcribeWaystonesEventsRunnable.run();
        }
        this.reloadWaystones();
    }

    @Override
    public void onDisable() {
        this.blayWaystonesHelper.toSyncWaystones = Collections.emptyList();
    }

    @EventHandler
    public void onXaeroWorldChangeEvent(XaeroWorldChangeEvent event) {
        if (event.worldId() == null) {
            this.blayWaystonesHelper.toSyncWaystones = Collections.emptyList();
        }
    }

    @EventHandler
    public void onClientTickEvent(ClientTickEvent.Post event) {
        if (WaystonesHelper.isWaystonesPresent()) {
            if (this.blayWaystonesHelper.shouldSync && this.syncBlayWaystones()) {
                this.blayWaystonesHelper.shouldSync = false;
                this.blayWaystonesHelper.toSyncWaystones = Collections.emptyList();
            }
        } else if (WaystonesHelper.isFabricWaystonesPresent() && FabricWaystonesHelper.shouldSync) {
            this.syncFabricWaystones();
            FabricWaystonesHelper.shouldSync = false;
        }
    }

    public void syncFabricWaystones() {
        this.commonWaystoneSync(FabricWaystonesHelper.getWaystones());
    }

    public boolean syncBlayWaystones() {
        return this.commonWaystoneSync(this.blayWaystonesHelper.getToSyncWaystones());
    }

    public boolean commonWaystoneSync(List<Waystone> waystones) {
        try {
            MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
            if (minimapSession == null) {
                return false;
            }
            MinimapWorldManager worldManager = minimapSession.getWorldManager();
            if (worldManager == null) {
                return false;
            }
            MinimapWorld currentWorld = worldManager.getCurrentWorld();
            if (currentWorld == null) {
                return false;
            }
            this.clearWaystoneWaypoints(minimapSession);
            for (Waystone waystone : waystones) {
                try {
                    this.waypointsListSync(waystone, this.getWaypointSet(waystone, minimapSession));
                }
                catch (Exception e) {
                    XaeroPlus.LOGGER.error("Error syncing waystone: {}", (Object)waystone.name(), (Object)e);
                }
            }
            return true;
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error syncing waystones", (Throwable)e);
            return true;
        }
    }

    private void clearWaystoneWaypoints(MinimapSession minimapSession) {
        MinimapWorldRootContainer rootContainer = minimapSession.getWorldManager().getCurrentRootContainer();
        Iterable rootWorlds = rootContainer.getWorlds();
        for (MinimapWorld world : rootWorlds) {
            for (WaypointSet set : world.getIterableWaypointSets()) {
                ((AccessorWaypointSet)set).getList().removeIf(WaystoneSync::isWaystoneWaypoint);
            }
        }
        for (MinimapWorldContainer subContainer : rootContainer.getSubContainers()) {
            for (MinimapWorld world : subContainer.getWorlds()) {
                for (WaypointSet set : world.getIterableWaypointSets()) {
                    ((AccessorWaypointSet)set).getList().removeIf(WaystoneSync::isWaystoneWaypoint);
                }
            }
        }
    }

    private static boolean isWaystoneWaypoint(Waypoint waypoint) {
        return waypoint.isTemporary() && waypoint.getName().endsWith(" [Waystone]");
    }

    private void waypointsListSync(Waystone waystone, WaypointSet waypointsList) {
        Waypoint waystoneWp = new Waypoint(waystone.x(), waystone.y(), waystone.z(), waystone.name() + " [Waystone]", waystone.name().isEmpty() ? "W" : waystone.name().substring(0, 1).toUpperCase(Locale.ROOT), this.getWaystoneColor(waystone), 0, true);
        waystoneWp.setVisibilityType(this.visibilityType);
        waypointsList.add(waystoneWp);
    }

    private WaypointSet getWaypointSet(Waystone waystone, MinimapSession minimapSession) {
        String waypointSetName = this.separateWaypointSet ? "Waystones" : "xaeroplus.gui.xaero_default";
        MinimapWorld waypointWorld = this.getWaypointWorldForWaystone(waystone, minimapSession);
        WaypointSet waypointSet = waypointWorld.getWaypointSet(waypointSetName);
        if (waypointSet == null) {
            waypointSet = WaypointSet.Builder.begin().setName(waypointSetName).build();
            waypointWorld.addWaypointSet(waypointSet);
        }
        return waypointSet;
    }

    private MinimapWorld getWaypointWorldForWaystone(Waystone waystone, MinimapSession minimapSession) {
        class_5321<class_1937> waystoneDimension = waystone.dimension();
        String waystoneDimensionDirectoryName = minimapSession.getDimensionHelper().getDimensionDirectoryName(waystoneDimension);
        MinimapWorld currentWpWorld = minimapSession.getWorldManager().getCurrentWorld();
        if (currentWpWorld == null) {
            throw new RuntimeException("WaystoneSync: current waypoint world is null");
        }
        if (currentWpWorld.getDimId() == waystoneDimension) {
            return currentWpWorld;
        }
        String waystoneWpWorldNode = minimapSession.getWorldStateUpdater().getPotentialWorldNode(waystoneDimension, true, minimapSession);
        XaeroPath waystoneWpContainerPath = minimapSession.getWorldState().getAutoRootContainerPath().resolve(waystoneDimensionDirectoryName).resolve(waystoneWpWorldNode);
        return minimapSession.getWorldManager().getWorld(waystoneWpContainerPath);
    }

    private int getWaystoneColor(Waystone waystone) {
        if (this.color == ColorHelper.WaystoneColor.RANDOM) {
            return Math.abs(Hashing.murmur3_128().hashUnencodedChars((CharSequence)waystone.name()).asInt()) % ModSettings.COLORS.length;
        }
        return this.color.getColorIndex();
    }

    public void setColor(ColorHelper.WaystoneColor color) {
        this.color = color;
        this.reloadWaystones();
    }

    public void setWaypointSet(boolean waypointSet) {
        this.separateWaypointSet = waypointSet;
        this.reloadWaystones();
    }

    public void setVisibilityType(int visibilityType) {
        this.visibilityType = visibilityType;
        this.reloadWaystones();
    }

    public void reloadWaystones() {
        this.blayWaystonesHelper.shouldSync = true;
        FabricWaystonesHelper.shouldSync = true;
    }

    public record Waystone(String name, class_5321<class_1937> dimension, int x, int y, int z) {
    }
}

