/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import org.waste.of.time.storage.cache.HotCache;
import xaeroplus.Globals;
import xaeroplus.module.Module;
import xaeroplus.settings.Settings;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;
import xaeroplus.util.WorldToolsHelper;

public class WorldTools
extends Module {
    private int worldToolsColor = ColorHelper.getColor(0, 255, 0, 100);

    @Override
    public void onEnable() {
        if (!WorldToolsHelper.isWorldToolsPresent()) {
            return;
        }
        Globals.drawManager.registerChunkHighlightProvider(this.getClass(), this::getWindowedHighlightsSnapshot, this::getWorldToolsColor);
    }

    @Override
    public void onDisable() {
        Globals.drawManager.unregisterChunkHighlightProvider(this.getClass());
    }

    public boolean isChunkDownloaded(int x, int z, class_5321<class_1937> dimension) {
        return WorldToolsHelper.isDownloading() && dimension == ChunkUtils.getActualDimension() && HotCache.INSTANCE.isChunkSaved(x, z);
    }

    public LongList getWindowedHighlightsSnapshot(int windowRegionX, int windowRegionZ, int windowRegionSize, class_5321<class_1937> dimension) {
        int minChunkX = ChunkUtils.regionCoordToChunkCoord(windowRegionX - windowRegionSize);
        int maxChunkX = ChunkUtils.regionCoordToChunkCoord(windowRegionX + windowRegionSize);
        int minChunkZ = ChunkUtils.regionCoordToChunkCoord(windowRegionZ - windowRegionSize);
        int maxChunkZ = ChunkUtils.regionCoordToChunkCoord(windowRegionZ + windowRegionSize);
        LongArrayList chunks = new LongArrayList(8);
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                if (!this.isChunkDownloaded(x, z, dimension)) continue;
                chunks.add(ChunkUtils.chunkPosToLong(x, z));
            }
        }
        return chunks;
    }

    public int getWorldToolsColor() {
        return this.worldToolsColor;
    }

    public void setRgbColor(int color) {
        this.worldToolsColor = ColorHelper.getColorWithAlpha(color, Settings.REGISTRY.worldToolsAlphaSetting.getAsInt());
    }

    public void setAlpha(double alpha) {
        this.worldToolsColor = ColorHelper.getColorWithAlpha(this.worldToolsColor, (int)alpha);
    }
}

