/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.settings;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.class_304;
import xaero.common.graphics.CursorBox;
import xaero.common.settings.ModOptions;
import xaeroplus.XaeroPlus;
import xaeroplus.mixin.client.AccessorMinimapModOptions;
import xaeroplus.mixin.client.AccessorWorldMapModOptions;
import xaeroplus.settings.XaeroPlusSetting;

public class BooleanSetting
extends XaeroPlusSetting {
    private boolean value;
    private BooleanConsumer settingChangeConsumer;

    private BooleanSetting(String settingName, String settingNameTranslationKey, String tooltipTranslationKey, class_304 keyBinding, boolean value, BooleanConsumer settingChangeConsumer, BooleanSupplier visibilitySupplier) {
        super(settingName, settingNameTranslationKey, tooltipTranslationKey, keyBinding, visibilitySupplier);
        this.value = value;
        this.settingChangeConsumer = settingChangeConsumer;
    }

    public static BooleanSetting create(String settingName, String settingNameTranslationKey, boolean defaultValue) {
        return new BooleanSetting("[XP] " + settingName, settingNameTranslationKey, BooleanSetting.buildTooltipTranslationKey(settingNameTranslationKey), new class_304(settingNameTranslationKey, -1, "XaeroPlus"), defaultValue, null, null);
    }

    public static BooleanSetting create(String settingName, String settingNameTranslationKey, boolean defaultValue, BooleanConsumer settingChangeConsumer) {
        return new BooleanSetting("[XP] " + settingName, settingNameTranslationKey, BooleanSetting.buildTooltipTranslationKey(settingNameTranslationKey), new class_304(settingNameTranslationKey, -1, "XaeroPlus"), defaultValue, settingChangeConsumer, null);
    }

    public static BooleanSetting create(String settingName, String settingNameTranslationKey, boolean defaultValue, BooleanSupplier visibilitySupplier) {
        return new BooleanSetting("[XP] " + settingName, settingNameTranslationKey, BooleanSetting.buildTooltipTranslationKey(settingNameTranslationKey), new class_304(settingNameTranslationKey, -1, "XaeroPlus"), defaultValue, null, visibilitySupplier);
    }

    public static BooleanSetting create(String settingName, String settingNameTranslationKey, boolean defaultValue, BooleanConsumer settingChangeConsumer, BooleanSupplier visibilitySupplier) {
        return new BooleanSetting("[XP] " + settingName, settingNameTranslationKey, BooleanSetting.buildTooltipTranslationKey(settingNameTranslationKey), new class_304(settingNameTranslationKey, -1, "XaeroPlus"), defaultValue, settingChangeConsumer, visibilitySupplier);
    }

    @Override
    public String getSerializedValue() {
        return Boolean.toString(this.value);
    }

    @Override
    public void deserializeValue(String value) {
        boolean v = Boolean.parseBoolean(value);
        if (v != this.get()) {
            this.setValue(v);
        }
    }

    @Override
    public ModOptions toMinimapModOptions() {
        return AccessorMinimapModOptions.createBooleanSetting(this.getSettingName(), new CursorBox(this.getTooltipTranslationKey()), this.isIngameOnly());
    }

    @Override
    public xaero.map.settings.ModOptions toWorldMapModOptions() {
        return AccessorWorldMapModOptions.createBooleanSetting(this.getSettingName(), new xaero.map.gui.CursorBox(this.getTooltipTranslationKey()), this.isIngameOnly(), this.isRequiresMinimap(), false);
    }

    public boolean get() {
        return this.value;
    }

    public void setValue(boolean value) {
        this.value = value;
        if (Objects.nonNull(this.getSettingChangeConsumer())) {
            try {
                this.getSettingChangeConsumer().accept(value);
            }
            catch (Exception e) {
                XaeroPlus.LOGGER.warn("Error applying setting change consumer for {}", (Object)this.getSettingName(), (Object)e);
            }
        }
    }

    public Consumer<Boolean> getSettingChangeConsumer() {
        return this.settingChangeConsumer;
    }

    public void setSettingChangeConsumer(BooleanConsumer settingChangeConsumer) {
        this.settingChangeConsumer = settingChangeConsumer;
    }

    @Override
    public void init() {
        if (Objects.nonNull(this.settingChangeConsumer)) {
            this.settingChangeConsumer.accept(this.value);
        }
    }
}

