/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.blocks;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3312;

public abstract class BaseFrameBlockTile
extends class_2586 {
    protected GameProfile owner;
    private static class_3312 profileCache;
    @Nullable
    private static MinecraftSessionService sessionService;
    @Nullable
    private static Executor mainThreadExecutor;

    protected BaseFrameBlockTile(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    protected void method_11007(class_2487 cmp) {
        super.method_11007(cmp);
        if (this.owner != null) {
            cmp.method_25927("PlayerID", this.owner.getId());
        }
    }

    public void method_11014(class_2487 cmp) {
        super.method_11014(cmp);
        if (cmp.method_10545("PlayerID")) {
            UUID id = cmp.method_25926("PlayerID");
            this.setOwner(new GameProfile(id, null));
        }
    }

    public GameProfile getOwner() {
        return this.owner;
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(@Nullable GameProfile input) {
        if (!(this.owner != null || input != null && input.isComplete())) {
            BaseFrameBlockTile baseFrameBlockTile = this;
            synchronized (baseFrameBlockTile) {
                this.owner = input;
            }
            BaseFrameBlockTile.updateGameProfile(this.owner, gameProfile -> {
                this.owner = gameProfile;
            });
        }
    }

    public static void updateGameProfile(@Nullable GameProfile gameProfile, Consumer<GameProfile> consumer) {
        if (!(gameProfile == null || gameProfile.getId() == null || gameProfile.isComplete() && gameProfile.getName() != null || profileCache == null || sessionService == null)) {
            Optional profile = profileCache.method_14512(gameProfile.getId());
            class_156.method_18349().execute(() -> class_156.method_17974((Optional)profile, p -> {
                if (p.getName() == null) {
                    p = sessionService.fillProfileProperties(p, true);
                }
                GameProfile finalGp = p;
                mainThreadExecutor.execute(() -> {
                    profileCache.method_14508(finalGp);
                    consumer.accept(finalGp);
                });
            }, () -> mainThreadExecutor.execute(() -> consumer.accept(gameProfile))));
        } else {
            consumer.accept(gameProfile);
        }
    }

    public static void setup(class_3312 gameProfileCache, MinecraftSessionService minecraftSessionService, Executor executor) {
        profileCache = gameProfileCache;
        sessionService = minecraftSessionService;
        mainThreadExecutor = executor;
    }

    public static void clear() {
        profileCache = null;
        sessionService = null;
        mainThreadExecutor = null;
    }

    @Nullable
    public class_2561 getOwnerName() {
        if (this.owner != null) {
            String name = this.owner.getName();
            if (name == null) {
                return null;
            }
            return class_2561.method_43470((String)name);
        }
        return null;
    }

    @Nullable
    public abstract class_2561 getTitle();

    public abstract class_124 getTitleColor();

    public abstract boolean isEmpty();
}

