/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.client;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.mehvahdjukaar.advframes.blocks.AdvancementFrameBlock;
import net.mehvahdjukaar.advframes.blocks.StatFrameBlock;
import net.mehvahdjukaar.advframes.blocks.StatFrameBlockTile;
import net.mehvahdjukaar.advframes.client.BaseFrameTileRenderer;
import net.mehvahdjukaar.advframes.client.ClientConfigs;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.client.util.TextUtil;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2769;
import net.minecraft.class_327;
import net.minecraft.class_3445;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5614;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class StatFrameBlockTileRenderer
extends BaseFrameTileRenderer<StatFrameBlockTile> {
    private static final float PAPER_Y_MARGIN = 0.40625f;
    private static final float PAPER_X_MARGIN = 0.125f;

    public StatFrameBlockTileRenderer(class_5614.class_5615 context) {
        super(context);
    }

    public void render(StatFrameBlockTile tile, float partialTick, class_4587 poseStack, class_4597 buffer, int light, int packedOverlay) {
        class_3445<?> stat = tile.getStat();
        if (stat != null) {
            float dx;
            class_2350 dir = (class_2350)tile.method_11010().method_11654((class_2769)StatFrameBlock.FACING);
            float yaw = -dir.method_10144();
            class_243 cameraPos = this.camera.method_19326();
            class_2338 pos = tile.method_11016();
            LOD lod = new LOD(cameraPos, pos);
            poseStack.method_22903();
            poseStack.method_22904(0.5, 0.5, 0.5);
            poseStack.method_22907(RotHlpr.rot((class_2350)((class_2350)tile.method_11010().method_11654((class_2769)AdvancementFrameBlock.FACING)).method_10153()));
            double z = -0.4275;
            poseStack.method_22904(0.0, 0.0, z);
            poseStack.method_22903();
            poseStack.method_22904(0.0, 0.6875, -0.03025);
            TextUtil.RenderProperties textProperties = this.computeRenderProperties(light, dir.method_23955(), () -> ((LOD)lod).isVeryNear());
            if (tile.needsVisualUpdate()) {
                this.updateAndCacheLines(tile, stat, textProperties);
            }
            List<class_5481> rendererLines = tile.getCachedLines();
            float scale = tile.getFontScale();
            poseStack.method_22905(scale, -scale, scale);
            int numberOfLines = rendererLines.size();
            boolean centered = ClientConfigs.CENTERED_TEXT.get();
            for (int lin = 0; lin < numberOfLines; ++lin) {
                class_5481 str = rendererLines.get(lin);
                dx = centered ? (float)(-this.font.method_30880(str)) / 2.0f + 0.5f : -0.375f / scale;
                float dy = (1.0f / scale - (float)(8 * numberOfLines)) / 2.0f + 0.5f;
                Matrix4f pose = poseStack.method_23760().method_23761();
                this.font.method_22942(str, dx, dy + (float)(8 * lin), textProperties.darkenedColor(), false, pose, buffer, class_327.class_6415.field_33993, 0, textProperties.light());
            }
            poseStack.method_22909();
            poseStack.method_22903();
            poseStack.method_22904(0.0, 0.5625, -0.03025);
            float valueScale = 0.015625f;
            poseStack.method_22905(valueScale, -valueScale, valueScale);
            String number = stat.method_14953(tile.getValue());
            dx = centered ? (float)(-this.font.method_1727(number)) / 2.0f + 0.5f : -0.375f / scale;
            class_5250 c = class_2561.method_43470((String)number).method_27692(class_124.field_1079);
            this.font.method_30882((class_2561)c, dx, 40.0f, textProperties.darkenedColor(), true, poseStack.method_23760().method_23761(), buffer, class_327.class_6415.field_33993, 0, textProperties.light());
            poseStack.method_22909();
            this.renderTopTextBottomText(lod, tile, poseStack, buffer, light, 0.3125f);
            poseStack.method_22909();
        }
    }

    private void updateAndCacheLines(StatFrameBlockTile tile, class_3445<?> stat, TextUtil.RenderProperties textProperties) {
        float paperWidth = 0.75f;
        float paperHeight = 0.1875f;
        class_5250 text = StatFrameBlock.getStatComponent(stat);
        text = text.method_10862(textProperties.style());
        Pair p = TextUtil.fitLinesToBox((class_327)this.font, (class_5348)text, (float)paperWidth, (float)paperHeight);
        tile.setFontScale(((Float)p.getSecond()).floatValue());
        tile.setCachedPageLines((List)p.getFirst());
    }

    public TextUtil.RenderProperties computeRenderProperties(int combinedLight, Vector3f normal, BooleanSupplier shouldShowGlow) {
        return TextUtil.renderProperties((class_1767)class_1767.field_7963, (boolean)false, (float)ClientConfigs.getSignColorMult(), (int)combinedLight, (class_2583)class_2583.field_24360, (Vector3f)normal, (BooleanSupplier)shouldShowGlow);
    }
}

