/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.mehvahdjukaar.advframes.blocks.StatFrameBlockTile;
import net.mehvahdjukaar.advframes.network.NetworkHandler;
import net.mehvahdjukaar.advframes.network.ServerBoundSetStatFramePacket;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_3468;
import net.minecraft.class_3469;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_452;
import net.minecraft.class_5244;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class StatSelectScreen
extends class_437
implements class_452 {
    private final StatFrameBlockTile tile;
    private static final class_2561 PENDING_TEXT = class_2561.method_43471((String)"multiplayer.downloadingStats");
    private static final class_2960 STATS_ICON_LOCATION = new class_2960("textures/gui/container/stats_icons.png");
    private GeneralStatisticsList statsList;
    ItemStatisticsList itemStatsList;
    private MobsStatisticsList mobsStatsList;
    final class_3469 stats;
    @Nullable
    private class_4280<?> activeList;
    private boolean isLoading = true;

    public StatSelectScreen(StatFrameBlockTile tile, class_3469 statsCounter) {
        super((class_2561)class_2561.method_43471((String)"advancementframes.gui.statistics"));
        this.tile = tile;
        this.stats = statsCounter;
    }

    protected void method_25426() {
        this.isLoading = true;
        this.field_22787.method_1562().method_2883((class_2596)new class_2799(class_2799.class_2800.field_12775));
    }

    public void initLists() {
        this.statsList = new GeneralStatisticsList(this.field_22787);
        this.itemStatsList = new ItemStatisticsList(this.field_22787);
        this.mobsStatsList = new MobsStatisticsList(this.field_22787);
    }

    public void initButtons() {
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"stat.generalButton"), buttonx -> this.setActiveList(this.statsList)).method_46434(this.field_22789 / 2 - 120, this.field_22790 - 52, 80, 20).method_46431());
        class_4185 button = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"stat.itemsButton"), buttonx -> this.setActiveList(this.itemStatsList)).method_46434(this.field_22789 / 2 - 40, this.field_22790 - 52, 80, 20).method_46431());
        class_4185 button2 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"stat.mobsButton"), buttonx -> this.setActiveList(this.mobsStatsList)).method_46434(this.field_22789 / 2 + 40, this.field_22790 - 52, 80, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, buttonx -> this.field_22787.method_1507(null)).method_46434(this.field_22789 / 2 - 100, this.field_22790 - 28, 200, 20).method_46431());
        if (this.itemStatsList.method_25396().isEmpty()) {
            button.field_22763 = false;
        }
        if (this.mobsStatsList.method_25396().isEmpty()) {
            button2.field_22763 = false;
        }
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        if (this.isLoading) {
            this.method_25420(guiGraphics);
            guiGraphics.method_27534(this.field_22793, PENDING_TEXT, this.field_22789 / 2, this.field_22790 / 2, 0xFFFFFF);
            String var10002 = field_2668[(int)(class_156.method_658() / 150L % (long)field_2668.length)];
            int midX = this.field_22789 / 2;
            int mixY = this.field_22790 / 2;
            Objects.requireNonNull(this.field_22793);
            guiGraphics.method_25300(this.field_22793, var10002, midX, mixY + 18, 0xFFFFFF);
        } else {
            this.getActiveList().method_25394(guiGraphics, i, j, f);
            guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, 0xFFFFFF);
            super.method_25394(guiGraphics, i, j, f);
        }
    }

    public void method_2300() {
        if (this.isLoading) {
            this.initLists();
            this.initButtons();
            this.setActiveList(this.statsList);
            this.isLoading = false;
        }
    }

    public boolean method_25421() {
        return !this.isLoading;
    }

    @Nullable
    public class_4280<?> getActiveList() {
        return this.activeList;
    }

    public void setActiveList(@Nullable class_4280<?> activeList) {
        if (this.activeList != null) {
            this.method_37066((class_364)this.activeList);
        }
        if (activeList != null) {
            this.method_25429((class_364)activeList);
            this.activeList = activeList;
        }
    }

    static String getTranslationKey(class_3445<class_2960> stat) {
        String string = ((class_2960)stat.method_14951()).toString();
        return "stat." + string.replace(':', '.');
    }

    int getColumnX(int index) {
        return 115 + 40 * index;
    }

    void blitSlot(class_332 guiGraphics, int i, int j, class_1792 item) {
        this.blitSlotIcon(guiGraphics, i + 1, j + 1, 0, 0);
        guiGraphics.method_51445(item.method_7854(), i + 2, j + 2);
    }

    void blitSlotIcon(class_332 guiGraphics, int i, int j, int k, int l) {
        guiGraphics.method_25291(STATS_ICON_LOCATION, i, j, 0, (float)k, (float)l, 18, 18, 128, 128);
    }

    private <T> void selectStat(class_3448<T> statType, T obj) {
        NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundSetStatFramePacket(this.tile.method_11016(), statType, obj));
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
        this.method_25419();
    }

    class GeneralStatisticsList
    extends class_4280<Entry> {
        public GeneralStatisticsList(class_310 minecraft) {
            super(minecraft, StatSelectScreen.this.field_22789 - 8, StatSelectScreen.this.field_22790, 32, StatSelectScreen.this.field_22790 - 64, 10);
            ObjectArrayList objectArrayList = new ObjectArrayList(class_3468.field_15419.iterator());
            objectArrayList.sort(Comparator.comparing(statx -> class_1074.method_4662((String)StatSelectScreen.getTranslationKey((class_3445<class_2960>)statx), (Object[])new Object[0])));
            for (class_3445 stat : objectArrayList) {
                this.method_25321((class_350.class_351)new Entry((class_3445<class_2960>)stat));
            }
            this.method_31322(false);
            this.method_31323(false);
        }

        protected void method_25325(class_332 guiGraphics) {
            StatSelectScreen.this.method_25420(guiGraphics);
        }

        private class Entry
        extends class_4280.class_4281<Entry> {
            private final class_3445<class_2960> stat;
            private final class_2561 statDisplay;

            Entry(class_3445<class_2960> stat) {
                this.stat = stat;
                this.statDisplay = class_2561.method_43471((String)StatSelectScreen.getTranslationKey(stat));
            }

            private String getValueText() {
                return this.stat.method_14953(StatSelectScreen.this.stats.method_15025(this.stat));
            }

            public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                guiGraphics.method_27535(StatSelectScreen.this.field_22793, this.statDisplay, left += 2, ++top, index % 2 == 0 ? 0xFFFFFF : 0x909090);
                String string = this.getValueText();
                guiGraphics.method_25303(StatSelectScreen.this.field_22793, string, left + width - StatSelectScreen.this.field_22793.method_1727(string), top, index % 2 == 0 ? 0xFFFFFF : 0x909090);
                if (isMouseOver) {
                    guiGraphics.method_51740(class_1921.method_51785(), left, top, left + width, top + height + 2, -2130706433, -2130706433, 0);
                }
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                StatSelectScreen.this.selectStat(this.stat.method_14949(), (class_2960)this.stat.method_14951());
                return false;
            }

            public class_2561 method_37006() {
                return class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{class_2561.method_43473().method_10852(this.statDisplay).method_10852(class_5244.field_41874).method_27693(this.getValueText())});
            }
        }
    }

    class ItemStatisticsList
    extends class_4280<ItemRow> {
        protected final List<class_3448<class_2248>> blockColumns;
        protected final List<class_3448<class_1792>> itemColumns;
        private final int[] iconOffsets;
        protected int headerPressed;
        protected final Comparator<ItemRow> itemStatSorter;
        @Nullable
        protected class_3448<?> sortColumn;
        protected int sortOrder;

        public ItemStatisticsList(class_310 minecraft) {
            boolean success;
            super(minecraft, StatSelectScreen.this.field_22789, StatSelectScreen.this.field_22790, 32, StatSelectScreen.this.field_22790 - 64, 20);
            this.blockColumns = Lists.newArrayList();
            this.iconOffsets = new int[]{3, 4, 1, 2, 5, 6};
            this.headerPressed = -1;
            this.itemStatSorter = new ItemRowComparator();
            this.blockColumns.add((class_3448<class_2248>)class_3468.field_15427);
            this.itemColumns = Lists.newArrayList((Object[])new class_3448[]{class_3468.field_15383, class_3468.field_15370, class_3468.field_15372, class_3468.field_15392, class_3468.field_15405});
            this.method_25315(true, 20);
            Set set = Sets.newIdentityHashSet();
            for (class_1792 item : class_7923.field_41178) {
                success = false;
                for (class_3448<class_1792> class_34482 : this.itemColumns) {
                    if (!class_34482.method_14958((Object)item) || StatSelectScreen.this.stats.method_15025(class_34482.method_14956((Object)item)) <= 0) continue;
                    success = true;
                }
                if (!success) continue;
                set.add(item);
            }
            for (class_2248 block : class_7923.field_41175) {
                success = false;
                for (class_3448<class_1792> class_34483 : this.blockColumns) {
                    if (!class_34483.method_14958((Object)block) || StatSelectScreen.this.stats.method_15025(class_34483.method_14956((Object)block)) <= 0) continue;
                    success = true;
                }
                if (!success) continue;
                set.add(block.method_8389());
            }
            set.remove(class_1802.field_8162);
            for (class_1792 item : set) {
                this.method_25321((class_350.class_351)new ItemRow(item));
            }
            this.method_31322(false);
            this.method_31323(false);
        }

        protected void method_25325(class_332 guiGraphics) {
            StatSelectScreen.this.method_25420(guiGraphics);
        }

        protected void method_25312(class_332 guiGraphics, int i, int j) {
            int l;
            int k;
            if (!this.field_22740.field_1729.method_1608()) {
                this.headerPressed = -1;
            }
            for (k = 0; k < this.iconOffsets.length; ++k) {
                StatSelectScreen.this.blitSlotIcon(guiGraphics, i + StatSelectScreen.this.getColumnX(k) - 18, j + 1, 0, this.headerPressed == k ? 0 : 18);
            }
            if (this.sortColumn != null) {
                k = StatSelectScreen.this.getColumnX(this.getColumnIndex(this.sortColumn)) - 36;
                l = this.sortOrder == 1 ? 2 : 1;
                StatSelectScreen.this.blitSlotIcon(guiGraphics, i + k, j + 1, 18 * l, 0);
            }
            for (k = 0; k < this.iconOffsets.length; ++k) {
                l = this.headerPressed == k ? 1 : 0;
                StatSelectScreen.this.blitSlotIcon(guiGraphics, i + StatSelectScreen.this.getColumnX(k) - 18 + l, j + 1 + l, 18 * this.iconOffsets[k], 18);
            }
        }

        public int method_25322() {
            return 375;
        }

        protected int method_25329() {
            return this.field_22742 / 2 + 140;
        }

        protected void method_25310(int mouseX, int mouseY) {
            this.headerPressed = -1;
            for (int i = 0; i < this.iconOffsets.length; ++i) {
                int j = mouseX - StatSelectScreen.this.getColumnX(i);
                if (j < -36 || j > 0) continue;
                this.headerPressed = i;
                break;
            }
            if (this.headerPressed >= 0) {
                this.sortByColumn(this.getColumn(this.headerPressed));
                this.field_22740.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            }
        }

        private class_3448<?> getColumn(int index) {
            return index < this.blockColumns.size() ? this.blockColumns.get(index) : this.itemColumns.get(index - this.blockColumns.size());
        }

        private int getColumnIndex(class_3448<?> statType) {
            int i = this.blockColumns.indexOf(statType);
            if (i >= 0) {
                return i;
            }
            int j = this.itemColumns.indexOf(statType);
            return j >= 0 ? j + this.blockColumns.size() : -1;
        }

        protected void method_25320(class_332 guiGraphics, int mouseX, int mouseY) {
            if (mouseY >= this.field_19085 && mouseY < this.field_19086) {
                ItemRow itemRow = (ItemRow)this.method_37019();
                int k = (this.field_22742 - this.method_25322()) / 2;
                class_2561 component = null;
                if (itemRow != null) {
                    if (mouseX < k + 44 || mouseX > k + 44 + 18) {
                        return;
                    }
                    class_1792 item = itemRow.getItem();
                    component = item.method_7848();
                } else {
                    int l = mouseX - k - 2;
                    for (int m = 0; m < this.iconOffsets.length; ++m) {
                        int n = StatSelectScreen.this.getColumnX(m);
                        if (l < n - 18 || l > n) continue;
                        component = this.getColumn(m).method_30739();
                        break;
                    }
                }
                if (component != null) {
                    StatSelectScreen.this.method_47415(component);
                }
            }
        }

        protected void sortByColumn(class_3448<?> statType) {
            if (statType != this.sortColumn) {
                this.sortColumn = statType;
                this.sortOrder = -1;
            } else if (this.sortOrder == -1) {
                this.sortOrder = 1;
            } else {
                this.sortColumn = null;
                this.sortOrder = 0;
            }
            this.method_25396().sort(this.itemStatSorter);
        }

        private class ItemRowComparator
        implements Comparator<ItemRow> {
            ItemRowComparator() {
            }

            @Override
            public int compare(ItemRow row1, ItemRow row2) {
                int j;
                int i;
                class_1792 item = row1.getItem();
                class_1792 item2 = row2.getItem();
                if (ItemStatisticsList.this.sortColumn == null) {
                    i = 0;
                    j = 0;
                } else if (ItemStatisticsList.this.blockColumns.contains(ItemStatisticsList.this.sortColumn)) {
                    int n;
                    class_1747 bi;
                    class_3448<?> statType = ItemStatisticsList.this.sortColumn;
                    if (item instanceof class_1747) {
                        bi = (class_1747)item;
                        v0 = StatSelectScreen.this.stats.method_15024(statType, (Object)bi.method_7711());
                    } else {
                        v0 = i = -1;
                    }
                    if (item2 instanceof class_1747) {
                        bi = (class_1747)item2;
                        n = StatSelectScreen.this.stats.method_15024(statType, (Object)bi.method_7711());
                    } else {
                        n = -1;
                    }
                    j = n;
                } else {
                    class_3448<?> statType = ItemStatisticsList.this.sortColumn;
                    i = StatSelectScreen.this.stats.method_15024(statType, (Object)item);
                    j = StatSelectScreen.this.stats.method_15024(statType, (Object)item2);
                }
                return i == j ? ItemStatisticsList.this.sortOrder * Integer.compare(class_1792.method_7880((class_1792)item), class_1792.method_7880((class_1792)item2)) : ItemStatisticsList.this.sortOrder * Integer.compare(i, j);
            }
        }

        private class ItemRow
        extends class_4280.class_4281<ItemRow> {
            private final class_1792 item;
            private class_3445<?> hovered = null;

            ItemRow(class_1792 item) {
                this.item = item;
            }

            public class_1792 getItem() {
                return this.item;
            }

            public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                int p;
                StatSelectScreen.this.blitSlot(guiGraphics, left + 40, top, this.item);
                this.hovered = null;
                for (p = 0; p < StatSelectScreen.this.itemStatsList.blockColumns.size(); ++p) {
                    class_3445 stat;
                    class_1792 class_17922 = this.item;
                    if (class_17922 instanceof class_1747) {
                        class_1747 bi = (class_1747)class_17922;
                        stat = StatSelectScreen.this.itemStatsList.blockColumns.get(p).method_14956((Object)bi.method_7711());
                    } else {
                        stat = null;
                    }
                    this.renderStat(guiGraphics, stat, left + StatSelectScreen.this.getColumnX(p), top, index % 2 == 0, isMouseOver, mouseX);
                }
                for (p = 0; p < StatSelectScreen.this.itemStatsList.itemColumns.size(); ++p) {
                    this.renderStat(guiGraphics, StatSelectScreen.this.itemStatsList.itemColumns.get(p).method_14956((Object)this.item), left + StatSelectScreen.this.getColumnX(p + StatSelectScreen.this.itemStatsList.blockColumns.size()), top, index % 2 == 0, isMouseOver, mouseX);
                }
            }

            protected void renderStat(class_332 guiGraphics, @Nullable class_3445<?> stat, int x, int y, boolean odd, boolean isMouseOver, int mouseX) {
                String string = stat == null ? "-" : stat.method_14953(StatSelectScreen.this.stats.method_15025(stat));
                guiGraphics.method_25303(StatSelectScreen.this.field_22793, string, x - StatSelectScreen.this.field_22793.method_1727(string), y + 5, odd ? 0xFFFFFF : 0x909090);
                int w = 18;
                if (stat != null && isMouseOver && mouseX >= x - w && mouseX < x) {
                    guiGraphics.method_51740(class_1921.method_51785(), x - w, y, x, y + w, -2130706433, -2130706433, 0);
                    this.hovered = stat;
                }
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                if (this.hovered != null) {
                    class_3448 type = this.hovered.method_14949();
                    if (type.method_14959() == class_7923.field_41175) {
                        StatSelectScreen.this.selectStat(type, ((class_1747)this.item).method_7711());
                    } else {
                        StatSelectScreen.this.selectStat(type, this.item);
                    }
                }
                return false;
            }

            @Nullable
            public class_2561 method_37006() {
                return class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{this.item.method_7848()});
            }
        }
    }

    class MobsStatisticsList
    extends class_4280<MobRow> {
        public MobsStatisticsList(class_310 minecraft) {
            super(minecraft, StatSelectScreen.this.field_22789, StatSelectScreen.this.field_22790, 32, StatSelectScreen.this.field_22790 - 64, 32);
            for (class_1299 entityType : class_7923.field_41177) {
                if (StatSelectScreen.this.stats.method_15025(class_3468.field_15403.method_14956((Object)entityType)) <= 0 && StatSelectScreen.this.stats.method_15025(class_3468.field_15411.method_14956((Object)entityType)) <= 0) continue;
                this.method_25321((class_350.class_351)new MobRow(entityType));
            }
            this.method_31322(false);
            this.method_31323(false);
        }

        protected void method_25325(class_332 guiGraphics) {
            StatSelectScreen.this.method_25420(guiGraphics);
        }

        private class MobRow
        extends class_4280.class_4281<MobRow> {
            private final class_2561 mobName;
            private final class_2561 kills;
            private final boolean hasKills;
            private final class_2561 killedBy;
            private final boolean wasKilledBy;
            private final class_1299<?> entity;
            private int hovered = 0;

            public MobRow(class_1299<?> entityType) {
                this.entity = entityType;
                this.mobName = entityType.method_5897();
                int entitiesKilled = StatSelectScreen.this.stats.method_15025(class_3468.field_15403.method_14956(entityType));
                if (entitiesKilled == 0) {
                    this.kills = class_2561.method_43469((String)"stat_type.minecraft.killed.none", (Object[])new Object[]{this.mobName});
                    this.hasKills = false;
                } else {
                    this.kills = class_2561.method_43469((String)"stat_type.minecraft.killed", (Object[])new Object[]{entitiesKilled, this.mobName});
                    this.hasKills = true;
                }
                int killedByEntities = StatSelectScreen.this.stats.method_15025(class_3468.field_15411.method_14956(entityType));
                if (killedByEntities == 0) {
                    this.killedBy = class_2561.method_43469((String)"stat_type.minecraft.killed_by.none", (Object[])new Object[]{this.mobName});
                    this.wasKilledBy = false;
                } else {
                    this.killedBy = class_2561.method_43469((String)"stat_type.minecraft.killed_by", (Object[])new Object[]{this.mobName, killedByEntities});
                    this.wasKilledBy = true;
                }
            }

            public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean mouseOver, float partialTicks) {
                this.hovered = 0;
                guiGraphics.method_27535(StatSelectScreen.this.field_22793, this.mobName, left + 2, top + 1, 0xFFFFFF);
                int stringX = left + 2 + 10;
                int stringY = top + 1 + 10;
                guiGraphics.method_27535(StatSelectScreen.this.field_22793, this.kills, stringX, stringY, this.hasKills ? 0x909090 : 0x606060);
                if (mouseY >= stringY && mouseY <= stringY + 9) {
                    this.hovered = 1;
                    guiGraphics.method_51740(class_1921.method_51785(), stringX, stringY, left + width - 12, stringY + 9, -2130706433, -2130706433, 0);
                }
                stringY = top + 1 + 20;
                guiGraphics.method_27535(StatSelectScreen.this.field_22793, this.killedBy, stringX, stringY, this.wasKilledBy ? 0x909090 : 0x606060);
                if (mouseY >= stringY && mouseY <= stringY + 9) {
                    this.hovered = 2;
                    guiGraphics.method_51740(class_1921.method_51785(), stringX, stringY, left + width - 12, stringY + 9, -2130706433, -2130706433, 0);
                }
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                if (this.hovered == 1) {
                    StatSelectScreen.this.selectStat(class_3468.field_15403, this.entity);
                } else if (this.hovered == 2) {
                    StatSelectScreen.this.selectStat(class_3468.field_15411, this.entity);
                }
                return false;
            }

            public class_2561 method_37006() {
                return class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{class_5244.method_37111((class_2561[])new class_2561[]{this.kills, this.killedBy})});
            }
        }
    }
}

