/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.client.renderer.entity;

import com.google.common.collect.ImmutableMap;
import com.kekecreations.arts_and_crafts.common.entity.ACBoat;
import com.kekecreations.arts_and_crafts.common.entity.ACChestBoat;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1690;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4595;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_554;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_630;
import net.minecraft.class_7752;
import net.minecraft.class_7755;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.joml.Quaternionf;

public class ACBoatRenderer
extends class_897<class_1690> {
    public static final class_5601 BOAT = new class_5601(new class_2960("arts_and_crafts", "boat"), "main");
    public static final class_5601 CHEST_BOAT = new class_5601(new class_2960("arts_and_crafts", "chest_boat"), "main");
    private final Map<ACBoat.WoodType, Pair<class_2960, class_4595<class_1690>>> boatResources = (Map)Stream.of(ACBoat.WoodType.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)ACBoatRenderer.getTextureLocation(type, chestBoat), this.createBoatModel(context, (ACBoat.WoodType)((Object)type), chestBoat))));

    public ACBoatRenderer(class_5617.class_5618 context, boolean chestBoat) {
        super(context);
    }

    public void render(class_1690 boat, float entityYaw, float partialTicks, class_4587 matrixStack, class_4597 buffer, int packedLight) {
        float h;
        matrixStack.method_22903();
        matrixStack.method_46416(0.0f, 0.375f, 0.0f);
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - entityYaw));
        float f = (float)boat.method_7533() - partialTicks;
        float g = boat.method_7554() - partialTicks;
        if (g < 0.0f) {
            g = 0.0f;
        }
        if (f > 0.0f) {
            matrixStack.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_15374((float)f) * f * g / 10.0f * (float)boat.method_7543()));
        }
        if (!class_3532.method_15347((float)(h = boat.method_7547(partialTicks)), (float)0.0f)) {
            matrixStack.method_22907(new Quaternionf().setAngleAxis(boat.method_7547(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<class_2960, class_4595<class_1690>> pair = this.getBoatPair(boat);
        class_2960 resourceLocation = (class_2960)pair.getFirst();
        class_4595 listModel = (class_4595)pair.getSecond();
        matrixStack.method_22905(-1.0f, -1.0f, 1.0f);
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        listModel.method_2819((class_1297)boat, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        class_4588 vertexConsumer = buffer.getBuffer(listModel.method_23500(resourceLocation));
        listModel.method_2828(matrixStack, vertexConsumer, packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!boat.method_5869()) {
            class_4588 vertexConsumer2 = buffer.getBuffer(class_1921.method_23589());
            if (listModel instanceof class_7755) {
                class_7755 waterPatchModel = (class_7755)listModel;
                waterPatchModel.method_22954().method_22698(matrixStack, vertexConsumer2, packedLight, class_4608.field_21444);
            }
        }
        matrixStack.method_22909();
        super.method_3936((class_1297)boat, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    private class_4595<class_1690> createBoatModel(class_5617.class_5618 context, ACBoat.WoodType type, boolean chestBoat) {
        class_630 modelPart = context.method_32167(chestBoat ? CHEST_BOAT : BOAT);
        return chestBoat ? new class_7752(modelPart) : new class_554(modelPart);
    }

    private static class_2960 getTextureLocation(ACBoat.WoodType type, boolean chestBoat) {
        String path = chestBoat ? "textures/entity/chest_boat/" + type.name().toLowerCase() + ".png" : "textures/entity/boat/" + type.name().toLowerCase() + ".png";
        return new class_2960("arts_and_crafts", path);
    }

    public class_2960 getTextureLocation(class_1690 boat) {
        return (class_2960)this.getBoatPair(boat).getFirst();
    }

    private Pair<class_2960, class_4595<class_1690>> getBoatPair(class_1690 boat) {
        if (boat instanceof ACBoat) {
            ACBoat customBoat = (ACBoat)boat;
            return this.boatResources.get((Object)customBoat.getBoatWoodType());
        }
        if (boat instanceof ACChestBoat) {
            ACChestBoat customBoat = (ACChestBoat)boat;
            return this.boatResources.get((Object)customBoat.getBoatWoodType());
        }
        return this.boatResources.get((Object)ACBoat.WoodType.CORK);
    }
}

