/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.renderer.entity.layers;

import com.mrcrayfish.backpacked.client.renderer.backpack.BackpackRenderContext;
import com.mrcrayfish.backpacked.common.backpack.Backpack;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.common.backpack.ModelMeta;
import com.mrcrayfish.backpacked.common.backpack.ModelProperty;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.platform.ClientServices;
import com.mrcrayfish.backpacked.platform.Services;
import net.minecraft.class_1087;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_591;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_918;

public class BackpackLayer<T extends class_1657, M extends class_591<T>>
extends class_3887<T, M> {
    private final class_918 itemRenderer;

    public BackpackLayer(class_3883<T, M> renderer, class_918 itemRenderer) {
        super(renderer);
        this.itemRenderer = itemRenderer;
    }

    public void render(class_4587 pose, class_4597 source, int light, T player, float p_225628_5_, float p_225628_6_, float partialTick, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
        class_1799 stack = Services.BACKPACK.getBackpackStack((class_1657)player);
        if (stack.method_7909() instanceof BackpackItem) {
            class_1799 chestStack = player.method_6118(class_1304.field_6174);
            if (chestStack.method_7909() == class_1802.field_8833 && !BackpackLayer.canRenderWithElytra(stack)) {
                return;
            }
            if (!Services.BACKPACK.isBackpackVisible((class_1657)player)) {
                return;
            }
            String modelName = stack.method_7948().method_10558("BackpackModel");
            Backpack backpack = BackpackManager.instance().getClientBackpack(modelName);
            if (backpack == null) {
                return;
            }
            pose.method_22903();
            pose.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
            pose.method_22905(1.05f, -1.05f, -1.05f);
            int offset = !chestStack.method_7960() ? 3 : 2;
            pose.method_22904(0.0, -0.06, (double)offset * 0.0625);
            ModelMeta meta = BackpackManager.instance().getModelMeta(backpack);
            meta.renderer().ifPresentOrElse(renderer -> {
                pose.method_22903();
                BackpackRenderContext context = new BackpackRenderContext(pose, source, light, stack, backpack, (class_1309)player, partialTick, player.field_6012, model -> this.itemRenderer.method_23179(stack, class_811.field_4315, false, pose, source, light, class_4608.field_21444, model));
                renderer.forEach(function -> function.apply(context));
                pose.method_22909();
            }, () -> {
                class_1087 model = ClientServices.MODEL.getBakedModel(backpack.getBaseModel());
                this.itemRenderer.method_23179(stack, class_811.field_4315, false, pose, source, light, class_4608.field_21444, model);
            });
            this.itemRenderer.method_23179(stack, class_811.field_4315, false, pose, source, light, class_4608.field_21444, this.getModel(backpack.getStrapsModel()));
            pose.method_22909();
        }
    }

    private class_1087 getModel(class_2960 location) {
        class_1087 model = ClientServices.MODEL.getBakedModel(location);
        return model != null ? model : this.itemRenderer.method_4012().method_3303().method_4744();
    }

    public static boolean canRenderWithElytra(class_1799 stack) {
        return stack.method_7948().method_10577(ModelProperty.SHOW_WITH_ELYTRA.getTagName());
    }

    public static boolean canShowEnchantmentGlint(class_1799 stack) {
        return stack.method_7948().method_10577(ModelProperty.SHOW_GLINT.getTagName());
    }
}

