/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.backpack;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.backpack.Backpack;
import com.mrcrayfish.backpacked.common.backpack.ModelMeta;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageSyncBackpacks;
import com.mrcrayfish.backpacked.network.message.MessageUnlockBackpack;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public final class BackpackManager {
    private static BackpackManager instance;
    private Map<class_2960, Backpack> loadedBackpacks = new HashMap<class_2960, Backpack>();
    private Map<class_2960, Backpack> clientBackpacks = new HashMap<class_2960, Backpack>();
    private Map<class_2960, ModelMeta> clientModelMeta = new HashMap<class_2960, ModelMeta>();

    public static BackpackManager instance() {
        if (instance == null) {
            instance = new BackpackManager();
        }
        return instance;
    }

    private BackpackManager() {
    }

    public void updateBackpacks(Map<class_2960, Backpack> map) {
        this.loadedBackpacks = map;
    }

    public void updateModelMeta(Map<class_2960, ModelMeta> map) {
        this.clientModelMeta = map;
    }

    public void updateClientBackpacks(List<Backpack> backpacks) {
        this.clientBackpacks.clear();
        backpacks.forEach(backpack -> this.clientBackpacks.put(backpack.getId(), (Backpack)backpack));
    }

    @Nullable
    public Backpack getBackpack(class_2960 id) {
        return this.loadedBackpacks.get(id);
    }

    public List<Backpack> getBackpacks() {
        return ImmutableList.copyOf(this.loadedBackpacks.values());
    }

    @Nullable
    public Backpack getClientBackpack(class_2960 id) {
        return this.clientBackpacks.get(id);
    }

    @Nullable
    public Backpack getClientBackpack(String id) {
        return this.clientBackpacks.get(class_2960.method_12829((String)id));
    }

    public List<Backpack> getClientBackpacks() {
        return ImmutableList.copyOf(this.clientBackpacks.values());
    }

    public ModelMeta getModelMeta(class_2960 id) {
        return this.clientModelMeta.getOrDefault(id, ModelMeta.DEFAULT);
    }

    public ModelMeta getModelMeta(Backpack backpack) {
        return this.clientModelMeta.getOrDefault(backpack.getId(), ModelMeta.DEFAULT);
    }

    public void unlockBackpack(class_3222 player, class_2960 id) {
        if (((Boolean)Config.SERVER.backpack.unlockAllCosmetics.get()).booleanValue()) {
            return;
        }
        if (!this.loadedBackpacks.containsKey(id)) {
            return;
        }
        UnlockManager.getTracker((class_1657)player).ifPresent(impl -> {
            if (impl.unlockBackpack(id)) {
                Network.getPlay().sendToPlayer(() -> player, (IMessage)new MessageUnlockBackpack(id));
            }
        });
    }

    public MessageSyncBackpacks getSyncMessage() {
        return new MessageSyncBackpacks(this.getBackpacks());
    }
}

