/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.backpack.loader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mrcrayfish.backpacked.Constants;
import com.mrcrayfish.backpacked.common.backpack.Backpack;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.platform.Services;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class BackpackLoader
extends class_4309 {
    private static final String DIRECTORY = "backpacked";
    private static final Gson GSON = new GsonBuilder().create();

    public BackpackLoader() {
        super(GSON, DIRECTORY);
    }

    protected void apply(Map<class_2960, JsonElement> map, class_3300 manager, class_3695 filler) {
        HashMap<class_2960, Backpack> backpacks = new HashMap<class_2960, Backpack>();
        map.forEach((location, element) -> {
            String modId;
            if (location.method_12832().contains("/")) {
                Constants.LOG.warn("Ignoring backpack '{}' as it was in a sub-directory", location);
                return;
            }
            JsonObject object = element.getAsJsonObject();
            if (object.has("mod_loaded") && object.get("mod_loaded").isJsonPrimitive() && !Services.REGISTRATION.isModLoaded(modId = object.get("mod_loaded").getAsString())) {
                return;
            }
            try {
                Backpack backpack = Backpack.deserialize(object);
                backpack.setup((class_2960)location);
                backpacks.put((class_2960)location, backpack);
            }
            catch (Exception e) {
                throw new JsonParseException("An error occurred when parsing the backpack '%s'".formatted(location), (Throwable)e);
            }
        });
        BackpackManager.instance().updateBackpacks(backpacks);
    }
}

