/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.challenge.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mrcrayfish.backpacked.common.BackpackedCodecs;
import com.mrcrayfish.backpacked.common.challenge.Challenge;
import com.mrcrayfish.backpacked.common.challenge.ChallengeSerializer;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import com.mrcrayfish.backpacked.common.tracker.impl.CountProgressTracker;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.PlayerEvents;
import com.mrcrayfish.framework.event.IPlayerEvent;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class CraftItemChallenge
extends Challenge {
    public static final class_2960 ID = new class_2960("backpacked", "craft_item");
    public static final Serializer SERIALIZER = new Serializer();
    private final ProgressFormatter formatter;
    private final Optional<CraftedItemPredicate> predicate;
    private final int count;

    public CraftItemChallenge(ProgressFormatter formatter, Optional<CraftedItemPredicate> predicate, int count) {
        super(ID);
        this.formatter = formatter;
        this.predicate = predicate;
        this.count = count;
    }

    @Override
    public ChallengeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public IProgressTracker createProgressTracker(class_2960 backpackId) {
        return new Tracker(this.formatter, this.predicate, this.count);
    }

    public static class Serializer
    extends ChallengeSerializer<CraftItemChallenge> {
        @Override
        public CraftItemChallenge deserialize(JsonObject object) {
            ProgressFormatter formatter = Serializer.readFormatter(object, ProgressFormatter.CRAFT_X_OF_X);
            Optional<CraftedItemPredicate> predicate = CraftedItemPredicate.deserialize(object.get("crafted_item"));
            int count = Serializer.readCount(object, 1);
            return new CraftItemChallenge(formatter, predicate, count);
        }
    }

    public static class Tracker
    extends CountProgressTracker {
        private final Optional<CraftedItemPredicate> predicate;

        public Tracker(ProgressFormatter formatter, Optional<CraftedItemPredicate> predicate, int maxCount) {
            super(maxCount, formatter);
            this.predicate = predicate;
        }

        public static void registerEvent() {
            PlayerEvents.CRAFT_ITEM.register((IFrameworkEvent)((IPlayerEvent.CraftItem)(player, stack, inventory) -> {
                if (player.method_37908().method_8608()) {
                    return;
                }
                UnlockManager.getTrackers(player, Tracker.class).forEach(tracker -> {
                    if (tracker.isComplete()) {
                        return;
                    }
                    if (tracker.predicate.map(p -> p.test(stack)).orElse(true).booleanValue()) {
                        tracker.increment(stack.method_7947(), (class_3222)player);
                    }
                });
            }));
        }
    }

    public record CraftedItemPredicate(Optional<Set<String>> modIds, Optional<class_6862<class_1792>> tag, Optional<class_6885<class_1792>> items) {
        public boolean test(class_1799 stack) {
            if (this.modIds.isPresent()) {
                class_2960 key = class_7923.field_41178.method_10221((Object)stack.method_7909());
                if (this.modIds.get().contains(key.method_12836())) {
                    return true;
                }
            }
            if (this.tag.isPresent() && stack.method_31573(this.tag.get())) {
                return true;
            }
            return this.items.isPresent() && this.items.get().method_40241(stack.method_41409());
        }

        public static Optional<CraftedItemPredicate> deserialize(@Nullable JsonElement element) {
            if (element == null || !element.isJsonObject()) {
                return Optional.empty();
            }
            JsonObject object = element.getAsJsonObject();
            Optional namespaces = object.has("namespace") ? BackpackedCodecs.STRING_SET.parse((DynamicOps)JsonOps.INSTANCE, (Object)object.get("namespace")).result() : Optional.empty();
            Optional tag = object.has("tag") ? class_6862.method_40090((class_5321)class_7924.field_41197).parse((DynamicOps)JsonOps.INSTANCE, (Object)object.get("tag")).result() : Optional.empty();
            Optional items = object.has("items") ? BackpackedCodecs.ITEMS.parse((DynamicOps)JsonOps.INSTANCE, (Object)object.get("items")).result() : Optional.empty();
            return Optional.of(new CraftedItemPredicate(namespaces, tag, items));
        }
    }
}

