/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.challenge.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.backpacked.common.challenge.Challenge;
import com.mrcrayfish.backpacked.common.challenge.ChallengeSerializer;
import com.mrcrayfish.backpacked.common.challenge.ChallengeUtils;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import com.mrcrayfish.backpacked.common.tracker.impl.CountProgressTracker;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.event.BackpackedEvents;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2073;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4550;

public class InteractWithBlockChallenge
extends Challenge {
    public static final class_2960 ID = new class_2960("backpacked", "interact_with_block");
    public static final Serializer SERIALIZER = new Serializer();
    private final ProgressFormatter formatter;
    private final Optional<class_4550> block;
    private final Optional<class_2073> item;
    private final int count;

    public InteractWithBlockChallenge(ProgressFormatter formatter, Optional<class_4550> block, Optional<class_2073> item, int count) {
        super(ID);
        this.formatter = formatter;
        this.block = block;
        this.item = item;
        this.count = count;
    }

    @Override
    public ChallengeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public IProgressTracker createProgressTracker(class_2960 backpackId) {
        return new Tracker(this.count, this.formatter, this.block, this.item);
    }

    public static class Serializer
    extends ChallengeSerializer<InteractWithBlockChallenge> {
        @Override
        public InteractWithBlockChallenge deserialize(JsonObject object) {
            ProgressFormatter formatter = Serializer.readFormatter(object, ProgressFormatter.COMPLETED_X_OF_X);
            Optional<class_4550> block = object.has("block") ? Optional.of(class_4550.method_22453((JsonElement)object.get("block"))) : Optional.empty();
            Optional<class_2073> item = object.has("item") ? Optional.of(class_2073.method_8969((JsonElement)object.get("item"))) : Optional.empty();
            int count = Serializer.readCount(object, 1);
            return new InteractWithBlockChallenge(formatter, block, item, count);
        }
    }

    public static class Tracker
    extends CountProgressTracker {
        private final Optional<class_4550> block;
        private final Optional<class_2073> item;

        private Tracker(int maxCount, ProgressFormatter formatter, Optional<class_4550> block, Optional<class_2073> item) {
            super(maxCount, formatter);
            this.block = block;
            this.item = item;
        }

        private boolean test(class_2680 state, class_1799 stack) {
            return ChallengeUtils.testPredicate(this.block, state, null) && ChallengeUtils.testPredicate(this.item, stack);
        }

        public static void registerEvent() {
            BackpackedEvents.INTERACTED_WITH_BLOCK_CAPTURE_TAG.register((state, stack, player) -> UnlockManager.getTrackers((class_1657)player, Tracker.class).stream().anyMatch(tracker -> !tracker.isComplete() && tracker.test(state, stack)));
            BackpackedEvents.INTERACTED_WITH_BLOCK.register((state, stack, tag, player) -> UnlockManager.getTrackers((class_1657)player, Tracker.class).forEach(tracker -> {
                if (!tracker.isComplete() && tracker.test(state, stack)) {
                    tracker.increment(player);
                }
            }));
        }
    }
}

