/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.challenge.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.backpacked.common.challenge.Challenge;
import com.mrcrayfish.backpacked.common.challenge.ChallengeSerializer;
import com.mrcrayfish.backpacked.common.challenge.ChallengeUtils;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import com.mrcrayfish.backpacked.common.tracker.impl.CountProgressTracker;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.event.BackpackedEvents;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class InteractWithEntityChallenge
extends Challenge {
    public static final class_2960 ID = new class_2960("backpacked", "interact_with_entity");
    public static final Serializer SERIALIZER = new Serializer();
    private final ProgressFormatter formatter;
    private final Optional<class_2048> entity;
    private final Optional<class_2073> item;
    private final int count;

    public InteractWithEntityChallenge(ProgressFormatter formatter, Optional<class_2048> entity, Optional<class_2073> item, int count) {
        super(ID);
        this.formatter = formatter;
        this.entity = entity;
        this.item = item;
        this.count = count;
    }

    @Override
    public ChallengeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public IProgressTracker createProgressTracker(class_2960 backpackId) {
        return new Tracker(backpackId, this.count, this.formatter, this.entity, this.item);
    }

    public static class Serializer
    extends ChallengeSerializer<InteractWithEntityChallenge> {
        @Override
        public InteractWithEntityChallenge deserialize(JsonObject object) {
            ProgressFormatter formatter = Serializer.readFormatter(object, ProgressFormatter.COMPLETED_X_OF_X);
            Optional<class_2048> entity = object.has("entity") ? Optional.of(class_2048.method_8913((JsonElement)object.get("entity"))) : Optional.empty();
            Optional<class_2073> item = object.has("item") ? Optional.of(class_2073.method_8969((JsonElement)object.get("item"))) : Optional.empty();
            int count = Serializer.readCount(object, 1);
            return new InteractWithEntityChallenge(formatter, entity, item, count);
        }
    }

    public static class Tracker
    extends CountProgressTracker {
        private final class_2960 backpackId;
        private final Optional<class_2048> entity;
        private final Optional<class_2073> item;

        private Tracker(class_2960 backpackId, int maxCount, ProgressFormatter formatter, Optional<class_2048> entity, Optional<class_2073> item) {
            super(maxCount, formatter);
            this.backpackId = backpackId;
            this.entity = entity;
            this.item = item;
        }

        private boolean test(class_3222 player, class_1297 entity, class_1799 stack) {
            return ChallengeUtils.testPredicate(this.entity, player, entity) && ChallengeUtils.testPredicate(this.item, stack);
        }

        public static void registerEvent() {
            BackpackedEvents.INTERACTED_WITH_ENTITY_CAPTURE.register((player, stack, entity, consumer) -> UnlockManager.getTrackers((class_1657)player, Tracker.class).forEach(tracker -> {
                if (!tracker.isComplete() && tracker.test(player, entity, stack)) {
                    consumer.accept(tracker.backpackId);
                }
            }));
            BackpackedEvents.INTERACTED_WITH_ENTITY.register((player, stack, entity, callbacks) -> UnlockManager.getTrackers((class_1657)player, Tracker.class).forEach(tracker -> {
                if (!tracker.isComplete() && callbacks.contains(tracker.backpackId)) {
                    tracker.increment(player);
                }
            }));
        }
    }
}

