/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.challenge.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.backpacked.common.challenge.Challenge;
import com.mrcrayfish.backpacked.common.challenge.ChallengeSerializer;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import com.mrcrayfish.backpacked.common.tracker.impl.CountProgressTracker;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.framework.api.event.EntityEvents;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.event.IEntityEvent;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class KillMobChallenge
extends Challenge {
    public static final class_2960 ID = new class_2960("backpacked", "kill_mob");
    public static final Serializer SERIALIZER = new Serializer();
    private final ProgressFormatter formatter;
    private final Optional<class_2048> entity;
    private final Optional<class_2073> item;
    private final int count;

    public KillMobChallenge(ProgressFormatter formatter, Optional<class_2048> entity, Optional<class_2073> item, int count) {
        super(ID);
        this.formatter = formatter;
        this.entity = entity;
        this.item = item;
        this.count = count;
    }

    @Override
    public ChallengeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public IProgressTracker createProgressTracker(class_2960 backpackId) {
        return new Tracker(this.count, this.formatter, this.entity, this.item);
    }

    public static final class Serializer
    extends ChallengeSerializer<KillMobChallenge> {
        @Override
        public KillMobChallenge deserialize(JsonObject object) {
            ProgressFormatter formatter = Serializer.readFormatter(object, ProgressFormatter.KILLED_X_OF_X);
            Optional<class_2048> entity = object.has("mob") ? Optional.of(class_2048.method_8913((JsonElement)object.get("mob"))) : Optional.empty();
            Optional<class_2073> item = object.has("item") ? Optional.of(class_2073.method_8969((JsonElement)object.get("item"))) : Optional.empty();
            int count = Serializer.readCount(object, 1);
            return new KillMobChallenge(formatter, entity, item, count);
        }
    }

    public static class Tracker
    extends CountProgressTracker {
        private final Optional<class_2048> entityPredicate;
        private final Optional<class_2073> itemPredicate;

        private Tracker(int maxCount, ProgressFormatter formatter, Optional<class_2048> entityPredicate, Optional<class_2073> itemPredicate) {
            super(maxCount, formatter);
            this.entityPredicate = entityPredicate;
            this.itemPredicate = itemPredicate;
        }

        private boolean test(class_1309 entity, class_1799 stack, class_3222 player) {
            return this.entityPredicate.map(p -> p.method_8914(player, (class_1297)entity)).orElse(true) != false && this.itemPredicate.map(p -> p.method_8970(stack)).orElse(true) != false;
        }

        public static void registerEvent() {
            EntityEvents.LIVING_ENTITY_DEATH.register((IFrameworkEvent)((IEntityEvent.LivingEntityDeath)(entity, source) -> {
                if (entity.method_37908().method_8608()) {
                    return false;
                }
                class_1297 cause = source.method_5529();
                if (cause != null && cause.method_5864() == class_1299.field_6097) {
                    class_3222 player = (class_3222)cause;
                    UnlockManager.getTrackers((class_1657)player, Tracker.class).forEach(tracker -> {
                        if (tracker.isComplete()) {
                            return;
                        }
                        class_1799 heldItem = player.method_6047();
                        if (tracker.test(entity, heldItem, player)) {
                            tracker.increment(player);
                        }
                    });
                }
                return false;
            }));
        }
    }
}

