/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.challenge.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.backpacked.common.challenge.Challenge;
import com.mrcrayfish.backpacked.common.challenge.ChallengeSerializer;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import com.mrcrayfish.backpacked.common.tracker.impl.CountProgressTracker;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.event.BackpackedEvents;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class MerchantTradeChallenge
extends Challenge {
    public static final class_2960 ID = new class_2960("backpacked", "merchant_trade");
    public static final Serializer SERIALIZER = new Serializer();
    private final ProgressFormatter formatter;
    private final Optional<class_2048> entity;
    private final Optional<class_2073> item;
    private final int count;

    protected MerchantTradeChallenge(ProgressFormatter formatter, Optional<class_2048> entity, Optional<class_2073> item, int count) {
        super(ID);
        this.formatter = formatter;
        this.entity = entity;
        this.item = item;
        this.count = count;
    }

    @Override
    public ChallengeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public IProgressTracker createProgressTracker(class_2960 backpackId) {
        return new Tracker(this.count, this.formatter, this.entity, this.item);
    }

    public static class Serializer
    extends ChallengeSerializer<MerchantTradeChallenge> {
        @Override
        public MerchantTradeChallenge deserialize(JsonObject object) {
            ProgressFormatter formatter = Serializer.readFormatter(object, ProgressFormatter.TRADED_X_OF_X);
            Optional<class_2048> entity = object.has("merchant") ? Optional.of(class_2048.method_8913((JsonElement)object.get("merchant"))) : Optional.empty();
            Optional<class_2073> item = object.has("item") ? Optional.of(class_2073.method_8969((JsonElement)object.get("item"))) : Optional.empty();
            int count = Serializer.readCount(object, 1);
            return new MerchantTradeChallenge(formatter, entity, item, count);
        }
    }

    public static class Tracker
    extends CountProgressTracker {
        private final Optional<class_2048> entity;
        private final Optional<class_2073> item;

        public Tracker(int maxCount, ProgressFormatter formatter, Optional<class_2048> entity, Optional<class_2073> item) {
            super(maxCount, formatter);
            this.entity = entity;
            this.item = item;
        }

        private boolean test(class_3222 player, class_1297 merchant, class_1799 stack) {
            return this.entity.map(p -> p.method_8914(player, merchant)).orElse(true) != false && this.item.map(p -> p.method_8970(stack)).orElse(true) != false;
        }

        public static void registerEvent() {
            BackpackedEvents.MERCHANT_TRADE.register((merchant, player, stack) -> {
                if (player.method_37908().method_8608() || !(merchant instanceof class_1297)) {
                    return;
                }
                class_1297 entity = (class_1297)merchant;
                UnlockManager.getTrackers(player, Tracker.class).forEach(tracker -> {
                    if (tracker.isComplete()) {
                        return;
                    }
                    class_3222 serverPlayer = (class_3222)player;
                    if (tracker.test(serverPlayer, entity, stack)) {
                        tracker.increment(serverPlayer);
                    }
                });
            });
        }
    }
}

