/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.data.pickpocket;

import com.mrcrayfish.backpacked.core.ModSyncedDataKeys;
import com.mrcrayfish.backpacked.util.Serializable;
import com.mrcrayfish.framework.api.sync.IDataSerializer;
import com.mrcrayfish.framework.entity.sync.Updatable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3989;

public class TraderPickpocketing
implements Serializable {
    public static final IDataSerializer<TraderPickpocketing> SERIALIZER = new Serializer();
    private final Updatable updatable;
    private boolean initialized = false;
    private boolean backpack = false;
    private boolean spawnedLoot = false;
    private final Map<class_1657, Long> detectedPlayers = new HashMap<class_1657, Long>();
    private final Map<UUID, Long> dislikedPlayers = new HashMap<UUID, Long>();

    public TraderPickpocketing(Updatable updatable) {
        this.updatable = updatable;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized() {
        this.initialized = true;
        this.updatable.markDirty();
    }

    public void setBackpackEquipped(boolean equipped) {
        this.backpack = equipped;
        this.updatable.markDirty();
    }

    public boolean isBackpackEquipped() {
        return this.backpack;
    }

    public boolean isLootSpawned() {
        return this.spawnedLoot;
    }

    public void setLootSpawned() {
        this.spawnedLoot = true;
        this.updatable.markDirty();
    }

    public Map<class_1657, Long> getDetectedPlayers() {
        return this.detectedPlayers;
    }

    public boolean isDislikedPlayer(class_1657 player) {
        return this.dislikedPlayers.containsKey(player.method_5667());
    }

    public void addDislikedPlayer(class_1657 player, long time) {
        this.dislikedPlayers.put(player.method_5667(), time);
    }

    public Map<UUID, Long> getDislikedPlayers() {
        return this.dislikedPlayers;
    }

    @Override
    public class_2487 serialize() {
        class_2487 tag = new class_2487();
        tag.method_10556("Initialized", this.initialized);
        tag.method_10556("EquippedBackpack", this.backpack);
        tag.method_10556("SpawnedLoot", this.spawnedLoot);
        return tag;
    }

    @Override
    public void deserialize(class_2487 tag) {
        this.initialized = tag.method_10577("Initialized");
        this.backpack = tag.method_10577("EquippedBackpack");
        this.spawnedLoot = tag.method_10577("SpawnedLoot");
    }

    public static Optional<TraderPickpocketing> get(class_1297 entity) {
        if (entity instanceof class_3989) {
            class_3989 trader = (class_3989)entity;
            return Optional.ofNullable((TraderPickpocketing)ModSyncedDataKeys.TRADER_PICKPOCKETING.getValue((class_1297)trader));
        }
        return Optional.empty();
    }

    private static class Serializer
    implements IDataSerializer<TraderPickpocketing> {
        private Serializer() {
        }

        public void write(class_2540 buf, TraderPickpocketing value) {
            buf.writeBoolean(value.initialized);
            buf.writeBoolean(value.backpack);
            buf.writeBoolean(value.spawnedLoot);
        }

        public TraderPickpocketing read(class_2540 buf) {
            throw new UnsupportedOperationException();
        }

        public TraderPickpocketing read(Updatable updatable, class_2540 buf) {
            TraderPickpocketing challenge = new TraderPickpocketing(updatable);
            challenge.initialized = buf.readBoolean();
            challenge.backpack = buf.readBoolean();
            challenge.spawnedLoot = buf.readBoolean();
            return challenge;
        }

        public class_2520 write(TraderPickpocketing value) {
            class_2487 tag = new class_2487();
            tag.method_10556("Initialized", value.initialized);
            tag.method_10556("EquippedBackpack", value.backpack);
            tag.method_10556("SpawnedLoot", value.spawnedLoot);
            return tag;
        }

        public TraderPickpocketing read(class_2520 nbt) {
            throw new UnsupportedOperationException();
        }

        public TraderPickpocketing read(Updatable updatable, class_2520 nbt) {
            TraderPickpocketing challenge = new TraderPickpocketing(updatable);
            if (nbt instanceof class_2487) {
                class_2487 tag = (class_2487)nbt;
                challenge.initialized = tag.method_10577("Initialized");
                challenge.backpack = tag.method_10577("EquippedBackpack");
                challenge.spawnedLoot = tag.method_10577("SpawnedLoot");
            }
            return challenge;
        }
    }
}

