/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.network.play;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.WanderingTraderEvents;
import com.mrcrayfish.backpacked.common.backpack.Backpack;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.common.backpack.ModelProperty;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageBackpackCosmetics;
import com.mrcrayfish.backpacked.network.message.MessageEntityBackpack;
import com.mrcrayfish.backpacked.network.message.MessageOpenBackpack;
import com.mrcrayfish.backpacked.network.message.MessageOpenCustomisation;
import com.mrcrayfish.backpacked.network.message.MessageRequestCustomisation;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.backpacked.util.PickpocketUtil;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.HashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3989;

public class ServerPlayHandler {
    public static void handleCustomiseBackpack(MessageBackpackCosmetics message, class_3222 player) {
        class_1799 stack = Services.BACKPACK.getBackpackStack((class_1657)player);
        if (!stack.method_7960()) {
            class_2960 id = message.getBackpackId();
            Backpack backpack = BackpackManager.instance().getBackpack(id);
            if (backpack == null) {
                return;
            }
            if (!backpack.isUnlocked((class_1657)player) && !((Boolean)Config.SERVER.backpack.unlockAllCosmetics.get()).booleanValue()) {
                return;
            }
            class_2487 tag = stack.method_7948();
            tag.method_10582("BackpackModel", id.toString());
            tag.method_10556(ModelProperty.SHOW_GLINT.getTagName(), message.isShowGlint());
            tag.method_10556(ModelProperty.SHOW_WITH_ELYTRA.getTagName(), message.isShowWithElytra());
            tag.method_10556(ModelProperty.SHOW_EFFECTS.getTagName(), message.isShowEffects());
        }
    }

    public static void handleOpenBackpack(MessageOpenBackpack message, class_3222 player) {
        BackpackItem.openBackpack(player, player);
    }

    public static void handleEntityBackpack(MessageEntityBackpack message, class_3222 player) {
        class_1297 entity = player.method_37908().method_8469(message.getEntityId());
        if (!(entity instanceof class_1309)) {
            return;
        }
        class_1309 otherEntity = (class_1309)entity;
        if (otherEntity instanceof class_3222 && !((Boolean)Config.SERVER.pickpocketing.enabled.get()).booleanValue()) {
            return;
        }
        if (!PickpocketUtil.canSeeBackpack(otherEntity, (class_1657)player)) {
            return;
        }
        if (otherEntity instanceof class_3222) {
            class_3222 otherPlayer = (class_3222)otherEntity;
            if (BackpackItem.openBackpack(otherPlayer, player)) {
                otherPlayer.method_7353((class_2561)class_2561.method_43471((String)"message.backpacked.player_opened"), true);
                player.method_37908().method_43128((class_1657)player, otherPlayer.method_23317(), otherPlayer.method_23318() + 1.0, otherPlayer.method_23321(), class_3417.field_14581, class_3419.field_15248, 0.75f, 1.0f);
            }
        } else if (otherEntity instanceof class_3989) {
            class_3989 trader = (class_3989)otherEntity;
            WanderingTraderEvents.openBackpack(trader, player);
        }
    }

    public static void handleRequestCustomisation(MessageRequestCustomisation message, class_3222 player) {
        if (((Boolean)Config.SERVER.backpack.disableCustomisation.get()).booleanValue()) {
            return;
        }
        if (Services.BACKPACK.getBackpackStack((class_1657)player).method_7960()) {
            return;
        }
        UnlockManager.getTracker((class_1657)player).ifPresent(unlockTracker -> {
            HashMap<class_2960, class_2561> map = new HashMap<class_2960, class_2561>();
            for (Backpack backpack : BackpackManager.instance().getBackpacks()) {
                if (unlockTracker.isUnlocked(backpack.getId())) continue;
                unlockTracker.getProgressTracker(backpack.getId()).ifPresent(progressTracker -> map.put(backpack.getId(), progressTracker.getDisplayComponent()));
            }
            Network.getPlay().sendToPlayer(() -> player, (IMessage)new MessageOpenCustomisation(map));
        });
    }
}

