/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.brewinandchewin.common.block.entity;

import com.google.common.collect.Lists;
import dev.sterner.brewinandchewin.common.block.FermentationControllerBlock;
import dev.sterner.brewinandchewin.common.block.KegBlock;
import dev.sterner.brewinandchewin.common.block.entity.FermentationControllerBlockEntity;
import dev.sterner.brewinandchewin.common.block.screen.KegBlockScreenHandler;
import dev.sterner.brewinandchewin.common.recipe.KegRecipe;
import dev.sterner.brewinandchewin.common.registry.BCBlockEntityTypes;
import dev.sterner.brewinandchewin.common.registry.BCRecipeTypes;
import dev.sterner.brewinandchewin.common.registry.BCTags;
import dev.sterner.brewinandchewin.common.util.BCTextUtils;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerContainer;
import io.github.fabricators_of_create.porting_lib.transfer.item.RecipeWrapper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1275;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1732;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.mixin.accessor.RecipeManagerAccessor;
import vectorwing.farmersdelight.common.tag.ModTags;

public class KegBlockEntity
extends SyncedBlockEntity
implements ExtendedScreenHandlerFactory,
class_1275,
class_1732 {
    public static final int MEAL_DISPLAY_SLOT = 5;
    public static final int CONTAINER_SLOT = 7;
    public static final int OUTPUT_SLOT = 8;
    public static final int INVENTORY_SIZE = 9;
    public final ItemStackHandlerContainer inventory = this.createHandler();
    private int fermentTime;
    private int fermentTimeTotal;
    private class_1799 drinkContainerStack = class_1799.field_8037;
    private class_2561 customName;
    public int kegTemperature;
    protected final class_3913 kegData = new KegSyncedData();
    private final Object2IntOpenHashMap<class_2960> usedRecipeTracker = new Object2IntOpenHashMap();
    private class_2960 lastRecipeID;
    private boolean checkNewRecipe = true;

    public KegBlockEntity(class_2338 pos, class_2680 state) {
        super(BCBlockEntityTypes.KEG, pos, state);
    }

    private ItemStackHandlerContainer createHandler() {
        return new ItemStackHandlerContainer(9){

            protected void onContentsChanged(int slot) {
                if (slot >= 0 && slot < 5) {
                    KegBlockEntity.this.checkNewRecipe = true;
                }
                KegBlockEntity.this.inventoryChanged();
            }
        };
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.inventory.deserializeNBT(compound.method_10562("Inventory"));
        this.fermentTime = compound.method_10550("FermentTime");
        this.fermentTimeTotal = compound.method_10550("FermentTimeTotal");
        this.drinkContainerStack = class_1799.method_7915((class_2487)compound.method_10562("Container"));
        this.kegTemperature = compound.method_10550("Temperature");
        if (compound.method_10573("CustomName", 8)) {
            this.customName = class_2561.class_2562.method_10877((String)compound.method_10558("CustomName"));
        }
        class_2487 compoundRecipes = compound.method_10562("RecipesUsed");
        for (String key : compoundRecipes.method_10541()) {
            this.usedRecipeTracker.put((Object)new class_2960(key), compoundRecipes.method_10550(key));
        }
    }

    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        compound.method_10569("FermentTime", this.fermentTime);
        compound.method_10569("FermentTimeTotal", this.fermentTimeTotal);
        compound.method_10566("Container", (class_2520)this.drinkContainerStack.method_7953(new class_2487()));
        compound.method_10569("Temperature", this.kegTemperature);
        if (this.customName != null) {
            compound.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.customName));
        }
        compound.method_10566("Inventory", (class_2520)this.inventory.serializeNBT());
        class_2487 compoundRecipes = new class_2487();
        this.usedRecipeTracker.forEach((recipeId, craftedAmount) -> compoundRecipes.method_10569(recipeId.toString(), craftedAmount.intValue()));
        compound.method_10566("RecipesUsed", (class_2520)compoundRecipes);
    }

    public class_2487 writeDrink(class_2487 compound) {
        if (!this.getDrink().method_7960()) {
            class_2371 drops = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
            for (int i = 0; i < 9; ++i) {
                drops.set(i, (Object)(i == 5 ? this.inventory.method_5438(i) : class_1799.field_8037));
            }
            if (this.customName != null) {
                compound.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.customName));
            }
            compound.method_10566("Container", (class_2520)this.drinkContainerStack.method_7953(new class_2487()));
            compound.method_10566("Inventory", (class_2520)class_1262.method_5426((class_2487)new class_2487(), (class_2371)drops));
        }
        return compound;
    }

    public static void fermentingTick(class_1937 level, class_2338 pos, class_2680 state, KegBlockEntity keg) {
        boolean didInventoryChange = false;
        keg.updateTemperature();
        if (keg.hasInput()) {
            Optional<KegRecipe> recipe = keg.getMatchingRecipe(new RecipeWrapper((ItemStackHandler)keg.inventory));
            if (recipe.isPresent() && keg.canFerment(recipe.get())) {
                didInventoryChange = keg.processFermenting(recipe.get(), keg);
            } else {
                keg.fermentTime = 0;
            }
        } else if (keg.fermentTimeTotal > 0) {
            keg.fermentTime = class_3532.method_15340((int)(keg.fermentTime - 2), (int)0, (int)keg.fermentTimeTotal);
        }
        class_1799 drinkStack = keg.getDrink();
        if (!drinkStack.method_7960()) {
            if (!keg.doesDrinkHaveContainer(drinkStack)) {
                keg.moveDrinkToOutput();
                didInventoryChange = true;
            } else if (!keg.inventory.method_5438(6).method_7960()) {
                keg.useStoredContainersOnMeal();
                didInventoryChange = true;
            }
        }
        if (didInventoryChange) {
            keg.inventoryChanged();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void updateTemperature() {
        if (this.field_11863 != null && this.field_11863.method_8597().comp_644()) {
            this.kegTemperature = 10;
            return;
        }
        states = new ArrayList<class_2680>();
        range = 1;
        for (heat = -range; heat <= range; ++heat) {
            for (y = -range; y <= range; ++y) {
                for (cold = -range; cold <= range; ++cold) {
                    states.add(this.field_11863.method_8320(this.method_11016().method_10069(heat, y, cold)));
                }
            }
        }
        heat = states.stream().filter((Predicate<class_2680>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$updateTemperature$1(net.minecraft.class_2680 ), (Lnet/minecraft/class_2680;)Z)()).filter((Predicate<class_2680>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$updateTemperature$2(net.minecraft.class_2680 ), (Lnet/minecraft/class_2680;)Z)()).filter((Predicate<class_2680>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$updateTemperature$3(net.minecraft.class_2680 ), (Lnet/minecraft/class_2680;)Z)()).mapToInt((ToIntFunction<class_2680>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, lambda$updateTemperature$4(net.minecraft.class_2680 ), (Lnet/minecraft/class_2680;)I)()).sum();
        heat += states.stream().filter((Predicate<class_2680>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$updateTemperature$5(net.minecraft.class_2680 ), (Lnet/minecraft/class_2680;)Z)()).filter((Predicate<class_2680>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$updateTemperature$6(net.minecraft.class_2680 ), (Lnet/minecraft/class_2680;)Z)()).mapToInt((ToIntFunction<class_2680>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, lambda$updateTemperature$7(net.minecraft.class_2680 ), (Lnet/minecraft/class_2680;)I)()).sum();
        stateBelow = this.field_11863.method_8320(this.method_11016().method_10074());
        if (stateBelow.method_26164(ModTags.HEAT_CONDUCTORS) && (stateFurtherBelow = this.field_11863.method_8320(this.method_11016().method_10087(2))).method_26164(ModTags.HEAT_SOURCES)) {
            if (stateFurtherBelow.method_28498((class_2769)class_2741.field_12548)) {
                if (((Boolean)stateFurtherBelow.method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
                    ++heat;
                }
            } else {
                ++heat;
            }
        }
        cold = states.stream().filter((Predicate<class_2680>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$updateTemperature$8(net.minecraft.class_2680 ), (Lnet/minecraft/class_2680;)Z)()).mapToInt((ToIntFunction<class_2680>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, lambda$updateTemperature$9(net.minecraft.class_2680 ), (Lnet/minecraft/class_2680;)I)()).sum();
        biomeTemperature = ((class_1959)this.field_11863.method_23753(this.method_11016()).comp_349()).method_8712();
        if (biomeTemperature <= 0.0f) {
            cold += 2;
        } else if (biomeTemperature == 2.0f) {
            heat += 2;
        }
        fcTemp = 0;
        var9_10 = this.field_11863.method_8321(this.field_11867.method_10074());
        if (!(var9_10 instanceof FermentationControllerBlockEntity)) ** GOTO lbl-1000
        blockEntity = (FermentationControllerBlockEntity)var9_10;
        if (((Boolean)this.field_11863.method_8320(this.field_11867.method_10074()).method_11654((class_2769)FermentationControllerBlock.VERTICAL)).booleanValue()) {
            fcTemp = blockEntity.getTemperature();
        } else lbl-1000:
        // 4 sources

        {
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                pos1 = this.field_11867.method_10093(direction);
                var13_15 = this.field_11863.method_8321(pos1);
                if (!(var13_15 instanceof FermentationControllerBlockEntity)) continue;
                blockEntity = (FermentationControllerBlockEntity)var13_15;
                if (((Boolean)this.field_11863.method_8320(pos1).method_11654((class_2769)FermentationControllerBlock.VERTICAL)).booleanValue() || direction.method_10153() != this.field_11863.method_8320(pos1).method_11654((class_2769)class_2383.field_11177)) continue;
                fcTemp = blockEntity.getTemperature();
                break;
            }
        }
        this.kegTemperature = heat - cold + fcTemp;
    }

    public int getTemperature() {
        if (this.kegTemperature < -4 && this.kegTemperature > -9) {
            return 2;
        }
        if (this.kegTemperature < -8) {
            return 1;
        }
        if (this.kegTemperature > 4 && this.kegTemperature < 9) {
            return 4;
        }
        if (this.kegTemperature > 8) {
            return 5;
        }
        return 3;
    }

    public static void animationTick(class_1937 level, class_2338 pos, class_2680 state, KegBlockEntity keg) {
    }

    private Optional<KegRecipe> getMatchingRecipe(RecipeWrapper inventoryWrapper) {
        Object recipe;
        if (this.field_11863 == null) {
            return Optional.empty();
        }
        if (this.lastRecipeID != null && (recipe = (class_1860)((RecipeManagerAccessor)this.field_11863.method_8433()).getRecipeMap(BCRecipeTypes.KEG_RECIPE_TYPE).get(this.lastRecipeID)) instanceof KegRecipe) {
            if (recipe.method_8115((class_1263)inventoryWrapper, this.field_11863)) {
                return Optional.of((KegRecipe)recipe);
            }
            if (class_1799.method_7984((class_1799)recipe.method_8110(this.field_11863.method_30349()), (class_1799)this.getDrink())) {
                return Optional.empty();
            }
        }
        if (this.checkNewRecipe && ((Optional)(recipe = this.field_11863.method_8433().method_8132(BCRecipeTypes.KEG_RECIPE_TYPE, (class_1263)inventoryWrapper, this.field_11863))).isPresent()) {
            class_2960 newRecipeID;
            this.lastRecipeID = newRecipeID = ((KegRecipe)((Optional)recipe).get()).method_8114();
            return recipe;
        }
        this.checkNewRecipe = false;
        return Optional.empty();
    }

    public void onContentsChanged(int slot) {
        if (slot >= 0 && slot < 5) {
            this.checkNewRecipe = true;
        }
        this.inventoryChanged();
    }

    public class_1799 getContainer() {
        if (!this.drinkContainerStack.method_7960()) {
            return this.drinkContainerStack;
        }
        return new class_1799((class_1935)this.getDrink().method_7909().method_7858());
    }

    private boolean hasInput() {
        for (int i = 0; i < 5; ++i) {
            if (this.inventory.method_5438(i).method_7960()) continue;
            return true;
        }
        return false;
    }

    protected boolean canFerment(KegRecipe recipe) {
        if (this.field_11863 == null) {
            return false;
        }
        int recipeTemp = recipe.getTemperature();
        if (this.hasInput() && (recipeTemp == 3 || recipeTemp == this.getTemperature())) {
            class_1799 resultStack = recipe.method_8110(this.field_11863.method_30349());
            if (resultStack.method_7960()) {
                return false;
            }
            class_1799 fluidStack = this.inventory.method_5438(4);
            class_1799 storedContainerStack = this.inventory.method_5438(8);
            if (!storedContainerStack.method_7960() && fluidStack.method_7909().method_7858() != null && !fluidStack.method_7909().method_7858().equals(storedContainerStack.method_7909())) {
                return false;
            }
            if (storedContainerStack.method_7947() >= storedContainerStack.method_7914()) {
                return false;
            }
            class_1799 storedDrinkStack = this.inventory.method_5438(5);
            if (storedDrinkStack.method_7960()) {
                return true;
            }
            if (!class_1799.method_7984((class_1799)storedDrinkStack, (class_1799)resultStack)) {
                return false;
            }
            if (storedDrinkStack.method_7947() + resultStack.method_7947() <= this.inventory.getSlotLimit(5)) {
                return true;
            }
            return storedDrinkStack.method_7947() + resultStack.method_7947() <= resultStack.method_7914();
        }
        return false;
    }

    private boolean processFermenting(KegRecipe recipe, KegBlockEntity keg) {
        if (this.field_11863 == null) {
            return false;
        }
        ++this.fermentTime;
        this.fermentTimeTotal = recipe.getFermentTime();
        if (this.fermentTime < this.fermentTimeTotal) {
            return false;
        }
        this.fermentTime = 0;
        this.drinkContainerStack = recipe.getOutputContainer();
        class_1799 resultStack = recipe.method_8110(this.field_11863.method_30349());
        class_1799 storedMealStack = this.inventory.method_5438(5);
        if (storedMealStack.method_7960()) {
            this.inventory.method_5447(5, resultStack.method_7972());
        } else if (class_1799.method_7984((class_1799)storedMealStack, (class_1799)resultStack)) {
            storedMealStack.method_7933(resultStack.method_7947());
        }
        class_1799 storedContainers = this.inventory.method_5438(8);
        class_1799 fluidStack = this.inventory.method_5438(4);
        if (!fluidStack.method_7960()) {
            if (storedContainers.method_7960()) {
                this.inventory.method_5447(8, new class_1799((class_1935)fluidStack.method_7972().method_7909().method_7858()));
                if (fluidStack.method_7947() == 1) {
                    this.inventory.method_5447(4, class_1799.field_8037);
                } else {
                    this.inventory.method_5447(4, new class_1799((class_1935)fluidStack.method_7909(), fluidStack.method_7947() - 1));
                }
            } else if (class_1799.method_7984((class_1799)storedContainers, (class_1799)this.inventory.method_5438(4).method_7909().method_7858().method_7854())) {
                storedContainers.method_7933(resultStack.method_7947());
                if (fluidStack.method_7947() == 1) {
                    this.inventory.method_5447(4, class_1799.field_8037);
                } else {
                    this.inventory.method_5447(4, new class_1799((class_1935)fluidStack.method_7909(), fluidStack.method_7947() - 1));
                }
            }
        }
        keg.method_7662(recipe);
        for (int i = 0; i < 4; ++i) {
            class_1799 slotStack = this.inventory.method_5438(i);
            if (slotStack.method_7909().method_7857()) {
                class_2350 direction = ((class_2350)this.method_11010().method_11654((class_2769)KegBlock.FACING)).method_10160();
                double x = (double)this.method_11016().method_10263() + 0.5 + (double)direction.method_10148() * 0.25;
                double y = (double)this.method_11016().method_10264() + 0.7;
                double z = (double)this.method_11016().method_10260() + 0.5 + (double)direction.method_10165() * 0.25;
                class_1542 entity = new class_1542(this.field_11863, x, y, z, this.inventory.method_5438(i).method_7909().method_7858().method_7854());
                entity.method_18800((double)((float)direction.method_10148() * 0.08f), 0.25, (double)((float)direction.method_10165() * 0.08f));
                this.field_11863.method_8649((class_1297)entity);
            }
            if (slotStack.method_7960()) continue;
            slotStack.method_7934(1);
        }
        return true;
    }

    public void unlockLastRecipe(class_1657 player) {
        List<class_1860<?>> usedRecipes = this.getUsedRecipesAndPopExperience(player.method_37908(), player.method_19538());
        player.method_7254(usedRecipes);
        this.usedRecipeTracker.clear();
    }

    public List<class_1860<?>> getUsedRecipesAndPopExperience(class_1937 level, class_243 pos) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry identifierEntry : this.usedRecipeTracker.object2IntEntrySet()) {
            level.method_8433().method_8130((class_2960)identifierEntry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                KegBlockEntity.splitAndSpawnExperience((class_3218)level, pos, identifierEntry.getIntValue(), ((KegRecipe)recipe).getExperience());
            });
        }
        return list;
    }

    private static void splitAndSpawnExperience(class_3218 level, class_243 pos, int craftedAmount, float experience) {
        int expTotal = class_3532.method_15375((float)((float)craftedAmount * experience));
        float expFraction = class_3532.method_22450((float)((float)craftedAmount * experience));
        if (expFraction != 0.0f && Math.random() < (double)expFraction) {
            ++expTotal;
        }
        class_1303.method_31493((class_3218)level, (class_243)pos, (int)expTotal);
    }

    public class_1799 getDrink() {
        return this.inventory.method_5438(5);
    }

    public class_2371<class_1799> getDroppableInventory() {
        class_2371 drops = class_2371.method_10211();
        for (int i = 0; i < 9; ++i) {
            drops.add((Object)(i == 5 ? class_1799.field_8037 : this.inventory.method_5438(i)));
        }
        return drops;
    }

    private void moveDrinkToOutput() {
        class_1799 mealStack = this.inventory.method_5438(5);
        class_1799 outputStack = this.inventory.method_5438(7);
        int mealCount = Math.min(mealStack.method_7947(), mealStack.method_7914() - outputStack.method_7947());
        if (outputStack.method_7960()) {
            this.inventory.method_5447(7, mealStack.method_7971(mealCount));
        } else if (outputStack.method_7909() == mealStack.method_7909()) {
            mealStack.method_7934(mealCount);
            outputStack.method_7933(mealCount);
        }
    }

    private void useStoredContainersOnMeal() {
        class_1799 mealStack = this.inventory.method_5438(5);
        class_1799 containerInputStack = this.inventory.method_5438(6);
        class_1799 outputStack = this.inventory.method_5438(7);
        if (this.isContainerValid(containerInputStack) && outputStack.method_7947() < outputStack.method_7914()) {
            int smallerStackCount = Math.min(mealStack.method_7947(), containerInputStack.method_7947());
            int mealCount = Math.min(smallerStackCount, mealStack.method_7914() - outputStack.method_7947());
            if (outputStack.method_7960()) {
                containerInputStack.method_7934(mealCount);
                this.inventory.method_5447(7, mealStack.method_7971(mealCount));
            } else if (outputStack.method_7909() == mealStack.method_7909()) {
                mealStack.method_7934(mealCount);
                containerInputStack.method_7934(mealCount);
                outputStack.method_7933(mealCount);
            }
        }
    }

    public class_1799 useHeldItemOnMeal(class_1799 container) {
        if (this.isContainerValid(container) && !this.getDrink().method_7960()) {
            container.method_7934(1);
            return this.getDrink().method_7971(1);
        }
        return class_1799.field_8037;
    }

    private boolean doesDrinkHaveContainer(class_1799 meal) {
        return !this.drinkContainerStack.method_7960() || meal.method_7909().method_7857();
    }

    public boolean isContainerValid(class_1799 containerItem) {
        if (containerItem.method_7960() || this.getDrink().method_7960()) {
            return false;
        }
        return !this.drinkContainerStack.method_7960() ? class_1799.method_7984((class_1799)this.drinkContainerStack, (class_1799)containerItem) : class_1799.method_7984((class_1799)this.getDrink().method_7909().method_7858().method_7854(), (class_1799)containerItem);
    }

    public class_2561 method_5477() {
        return this.customName != null ? this.customName : BCTextUtils.getTranslation("container.keg", new Object[0]);
    }

    public class_2561 method_5476() {
        return this.method_5477();
    }

    @Nullable
    public class_2561 method_5797() {
        return this.customName;
    }

    public void setCustomName(class_2561 name) {
        this.customName = name;
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new KegBlockScreenHandler(syncId, inv, this, this.kegData);
    }

    public class_2487 method_16887() {
        class_2487 nbt = new class_2487();
        this.method_11007(nbt);
        return nbt;
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public void method_7662(@Nullable class_1860<?> recipe) {
        if (recipe != null) {
            class_2960 recipeID = recipe.method_8114();
            this.usedRecipeTracker.addTo((Object)recipeID, 1);
        }
    }

    @Nullable
    public class_1860<?> method_7663() {
        return null;
    }

    private static /* synthetic */ int lambda$updateTemperature$9(class_2680 s) {
        return 1;
    }

    private static /* synthetic */ boolean lambda$updateTemperature$8(class_2680 s) {
        return s.method_26164(BCTags.FREEZE_SOURCES);
    }

    private static /* synthetic */ int lambda$updateTemperature$7(class_2680 s) {
        return 1;
    }

    private static /* synthetic */ boolean lambda$updateTemperature$6(class_2680 s) {
        return !s.method_28498((class_2769)class_2741.field_12548);
    }

    private static /* synthetic */ boolean lambda$updateTemperature$5(class_2680 s) {
        return s.method_26164(ModTags.HEAT_SOURCES);
    }

    private static /* synthetic */ int lambda$updateTemperature$4(class_2680 s) {
        return 1;
    }

    private static /* synthetic */ boolean lambda$updateTemperature$3(class_2680 s) {
        return (Boolean)s.method_11654((class_2769)class_2741.field_12548);
    }

    private static /* synthetic */ boolean lambda$updateTemperature$2(class_2680 s) {
        return s.method_28498((class_2769)class_2741.field_12548);
    }

    private static /* synthetic */ boolean lambda$updateTemperature$1(class_2680 s) {
        return s.method_26164(ModTags.HEAT_SOURCES);
    }

    private class KegSyncedData
    implements class_3913 {
        private KegSyncedData() {
        }

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> KegBlockEntity.this.fermentTime;
                case 1 -> KegBlockEntity.this.fermentTimeTotal;
                case 2 -> KegBlockEntity.this.kegTemperature;
                case 3 -> KegBlockEntity.this.getTemperature();
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    KegBlockEntity.this.fermentTime = value;
                    break;
                }
                case 1: {
                    KegBlockEntity.this.fermentTimeTotal = value;
                    break;
                }
                case 2: {
                    KegBlockEntity.this.kegTemperature = value;
                }
            }
        }

        public int method_17389() {
            return 4;
        }
    }
}

