/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.brewinandchewin.datagen;

import dev.sterner.brewinandchewin.common.registry.BCObjects;
import dev.sterner.brewinandchewin.common.registry.BCStatusEffects;
import java.util.HashSet;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1291;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2551;
import net.minecraft.class_2555;

public class BCLanguageProvider
extends FabricLanguageProvider {
    protected BCLanguageProvider(FabricDataOutput dataOutput) {
        super(dataOutput);
    }

    public void generateTranslations(FabricLanguageProvider.TranslationBuilder builder) {
        HashSet<class_2248> blocks = new HashSet<class_2248>(BCObjects.BLOCKS.keySet());
        HashSet<class_1792> items = new HashSet<class_1792>(BCObjects.ITEMS.keySet());
        HashSet<class_1291> effects = new HashSet<class_1291>(BCStatusEffects.STATUS_EFFECTS.keySet());
        blocks.removeIf(b -> b instanceof class_2555);
        blocks.removeIf(b -> b instanceof class_2551);
        blocks.forEach(b -> {
            String name = b.method_9539().replaceFirst("block.brewinandchewin.", "");
            name = BCLanguageProvider.toTitleCase(this.correctBlockItemName(name), "_").replaceAll("Of", "of");
            builder.add(b.method_9539(), name);
        });
        items.removeIf(i -> i instanceof class_1747);
        items.forEach(i -> {
            String name = i.method_7876().replaceFirst("item.brewinandchewin.", "");
            name = BCLanguageProvider.toTitleCase(this.correctBlockItemName(name), "_").replaceAll("Of", "of");
            builder.add(i.method_7876(), name);
        });
        effects.forEach(e -> {
            String name = BCLanguageProvider.toTitleCase(e.method_5567().replaceFirst("effect.brewinandchewin.", ""), "_");
            builder.add(e.method_5567(), name);
        });
        builder.add("brewinandchewin.group.main", "Brewin' and Chewin'");
        builder.add("brewinandchewin.container.keg", "Keg");
        builder.add("brewinandchewin.tooltip.tipsy1", "Tipsy I (%s:00)");
        builder.add("brewinandchewin.tooltip.tipsy2", "Tipsy II (%s:00)");
        builder.add("brewinandchewin.tooltip.tipsy3", "Tipsy III (%s:00)");
        builder.add("brewinandchewin.jei.fermenting", "Fermenting");
        builder.add("brewinandchewin.rei.fermenting", "Fermenting");
        builder.add("emi.category.brewinandchewin.fermenting", "Fermenting");
        builder.add("brewinandchewin.container.keg.served_in", "Served in: %s");
        builder.add("brewinandchewin.tooltip.keg.empty", "Empty");
        builder.add("brewinandchewin.tooltip.keg.single_serving", "Holds 1 serving of:");
        builder.add("brewinandchewin.tooltip.keg.many_servings", "Holds %s serving of:");
        builder.add("brewinandchewin.tooltip.dread_nog", "Bad Omen (10:00)");
        builder.add("brewinandchewin.block.cheese.use_knife", "You need a Knife to cut this.");
        this.addTemperature("frigid", builder);
        this.addTemperature("cold", builder);
        this.addTemperature("normal", builder);
        this.addTemperature("warm", builder);
        this.addTemperature("hot", builder);
    }

    public void addTemperature(String temperature, FabricLanguageProvider.TranslationBuilder builder) {
        builder.add("brewinandchewin.container.keg." + temperature, "Temperature: " + BCLanguageProvider.toTitleCase(temperature, "_"));
    }

    public static String toTitleCase(String givenString, String regex) {
        String[] stringArray = givenString.split(regex);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(Character.toUpperCase(string.charAt(0))).append(string.substring(1)).append(regex);
        }
        return stringBuilder.toString().trim().replaceAll(regex, " ").substring(0, stringBuilder.length() - 1);
    }

    public String correctBlockItemName(String name) {
        if (!name.endsWith("_bricks") && name.contains("bricks")) {
            name = name.replaceFirst("bricks", "brick");
        }
        if ((name.contains("_fence") || name.contains("_button")) && name.contains("planks")) {
            name = name.replaceFirst("_planks", "");
        }
        return name;
    }
}

