/*
 * Decompiled with CFR 0.152.
 */
package com.rafacasari.mod.cobbledex.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.rafacasari.mod.cobbledex.utils.MiscUtils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \n2\u00020\u0001:\u0002\n\u000bB\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/rafacasari/mod/cobbledex/api/PokedexRewards;", "", "", "Lcom/rafacasari/mod/cobbledex/api/PokedexRewards$PokedexReward;", "rewards", "<init>", "(Ljava/util/List;)V", "Ljava/util/List;", "getRewards", "()Ljava/util/List;", "Companion", "PokedexReward", "common"})
public final class PokedexRewards {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<PokedexReward> rewards;
    @NotNull
    private static final Gson GSON;
    private static PokedexRewards instance;
    @NotNull
    private static final String PATH = "config/cobbledex/rewards.json";

    public PokedexRewards(@NotNull List<PokedexReward> rewards) {
        Intrinsics.checkNotNullParameter(rewards, (String)"rewards");
        this.rewards = rewards;
    }

    @NotNull
    public final List<PokedexReward> getRewards() {
        return this.rewards;
    }

    static {
        Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        GSON = gson;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u000f\u0010\r\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u0003R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u00020\b8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/rafacasari/mod/cobbledex/api/PokedexRewards$Companion;", "", "<init>", "()V", "", "Lcom/rafacasari/mod/cobbledex/api/PokedexRewards$PokedexReward;", "getDefaultRewards", "()Ljava/util/List;", "Lcom/rafacasari/mod/cobbledex/api/PokedexRewards;", "getInstance", "()Lcom/rafacasari/mod/cobbledex/api/PokedexRewards;", "", "load", "save", "Lcom/google/gson/Gson;", "GSON", "Lcom/google/gson/Gson;", "", "PATH", "Ljava/lang/String;", "instance", "Lcom/rafacasari/mod/cobbledex/api/PokedexRewards;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PokedexRewards getInstance() {
            PokedexRewards pokedexRewards;
            if (instance == null) {
                this.load();
            }
            if ((pokedexRewards = instance) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
                pokedexRewards = null;
            }
            return pokedexRewards;
        }

        private final List<PokedexReward> getDefaultRewards() {
            Object[] objectArray = new PokedexReward[]{new PokedexReward("15", 15, "cobblemon:ancient_poke_ball", 15), new PokedexReward("30", 30, "cobblemon:thunder_stone", 1), new PokedexReward("45", 45, "cobblemon:ancient_great_ball", 15), new PokedexReward("60", 60, "cobblemon:exp_candy_s", 5), new PokedexReward("75", 75, "cobblemon:fire_stone", 1), new PokedexReward("90", 90, "cobblemon:net_ball", 15), new PokedexReward("105", 105, "cobblemon:water_stone", 1), new PokedexReward("120", 120, "cobblemon:nest_ball", 15), new PokedexReward("135", 135, "cobblemon:ancient_ultra_ball", 30), new PokedexReward("150", 150, "cobblemon:exp_candy_s", 5), new PokedexReward("165", 165, "cobblemon:quick_ball", 15), new PokedexReward("180", 180, "cobblemon:leaf_stone", 1), new PokedexReward("195", 195, "cobblemon:dusk_ball", 15), new PokedexReward("210", 210, "cobblemon:exp_candy_s", 5), new PokedexReward("225", 225, "cobblemon:thunder_stone", 1), new PokedexReward("240", 240, "cobblemon:dive_ball", 15), new PokedexReward("255", 255, "cobblemon:exp_candy_m", 3), new PokedexReward("270", 270, "cobblemon:luxury_ball", 15), new PokedexReward("285", 285, "cobblemon:sun_stone", 1), new PokedexReward("300", 300, "cobblemon:exp_candy_m", 3), new PokedexReward("315", 315, "cobblemon:ability_capsule", 1), new PokedexReward("330", 330, "cobblemon:timer_ball", 15), new PokedexReward("345", 345, "cobblemon:dusk_stone", 1), new PokedexReward("360", 360, "cobblemon:exp_candy_m", 3), new PokedexReward("375", 375, "cobblemon:everstone", 1), new PokedexReward("390", 390, "cobblemon:fast_ball", 15), new PokedexReward("405", 405, "cobblemon:ice_stone", 1), new PokedexReward("420", 420, "cobblemon:destiny_knot", 1), new PokedexReward("435", 435, "cobblemon:friend_ball", 15), new PokedexReward("450", 450, "cobblemon:exp_candy_l", 1), new PokedexReward("465", 465, "cobblemon:shiny_stone", 1), new PokedexReward("480", 480, "cobblemon:level_ball", 15), new PokedexReward("495", 495, "cobblemon:exp_candy_l", 1), new PokedexReward("510", 510, "cobblemon:lure_ball", 15), new PokedexReward("525", 525, "cobblemon:moon_stone", 1), new PokedexReward("540", 540, "cobblemon:heavy_ball", 15), new PokedexReward("555", 555, "cobblemon:exp_candy_xl", 1), new PokedexReward("570", 570, "cobblemon:moon_ball", 15), new PokedexReward("585", 585, "cobblemon:dawn_stone", 1), new PokedexReward("600", 600, "cobblemon:exp_candy_xl", 1), new PokedexReward("615", 615, "cobblemon:love_ball", 15), new PokedexReward("633", 633, "cobblemon:beast_ball", 1)};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        private final void load() {
            File configFile = new File(PokedexRewards.PATH);
            configFile.getParentFile().mkdirs();
            if (configFile.exists()) {
                try {
                    FileReader fileReader = new FileReader(configFile);
                    Object object = GSON.fromJson((Reader)fileReader, PokedexRewards.class);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                    instance = (PokedexRewards)object;
                    fileReader.close();
                }
                catch (Exception error) {
                    MiscUtils.INSTANCE.logError("Failed to load Cobbledex Rewards! Using default default rewards");
                    instance = new PokedexRewards(this.getDefaultRewards());
                    error.printStackTrace();
                }
            } else {
                instance = new PokedexRewards(this.getDefaultRewards());
            }
            this.save();
        }

        private final void save() {
            try {
                FileWriter fileWriter = new FileWriter(new File(PokedexRewards.PATH));
                Gson gson = GSON;
                PokedexRewards pokedexRewards = instance;
                if (pokedexRewards == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
                    pokedexRewards = null;
                }
                gson.toJson((Object)pokedexRewards, (Appendable)fileWriter);
                fileWriter.flush();
                fileWriter.close();
            }
            catch (Exception exception) {
                MiscUtils.INSTANCE.logError("Failed to save rewards! Error stack trace:");
                exception.printStackTrace();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000bJ\u0010\u0010\u000f\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\rJ8\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\rJ\u0010\u0010\u0017\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u000bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\u000bR\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0018\u001a\u0004\b\u001a\u0010\u000bR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001b\u001a\u0004\b\u001c\u0010\rR\u0017\u0010\u0007\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001b\u001a\u0004\b\u001d\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/rafacasari/mod/cobbledex/api/PokedexRewards$PokedexReward;", "", "", "id", "", "pokemonCaught", "itemId", "quantity", "<init>", "(Ljava/lang/String;ILjava/lang/String;I)V", "component1", "()Ljava/lang/String;", "component2", "()I", "component3", "component4", "copy", "(Ljava/lang/String;ILjava/lang/String;I)Lcom/rafacasari/mod/cobbledex/api/PokedexRewards$PokedexReward;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "Ljava/lang/String;", "getId", "getItemId", "I", "getPokemonCaught", "getQuantity", "common"})
    public static final class PokedexReward {
        @NotNull
        private final String id;
        private final int pokemonCaught;
        @NotNull
        private final String itemId;
        private final int quantity;

        public PokedexReward(@NotNull String id, int pokemonCaught, @NotNull String itemId, int quantity) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
            this.id = id;
            this.pokemonCaught = pokemonCaught;
            this.itemId = itemId;
            this.quantity = quantity;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        public final int getPokemonCaught() {
            return this.pokemonCaught;
        }

        @NotNull
        public final String getItemId() {
            return this.itemId;
        }

        public final int getQuantity() {
            return this.quantity;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        public final int component2() {
            return this.pokemonCaught;
        }

        @NotNull
        public final String component3() {
            return this.itemId;
        }

        public final int component4() {
            return this.quantity;
        }

        @NotNull
        public final PokedexReward copy(@NotNull String id, int pokemonCaught, @NotNull String itemId, int quantity) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
            return new PokedexReward(id, pokemonCaught, itemId, quantity);
        }

        public static /* synthetic */ PokedexReward copy$default(PokedexReward pokedexReward, String string, int n, String string2, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = pokedexReward.id;
            }
            if ((n3 & 2) != 0) {
                n = pokedexReward.pokemonCaught;
            }
            if ((n3 & 4) != 0) {
                string2 = pokedexReward.itemId;
            }
            if ((n3 & 8) != 0) {
                n2 = pokedexReward.quantity;
            }
            return pokedexReward.copy(string, n, string2, n2);
        }

        @NotNull
        public String toString() {
            return "PokedexReward(id=" + this.id + ", pokemonCaught=" + this.pokemonCaught + ", itemId=" + this.itemId + ", quantity=" + this.quantity + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + Integer.hashCode(this.pokemonCaught);
            result = result * 31 + this.itemId.hashCode();
            result = result * 31 + Integer.hashCode(this.quantity);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PokedexReward)) {
                return false;
            }
            PokedexReward pokedexReward = (PokedexReward)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)pokedexReward.id)) {
                return false;
            }
            if (this.pokemonCaught != pokedexReward.pokemonCaught) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.itemId, (Object)pokedexReward.itemId)) {
                return false;
            }
            return this.quantity == pokedexReward.quantity;
        }
    }
}

