/*
 * Decompiled with CFR 0.152.
 */
package net.ottertimes.cobblefoods.block.entity;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import net.ottertimes.cobblefoods.block.entity.CobblefoodsBlockEntities;
import net.ottertimes.cobblefoods.block.entity.ImplementedInventory;
import net.ottertimes.cobblefoods.item.custom.CobblefoodsMixedJuiceItem;
import net.ottertimes.cobblefoods.recipe.CobblefoodsBerryBlenderRecipe;
import net.ottertimes.cobblefoods.screen.berry_blender.CobblefoodsBerryBlenderScreenHandler;
import net.ottertimes.cobblefoods.util.CobblefoodsSoundEvents;
import net.ottertimes.cobblefoods.util.CobblefoodsTags;
import org.jetbrains.annotations.Nullable;

public class CobblefoodsBerryBlenderBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
ImplementedInventory {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)6, (Object)class_1799.field_8037);
    public static final int BERRY_SLOTS = 3;
    public static final int BERRY_SLOT_A = 0;
    public static final int BERRY_SLOT_B = 1;
    public static final int BERRY_SLOT_C = 2;
    public static final int LIQUID_SLOT = 3;
    public static final int CONTAINER_SLOT = 4;
    public static final int OUTPUT_SLOT = 5;
    private static final int TOTAL_SLOTS = 6;
    private static final int PROGRESS_SPEED = 2;
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> CobblefoodsBerryBlenderBlockEntity.this.progress;
                case 1 -> CobblefoodsBerryBlenderBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    CobblefoodsBerryBlenderBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    CobblefoodsBerryBlenderBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int method_17389() {
            return 6;
        }
    };
    private int progress = 0;
    private int maxProgress = 72;

    public CobblefoodsBerryBlenderBlockEntity(class_2338 pos, class_2680 state) {
        super(CobblefoodsBlockEntities.BERRY_BLENDER_BLOCK_ENTITY, pos, state);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.entity.cobblefoods.berry_blender");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new CobblefoodsBerryBlenderScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    protected void method_11007(class_2487 nbt) {
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("progress", this.progress);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.progress = nbt.method_10550("progress");
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (world.method_8608()) {
            return;
        }
        if (!this.isJuiceSlotEmptyOrRecievable()) {
            return;
        }
        if (!this.hasRecipe()) {
            this.resetProgress();
            CobblefoodsBerryBlenderBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
            return;
        }
        this.increaseCraftProgress();
        CobblefoodsBerryBlenderBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
        if (this.hasCraftingFinished()) {
            this.craftItem();
            this.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        Optional<CobblefoodsBerryBlenderRecipe> optionalRecipe = this.getCurrentRecipe();
        if (optionalRecipe.isEmpty()) {
            return;
        }
        CobblefoodsBerryBlenderRecipe recipe = optionalRecipe.get();
        class_1799 recipeOutput = recipe.method_8110(null);
        String[] ingredients = new String[]{this.getItemId(this.method_5438(0)), this.getItemId(this.method_5438(1)), this.getItemId(this.method_5438(2))};
        this.method_5434(0, 1);
        this.method_5434(1, 1);
        this.method_5434(2, 1);
        if (recipe.takesContainer()) {
            this.method_5434(4, 1);
            class_1792 liquidItem = this.method_5438(3).method_7909();
            if (liquidItem.method_7857()) {
                this.method_5447(3, new class_1799((class_1935)liquidItem.method_7858()));
            } else if (liquidItem.equals(class_1802.field_8574)) {
                this.method_5447(3, new class_1799((class_1935)class_1802.field_8469));
            } else {
                this.method_5434(3, 1);
            }
        } else {
            this.method_5434(3, 1);
        }
        class_1799 output = new class_1799((class_1935)recipeOutput.method_7909(), this.method_5438(5).method_7947() + recipeOutput.method_7947());
        if (output.method_7909() instanceof CobblefoodsMixedJuiceItem) {
            CobblefoodsMixedJuiceItem.setJuiceNbt(output, ingredients);
        }
        this.method_5447(5, output);
        if (this.field_11863 != null) {
            this.field_11863.method_8396(null, this.field_11867, CobblefoodsSoundEvents.BERRY_BLENDER_USE, class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    private String getItemId(class_1799 stack) {
        return class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftProgress() {
        this.progress += 2;
    }

    private Optional<CobblefoodsBerryBlenderRecipe> getCurrentRecipe() {
        class_1277 inv = new class_1277(this.method_5439());
        for (int i = 0; i < this.method_5439(); ++i) {
            inv.method_5447(i, this.method_5438(i));
        }
        List validrecipes = this.method_10997().method_8433().method_17877((class_3956)CobblefoodsBerryBlenderRecipe.Type.INSTANCE, (class_1263)inv, this.method_10997());
        Optional<CobblefoodsBerryBlenderRecipe> selectedrecipe = Optional.empty();
        block1: for (int prioritycheck = 2; prioritycheck > -1; --prioritycheck) {
            for (CobblefoodsBerryBlenderRecipe validrecipe : validrecipes) {
                if (validrecipe.getPriority() != prioritycheck) continue;
                selectedrecipe = Optional.of(validrecipe);
                break block1;
            }
        }
        return selectedrecipe;
    }

    private boolean hasRecipe() {
        Optional<CobblefoodsBerryBlenderRecipe> optionalRecipe = this.getCurrentRecipe();
        if (optionalRecipe.isEmpty()) {
            return false;
        }
        CobblefoodsBerryBlenderRecipe recipe = optionalRecipe.get();
        class_1799 output = recipe.method_8110(null);
        return this.canInsertAmountIntoJuiceSlot(output) && this.canInsertItemIntoJuiceSlot(output.method_7909());
    }

    private boolean canInsertItemIntoJuiceSlot(class_1792 item) {
        class_1799 juiceSlot = this.method_5438(5);
        if (juiceSlot.method_7960()) {
            return true;
        }
        class_1792 slotItem = juiceSlot.method_7909();
        if (!item.equals(slotItem)) {
            return false;
        }
        if (!(slotItem instanceof CobblefoodsMixedJuiceItem)) {
            return true;
        }
        class_2487 nbt = juiceSlot.method_7969();
        HashSet<String> composition = new HashSet<String>();
        composition.add(nbt.method_10558("berry_a"));
        composition.add(nbt.method_10558("berry_b"));
        composition.add(nbt.method_10558("berry_c"));
        HashSet<String> ingredients = new HashSet<String>();
        ingredients.add(this.getItemId(this.method_5438(0)));
        ingredients.add(this.getItemId(this.method_5438(1)));
        ingredients.add(this.getItemId(this.method_5438(2)));
        return composition.equals(ingredients);
    }

    private boolean canInsertAmountIntoJuiceSlot(class_1799 result) {
        return this.method_5438(5).method_7947() + result.method_7947() <= this.method_5438(5).method_7914();
    }

    private boolean isJuiceSlotEmptyOrRecievable() {
        return this.method_5438(5).method_7960() || this.method_5438(5).method_7947() < this.method_5438(5).method_7914();
    }

    @Override
    public void method_5431() {
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        super.method_5431();
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 side) {
        if (side == null) {
            return false;
        }
        if (side.method_10166() == class_2350.class_2351.field_11052) {
            return slot == 0 || slot == 1 || slot == 2;
        }
        if (slot == 4) {
            return stack.method_31573(CobblefoodsTags.BERRY_BLENDER_CONTAINERS);
        }
        if (slot == 3) {
            return stack.method_31573(CobblefoodsTags.BERRY_BLENDER_LIQUIDS);
        }
        return false;
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 side) {
        return switch (slot) {
            case 5 -> true;
            case 3 -> stack.method_31573(CobblefoodsTags.BERRY_BLENDER_REMAINDERS);
            default -> false;
        };
    }

    public Object getRenderData() {
        return this.method_5438(5);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }
}

