/*
 * Decompiled with CFR 0.152.
 */
package net.ottertimes.cobblefoods.block.entity;

import com.mojang.datafixers.util.Pair;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4730;
import net.minecraft.class_5614;
import net.minecraft.class_765;
import net.minecraft.class_827;
import net.ottertimes.cobblefoods.block.entity.CobblefoodsBerryBlenderBlockEntity;
import net.ottertimes.cobblefoods.client.BerryBlenderDrinkModel;
import net.ottertimes.cobblefoods.util.CobblefoodsColorProviders;
import net.ottertimes.cobblefoods.util.CobblefoodsTags;

public class CobblefoodsBerryBlenderRenderer
implements class_827<CobblefoodsBerryBlenderBlockEntity> {
    private static final class_2960 WATER_TEXTURE = new class_2960("cobblefoods", "block/berry_blender_water");
    private static final class_2960 MILK_TEXTURE = new class_2960("cobblefoods", "block/berry_blender_milk");
    private static final class_2960 DRINK_TEXTURE = new class_2960("cobblefoods", "block/berry_blender_drink");
    private static final int WAIT_TICKS = 2;
    private CobblefoodsBerryBlenderBlockEntity cachedEntity = null;
    private Pair<class_2960, float[]> cachedTextureAndColor = null;

    public CobblefoodsBerryBlenderRenderer(class_5614.class_5615 ctx) {
    }

    public void render(CobblefoodsBerryBlenderBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_1937 world = entity.method_10997();
        if (world == null) {
            return;
        }
        Pair<class_2960, float[]> fluidTextureAndColor = this.getBlenderContentTextureAndColor(entity);
        if (fluidTextureAndColor == null) {
            return;
        }
        matrices.method_22903();
        matrices.method_46416(0.5f, -0.9375f, 0.5f);
        class_4588 vertexConsumer = new class_4730(class_1723.field_21668, (class_2960)fluidTextureAndColor.getFirst()).method_24145(vertexConsumers, class_1921::method_23689);
        float[] colors = (float[])fluidTextureAndColor.getSecond();
        BerryBlenderDrinkModel.fluidFrames[(int)(world.method_8510() / 2L) % 32].method_22699(matrices, vertexConsumer, this.getLightLevel(world, entity.method_11016()), overlay, colors[0], colors[1], colors[2], 1.0f);
        matrices.method_22909();
    }

    private float[] getColorChannelsWeight(int color) {
        return new float[]{(float)(color >> 16) / 255.0f, (float)((color & 0xFF00) >> 8) / 255.0f, (float)(color & 0xFF) / 255.0f};
    }

    private Pair<class_2960, float[]> getBlenderContentTextureAndColor(CobblefoodsBerryBlenderBlockEntity entity) {
        if (entity.equals(this.cachedEntity)) {
            return this.cachedTextureAndColor;
        }
        class_1799 stack = entity.method_5438(5);
        if (!stack.method_7960()) {
            this.cachedTextureAndColor = new Pair((Object)DRINK_TEXTURE, (Object)this.getColorChannelsWeight(CobblefoodsColorProviders.getDrinkColor(stack)));
            return this.cachedTextureAndColor;
        }
        stack = entity.method_5438(3);
        if (stack.method_7960()) {
            this.cachedTextureAndColor = null;
            return null;
        }
        if (stack.method_31574(class_1802.field_8574)) {
            this.cachedTextureAndColor = class_1844.method_8063((class_1799)stack) == class_1847.field_8991 ? new Pair((Object)WATER_TEXTURE, (Object)this.getColorChannelsWeight(CobblefoodsColorProviders.getWaterColor(entity))) : null;
            return this.cachedTextureAndColor;
        }
        if (stack.method_31574(class_1802.field_8103)) {
            this.cachedTextureAndColor = new Pair((Object)MILK_TEXTURE, (Object)this.getColorChannelsWeight(0xFFFFFF));
            return this.cachedTextureAndColor;
        }
        if (stack.method_31573(CobblefoodsTags.BERRY_BLENDER_RENDERABLE)) {
            this.cachedTextureAndColor = new Pair((Object)DRINK_TEXTURE, (Object)this.getColorChannelsWeight(CobblefoodsColorProviders.getDrinkColor(stack)));
            return this.cachedTextureAndColor;
        }
        this.cachedTextureAndColor = null;
        return null;
    }

    private int getLightLevel(class_1937 world, class_2338 pos) {
        return class_765.method_23687((int)world.method_8314(class_1944.field_9282, pos), (int)world.method_8314(class_1944.field_9284, pos));
    }
}

