/*
 * Decompiled with CFR 0.152.
 */
package net.ottertimes.cobblefoods.item.custom;

import java.util.Arrays;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.ottertimes.cobblefoods.item.custom.CobblefoodsBerryJuiceItem;
import net.ottertimes.cobblefoods.util.CobblefoodsColors;
import org.jetbrains.annotations.Nullable;

public class CobblefoodsMixedJuiceItem
extends CobblefoodsBerryJuiceItem {
    public CobblefoodsMixedJuiceItem(class_1792.class_1793 settings) {
        super(settings, false);
    }

    public static int setJuiceNbt(class_1799 stack, String[] ingredients) {
        if (ingredients.length != 3) {
            return 0;
        }
        Arrays.sort(ingredients);
        int blendedColors = CobblefoodsMixedJuiceItem.blendColors(ingredients);
        class_2487 nbtData = new class_2487();
        nbtData.method_10582("berry_a", ingredients[0]);
        nbtData.method_10582("berry_b", ingredients[1]);
        nbtData.method_10582("berry_c", ingredients[2]);
        nbtData.method_10569("juice_color", blendedColors);
        stack.method_7980(nbtData);
        return blendedColors;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (stack.method_7985()) {
            class_2487 nbtData = stack.method_7969();
            tooltip.add((class_2561)class_2561.method_43471((String)this.getTranslationKey(nbtData.method_10558("berry_a"))).method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43471((String)this.getTranslationKey(nbtData.method_10558("berry_b"))).method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43471((String)this.getTranslationKey(nbtData.method_10558("berry_c"))).method_27692(class_124.field_1080));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)(this.method_7876() + ".tooltip")).method_27692(class_124.field_1080));
        }
    }

    private String getTranslationKey(String id) {
        return "item." + id.replaceFirst(":", ".");
    }

    private static int blendColors(String[] ingredients) {
        double size = ingredients.length;
        int colorA = CobblefoodsColors.getColor(ingredients[0]);
        int colorB = CobblefoodsColors.getColor(ingredients[1]);
        int colorC = CobblefoodsColors.getColor(ingredients[2]);
        double blendedRed = (CobblefoodsMixedJuiceItem.getChannelWeight(colorA >> 16) + CobblefoodsMixedJuiceItem.getChannelWeight(colorB >> 16) + CobblefoodsMixedJuiceItem.getChannelWeight(colorC >> 16)) / size;
        double blendedGreen = (CobblefoodsMixedJuiceItem.getChannelWeight((colorA & 0xFF00) >> 8) + CobblefoodsMixedJuiceItem.getChannelWeight((colorB & 0xFF00) >> 8) + CobblefoodsMixedJuiceItem.getChannelWeight((colorC & 0xFF00) >> 8)) / size;
        double blendedBlue = (CobblefoodsMixedJuiceItem.getChannelWeight(colorA & 0xFF) + CobblefoodsMixedJuiceItem.getChannelWeight(colorB & 0xFF) + CobblefoodsMixedJuiceItem.getChannelWeight(colorC & 0xFF)) / size;
        return CobblefoodsMixedJuiceItem.getChannelColor(blendedRed) << 16 | CobblefoodsMixedJuiceItem.getChannelColor(blendedGreen) << 8 | CobblefoodsMixedJuiceItem.getChannelColor(blendedBlue);
    }

    private static double getChannelWeight(int channel) {
        return Math.sqrt((double)channel / 255.0);
    }

    private static int getChannelColor(double weight) {
        return (int)(255.0 * weight * weight);
    }
}

