/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.chaining.util;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1657;
import org.jetbrains.annotations.NotNull;
import us.timinc.mc.cobblemon.chaining.config.BoostConfig;
import us.timinc.mc.cobblemon.counter.api.CaptureApi;
import us.timinc.mc.cobblemon.counter.api.KoApi;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ%\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ1\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\r\u00a2\u0006\u0004\b\u0011\u0010\u0012J/\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\r\"\u0004\b\u0000\u0010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u0015\u001a\u00020\b\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lus/timinc/mc/cobblemon/chaining/util/Util;", "", "Lnet/minecraft/class_1657;", "player", "", "species", "Lus/timinc/mc/cobblemon/chaining/config/BoostConfig;", "config", "", "getPlayerScore", "(Lnet/minecraft/class_1657;Ljava/lang/String;Lus/timinc/mc/cobblemon/chaining/config/BoostConfig;)I", "Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "pokemon", "", "whitelist", "blacklist", "", "matchesList", "(Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;Ljava/util/Set;Ljava/util/Set;)Z", "T", "inputSet", "numToPick", "pickRandomItems", "(Ljava/util/Set;I)Ljava/util/Set;", "pokemonProps", "label", "pokemonHasLabel", "(Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;Ljava/lang/String;)Z", "<init>", "()V", "cobblemon-unchained"})
@SourceDebugExtension(value={"SMAP\nUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Util.kt\nus/timinc/mc/cobblemon/chaining/util/Util\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1747#2,3:60\n2624#2,3:63\n1747#2,3:66\n2624#2,3:69\n*S KotlinDebug\n*F\n+ 1 Util.kt\nus/timinc/mc/cobblemon/chaining/util/Util\n*L\n34#1:60,3\n38#1:63,3\n40#1:66,3\n41#1:69,3\n*E\n"})
public final class Util {
    @NotNull
    public static final Util INSTANCE = new Util();

    private Util() {
    }

    @NotNull
    public final <T> Set<T> pickRandomItems(@NotNull Set<? extends T> inputSet, int numToPick) {
        Intrinsics.checkNotNullParameter(inputSet, (String)"inputSet");
        if (numToPick <= 0 || numToPick > inputSet.size()) {
            throw new IllegalArgumentException("Invalid number of items to pick");
        }
        List inputList = CollectionsKt.toMutableList((Collection)inputSet);
        Set pickedItems = new LinkedHashSet();
        int n = 0;
        while (n < numToPick) {
            int it = n++;
            boolean bl = false;
            int randomIndex = RangesKt.random((IntRange)RangesKt.until((int)0, (int)inputList.size()), (Random)((Random)Random.Default));
            Object randomItem = inputList.remove(randomIndex);
            pickedItems.add(randomItem);
        }
        return pickedItems;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean pokemonHasLabel(PokemonProperties pokemonProps, String label) {
        Pokemon pokemon = pokemonProps.create();
        String[] stringArray = new String[]{label};
        if (pokemon.hasLabels(stringArray)) return true;
        String string = pokemon.getSpecies().getName().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        if (!Intrinsics.areEqual((Object)string, (Object)label)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean matchesList(@NotNull PokemonProperties pokemon, @NotNull Set<String> whitelist, @NotNull Set<String> blacklist) {
        String it;
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Intrinsics.checkNotNullParameter(whitelist, (String)"whitelist");
        Intrinsics.checkNotNullParameter(blacklist, (String)"blacklist");
        if (!((Collection)whitelist).isEmpty() && !((Collection)blacklist).isEmpty()) {
            String it2;
            boolean bl;
            Iterable $this$any$iv = whitelist;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it2 = (String)element$iv;
                    boolean bl2 = false;
                    if (!INSTANCE.pokemonHasLabel(pokemon, it2)) continue;
                    return true;
                }
                bl = false;
            }
            if (bl) return true;
            Iterable $this$none$iv = blacklist;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                return true;
            }
            Iterator iterator = $this$none$iv.iterator();
            do {
                Object element$iv;
                if (!iterator.hasNext()) return true;
                element$iv = iterator.next();
                it2 = (String)element$iv;
                boolean bl3 = false;
            } while (!INSTANCE.pokemonHasLabel(pokemon, it2));
            return false;
        }
        if (!((Collection)whitelist).isEmpty()) {
            String it3;
            Iterable $this$any$iv = whitelist;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it3 = (String)element$iv;
                boolean bl = false;
            } while (!INSTANCE.pokemonHasLabel(pokemon, it3));
            return true;
        }
        if (((Collection)blacklist).isEmpty()) return true;
        boolean bl = true;
        if (!bl) return true;
        Iterable $this$none$iv = blacklist;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$none$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl4 = false;
        } while (!INSTANCE.pokemonHasLabel(pokemon, it));
        return false;
    }

    public final int getPlayerScore(@NotNull class_1657 player, @NotNull String species, @NotNull BoostConfig config) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)species, (String)"species");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Pair koStreakData = KoApi.INSTANCE.getStreak(player);
        int koStreak = Intrinsics.areEqual((Object)koStreakData.getFirst(), (Object)species) ? ((Number)koStreakData.getSecond()).intValue() : 0;
        int koCount = KoApi.INSTANCE.getCount(player, species);
        Pair captureStreakData = CaptureApi.INSTANCE.getStreak(player);
        int captureStreak = Intrinsics.areEqual((Object)captureStreakData.getFirst(), (Object)species) ? ((Number)captureStreakData.getSecond()).intValue() : 0;
        int captureCount = CaptureApi.INSTANCE.getCount(player, species);
        return koStreak * config.getKoStreakPoints() + koCount * config.getKoCountPoints() + captureStreak * config.getCaptureStreakPoints() + captureCount * config.getCaptureCountPoints();
    }
}

