/*
 * Decompiled with CFR 0.152.
 */
package winterwolfsv.cobblemon_quests.config;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import winterwolfsv.cobblemon_quests.CobblemonQuests;

public class CobblemonQuestsConfig {
    public static Path configPath = CobblemonQuests.configPath;
    public static double configVersion = 1.0;
    public static List<String> ignoredPokemon = new ArrayList<String>();
    public static boolean suppressWarnings = false;

    public static void init() {
        File configFile = configPath.toFile();
        CobblemonQuestsConfig.load(configFile);
    }

    private static void load(File configFile) {
        if (!configFile.exists()) {
            CobblemonQuestsConfig.createDefaultConfig(configFile);
            return;
        }
        try {
            block12: for (String line : Files.readAllLines(configPath)) {
                String[] split = line.split(":");
                if (split.length != 2) {
                    if (split[0].equals("ignoredPokemon")) continue;
                    CobblemonQuests.LOGGER.warning("Failed to parse config line: " + line);
                    continue;
                }
                String key = split[0].trim();
                String value = split[1].trim();
                switch (key) {
                    case "configVersion": {
                        if (!(Double.parseDouble(value) < configVersion)) continue block12;
                        CobblemonQuests.LOGGER.info("CobblemonQuestsConfig file for Cobblemon Quests is outdated. Attempting to migrate.");
                        continue block12;
                    }
                    case "suppressWarnings": {
                        suppressWarnings = Boolean.parseBoolean(value);
                        continue block12;
                    }
                    case "ignoredPokemon": {
                        ignoredPokemon = new ArrayList<String>(List.of((String[])Arrays.stream(value.split(",")).map(String::trim).toArray(String[]::new)));
                        continue block12;
                    }
                }
                CobblemonQuests.LOGGER.warning("Unknown config key: " + key);
            }
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Failed to load config file for Cobblemon Quests. This is a critical error and may cause crashes. " + e);
        }
    }

    public static void save() {
        File configFile = configPath.toFile();
        CobblemonQuestsConfig.createDefaultConfig(configFile);
    }

    private static void createDefaultConfig(File configFile) {
        if (!configFile.exists()) {
            try {
                Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                if (!Files.exists(configPath, new LinkOption[0])) {
                    Files.createFile(configPath, new FileAttribute[0]);
                }
            }
            catch (IOException e) {
                CobblemonQuests.LOGGER.warning("Failed to create config directory or file. Please report this with a log file to WinterWolfSV " + e);
            }
        }
        try {
            ArrayList<CallSite> defaultConfig = new ArrayList<CallSite>();
            defaultConfig.add((CallSite)((Object)("configVersion: " + configVersion)));
            defaultConfig.add((CallSite)((Object)("ignoredPokemon: " + String.join((CharSequence)", ", ignoredPokemon))));
            defaultConfig.add((CallSite)((Object)("suppressWarnings: " + suppressWarnings)));
            Files.write(configPath, defaultConfig, new OpenOption[0]);
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Failed to populate config file for Cobblemon Quests. " + e);
        }
    }
}

