/*
 * Decompiled with CFR 0.152.
 */
package winterwolfsv.cobblemon_quests.events;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.battles.BattleVictoryEvent;
import com.cobblemon.mod.common.api.events.pokemon.LevelUpEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonCapturedEvent;
import com.cobblemon.mod.common.api.events.pokemon.TradeCompletedEvent;
import com.cobblemon.mod.common.api.events.pokemon.evolution.EvolutionAcceptedEvent;
import com.cobblemon.mod.common.api.events.pokemon.evolution.EvolutionCompleteEvent;
import com.cobblemon.mod.common.api.events.starter.StarterChosenEvent;
import com.cobblemon.mod.common.api.events.storage.ReleasePokemonEvent;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.ftb.mods.ftbquests.api.QuestFile;
import dev.ftb.mods.ftbquests.events.ClearFileCacheEvent;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.data.TeamManagerImpl;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import kotlin.Unit;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import winterwolfsv.cobblemon_quests.CobblemonQuests;
import winterwolfsv.cobblemon_quests.tasks.CobblemonTask;

public class FTBCobblemonEventHandler {
    private List<CobblemonTask> pokemonTasks = null;
    private UUID lastPokemonUuid = null;

    public FTBCobblemonEventHandler init() {
        EntityEvent.LIVING_DEATH.register(this::entityKill);
        ClearFileCacheEvent.EVENT.register(this::fileCacheClear);
        CobblemonEvents.POKEMON_CAPTURED.subscribe(Priority.LOWEST, this::pokemonCatch);
        CobblemonEvents.BATTLE_VICTORY.subscribe(Priority.LOWEST, this::pokemonBattleVictory);
        CobblemonEvents.STARTER_CHOSEN.subscribe(Priority.LOWEST, this::pokemonStarterChosen);
        CobblemonEvents.EVOLUTION_COMPLETE.subscribe(Priority.LOWEST, this::pokemonEvolutionComplete);
        CobblemonEvents.LEVEL_UP_EVENT.subscribe(Priority.LOWEST, this::pokemonLevelUp);
        CobblemonEvents.EVOLUTION_ACCEPTED.subscribe(Priority.LOWEST, this::pokemonEvolutionAccepted);
        CobblemonEvents.TRADE_COMPLETED.subscribe(Priority.LOWEST, this::pokemonTrade);
        CobblemonEvents.POKEMON_RELEASED_EVENT_PRE.subscribe(Priority.LOWEST, this::pokemonRelease);
        return this;
    }

    private void fileCacheClear(QuestFile file) {
        if (file.isServerSide()) {
            this.pokemonTasks = null;
        }
    }

    private Unit pokemonRelease(ReleasePokemonEvent.Pre pre) {
        try {
            class_3222 player = pre.getPlayer();
            Pokemon pokemon = pre.getPokemon();
            this.processTasksForTeam(pokemon, "release", 1L, player);
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Error processing release event " + Arrays.toString(e.getStackTrace()));
        }
        return Unit.INSTANCE;
    }

    private Unit pokemonTrade(TradeCompletedEvent tradeCompletedEvent) {
        try {
            Pokemon pokemonGivenByPlayer1 = tradeCompletedEvent.getTradeParticipant2Pokemon();
            Pokemon pokemonGivenByPlayer2 = tradeCompletedEvent.getTradeParticipant1Pokemon();
            class_3222 player1 = pokemonGivenByPlayer2.getOwnerPlayer();
            class_3222 player2 = pokemonGivenByPlayer1.getOwnerPlayer();
            this.processTasksForTeam(pokemonGivenByPlayer2, "trade_for", 1L, player1);
            this.processTasksForTeam(pokemonGivenByPlayer1, "trade_away", 1L, player1);
            this.processTasksForTeam(pokemonGivenByPlayer1, "trade_for", 1L, player2);
            this.processTasksForTeam(pokemonGivenByPlayer2, "trade_away", 1L, player2);
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Error processing trade event " + Arrays.toString(e.getStackTrace()));
        }
        return Unit.INSTANCE;
    }

    private Unit pokemonBattleVictory(BattleVictoryEvent battleVictoryEvent) {
        try {
            List players = battleVictoryEvent.getBattle().getPlayers();
            if (players.size() != 1) {
                return Unit.INSTANCE;
            }
            class_3222 player = (class_3222)players.get(0);
            if (!player.method_5477().equals(((BattleActor)battleVictoryEvent.getWinners().get(0)).getName())) {
                return Unit.INSTANCE;
            }
            Iterable battleActors = battleVictoryEvent.getBattle().getActors();
            for (BattleActor actor : battleActors) {
                if (((BattlePokemon)actor.getPokemonList().get(0)).getEffectedPokemon().getUuid() == this.lastPokemonUuid) {
                    return Unit.INSTANCE;
                }
                if (actor == battleVictoryEvent.getWinners().get(0)) continue;
                this.processTasksForTeam(((BattlePokemon)actor.getPokemonList().get(0)).getEffectedPokemon(), "defeat", 1L, player);
            }
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Error processing battle victory event " + Arrays.toString(e.getStackTrace()));
        }
        return Unit.INSTANCE;
    }

    private Unit pokemonCatch(PokemonCapturedEvent pokemonCapturedEvent) {
        this.lastPokemonUuid = pokemonCapturedEvent.getPokemon().getUuid();
        return this.pokemonCatch(pokemonCapturedEvent.getPokemon(), pokemonCapturedEvent.getPlayer());
    }

    private EventResult entityKill(class_1309 livingEntity, class_1282 damageSource) {
        try {
            class_3222 player;
            class_1297 class_12972 = damageSource.method_5529();
            if (class_12972 instanceof class_3222 && !PlayerHooks.isFake((class_1657)(player = (class_3222)class_12972))) {
                Pokemon pokemon;
                Pokemon pokemon2 = pokemon = livingEntity instanceof PokemonEntity ? ((PokemonEntity)livingEntity).getPokemon() : null;
                if (pokemon == null) {
                    return EventResult.pass();
                }
                this.processTasksForTeam(pokemon, "kill", 1L, player);
            }
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Error processing entity kill event " + Arrays.toString(e.getStackTrace()));
        }
        return EventResult.pass();
    }

    public Unit pokemonCatch(Pokemon pokemon, class_3222 player) {
        try {
            this.processTasksForTeam(pokemon, "catch", 1L, player);
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Error processing catch event " + Arrays.toString(e.getStackTrace()));
        }
        return Unit.INSTANCE;
    }

    public void pokemonObtain(Pokemon pokemon, class_3222 player) {
        try {
            this.processTasksForTeam(pokemon, "obtain", 1L, player);
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Error processing obtain event " + Arrays.toString(e.getStackTrace()));
        }
    }

    private Unit pokemonStarterChosen(StarterChosenEvent starterChosenEvent) {
        try {
            class_3222 player = starterChosenEvent.getPlayer();
            Pokemon pokemon = starterChosenEvent.getPokemon();
            this.processTasksForTeam(pokemon, "select_starter", 1L, player);
            this.pokemonCatch(pokemon, player);
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Error processing starter chosen event " + Arrays.toString(e.getStackTrace()));
        }
        return Unit.INSTANCE;
    }

    private Unit pokemonEvolutionComplete(EvolutionCompleteEvent evolutionCompleteEvent) {
        try {
            Pokemon pokemon = evolutionCompleteEvent.getPokemon();
            return this.pokemonCatch(pokemon, pokemon.getOwnerPlayer());
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Error processing evolution complete event " + Arrays.toString(e.getStackTrace()));
            return Unit.INSTANCE;
        }
    }

    private Unit pokemonEvolutionAccepted(EvolutionAcceptedEvent evolutionAcceptedEvent) {
        try {
            Pokemon pokemon = evolutionAcceptedEvent.getPokemon();
            class_3222 player = pokemon.getOwnerPlayer();
            this.processTasksForTeam(pokemon, "evolve", 1L, player);
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Error processing evolution event " + Arrays.toString(e.getStackTrace()));
        }
        return Unit.INSTANCE;
    }

    private Unit pokemonLevelUp(LevelUpEvent levelUpEvent) {
        try {
            class_3222 player = levelUpEvent.getPokemon().getOwnerPlayer();
            Pokemon pokemon = levelUpEvent.getPokemon();
            long deltaLevel = levelUpEvent.getNewLevel() - levelUpEvent.getOldLevel();
            System.out.println("Old level: " + levelUpEvent.getOldLevel() + " New level: " + levelUpEvent.getNewLevel() + " Delta level: " + deltaLevel);
            this.processTasksForTeam(pokemon, "level_up_to", levelUpEvent.getNewLevel(), player);
            this.processTasksForTeam(pokemon, "level_up", deltaLevel, player);
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Error processing level up event " + Arrays.toString(e.getStackTrace()));
        }
        return Unit.INSTANCE;
    }

    public void fossilRevivedHandler(class_3222 player, Pokemon pokemon) {
        try {
            this.processTasksForTeam(pokemon, "revive_fossil", 1L, player);
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Error processing fossil revive event " + Arrays.toString(e.getStackTrace()));
        }
    }

    private void processTasksForTeam(Pokemon pokemon, String action, long amount, class_3222 player) {
        try {
            if (this.pokemonTasks == null) {
                this.pokemonTasks = ServerQuestFile.INSTANCE.collect(CobblemonTask.class);
            }
            if (this.pokemonTasks.isEmpty()) {
                return;
            }
            Team team = TeamManagerImpl.INSTANCE.getTeamForPlayer(player).orElse(null);
            if (team == null) {
                return;
            }
            TeamData data = ServerQuestFile.INSTANCE.getOrCreateTeamData(team);
            for (CobblemonTask task : this.pokemonTasks) {
                if (data.getProgress((Task)task) >= task.getMaxProgress() || !data.canStartTasks(task.getQuest())) continue;
                task.CobblemonTaskIncrease(data, pokemon, action, amount, player);
            }
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Error processing task for team " + Arrays.toString(e.getStackTrace()));
        }
    }
}

