/*
 * Decompiled with CFR 0.152.
 */
package winterwolfsv.cobblemon_quests.tasks;

import com.cobblemon.mod.common.api.pokeball.PokeBalls;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.pokemon.Pokemon;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.EnumConfig;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import winterwolfsv.cobblemon_quests.config.CobblemonQuestsConfig;
import winterwolfsv.cobblemon_quests.tasks.PokemonTaskTypes;

public class CobblemonTask
extends Task {
    public Icon pokeBallIcon = ItemIcon.getItemIcon((class_1792)PokeBalls.INSTANCE.getPOKE_BALL().item());
    public long amount = 1L;
    public boolean shiny = false;
    public long timeMin = 0L;
    public long timeMax = 24000L;
    public ArrayList<String> actions = new ArrayList<String>(List.of("catch"));
    public ArrayList<String> biomes = new ArrayList();
    public ArrayList<String> dimensions = new ArrayList();
    public ArrayList<String> forms = new ArrayList();
    public ArrayList<String> genders = new ArrayList();
    public ArrayList<String> pokeBallsUsed = new ArrayList();
    public ArrayList<String> pokemons = new ArrayList();
    public ArrayList<String> pokemonTypes = new ArrayList();
    public ArrayList<String> regions = new ArrayList();

    public CobblemonTask(long id, Quest quest) {
        super(id, quest);
    }

    public TaskType getType() {
        return PokemonTaskTypes.COBBLEMON;
    }

    public long getMaxProgress() {
        return this.amount;
    }

    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        nbt.method_10544("amount", this.amount);
        nbt.method_10556("shiny", this.shiny);
        nbt.method_10544("time_min", this.timeMin);
        nbt.method_10544("time_max", this.timeMax);
        nbt.method_10582("action", this.writeArrayList(this.actions));
        nbt.method_10582("biome", this.writeArrayList(this.biomes));
        nbt.method_10582("dimension", this.writeArrayList(this.dimensions));
        nbt.method_10582("pokemon", this.writeArrayList(this.pokemons));
        nbt.method_10582("form", this.writeArrayList(this.forms));
        nbt.method_10582("gender", this.writeArrayList(this.genders));
        nbt.method_10582("poke_ball_used", this.writeArrayList(this.pokeBallsUsed));
        nbt.method_10582("pokemon_type", this.writeArrayList(this.pokemonTypes));
        nbt.method_10582("region", this.writeArrayList(this.regions));
    }

    public void readData(class_2487 nbt) {
        super.readData(nbt);
        this.amount = nbt.method_10537("amount");
        this.shiny = nbt.method_10577("shiny");
        this.timeMin = nbt.method_10537("time_min");
        this.timeMax = nbt.method_10537("time_max");
        this.actions = this.readArrayList(nbt.method_10558("action"));
        this.biomes = this.readArrayList(nbt.method_10558("biome"));
        this.dimensions = this.readArrayList(nbt.method_10558("dimension"));
        this.pokemons = this.readArrayList(nbt.method_10558("pokemon"));
        this.forms = this.readArrayList(nbt.method_10558("form"));
        this.genders = this.readArrayList(nbt.method_10558("gender"));
        this.pokeBallsUsed = this.readArrayList(nbt.method_10558("poke_ball_used"));
        this.pokemonTypes = this.readArrayList(nbt.method_10558("pokemon_type"));
        this.regions = this.readArrayList(nbt.method_10558("region"));
        if (this.timeMin == this.timeMax && this.timeMin == 0L) {
            this.timeMax = 24000L;
        }
        if (nbt.method_10545("value")) {
            this.amount = nbt.method_10537("value");
        }
        if (nbt.method_10545("entity")) {
            this.pokemons = this.readArrayList(nbt.method_10558("entity"));
        }
        if (this.amount == 0L) {
            this.amount = 1L;
        }
        this.pokemons.remove("minecraft:");
    }

    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        buffer.writeLong(this.amount);
        buffer.writeBoolean(this.shiny);
        buffer.writeLong(this.timeMin);
        buffer.writeLong(this.timeMax);
        buffer.method_10788(this.writeArrayList(this.pokemons), Short.MAX_VALUE);
        buffer.method_10788(this.writeArrayList(this.actions), Short.MAX_VALUE);
        buffer.method_10788(this.writeArrayList(this.biomes), Short.MAX_VALUE);
        buffer.method_10788(this.writeArrayList(this.dimensions), Short.MAX_VALUE);
        buffer.method_10788(this.writeArrayList(this.forms), Short.MAX_VALUE);
        buffer.method_10788(this.writeArrayList(this.genders), Short.MAX_VALUE);
        buffer.method_10788(this.writeArrayList(this.pokeBallsUsed), Short.MAX_VALUE);
        buffer.method_10788(this.writeArrayList(this.pokemonTypes), Short.MAX_VALUE);
        buffer.method_10788(this.writeArrayList(this.regions), Short.MAX_VALUE);
    }

    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        this.amount = buffer.readLong();
        this.shiny = buffer.readBoolean();
        this.timeMin = buffer.readLong();
        this.timeMax = buffer.readLong();
        this.pokemons = this.readArrayList(buffer.method_10800(Short.MAX_VALUE));
        this.actions = this.readArrayList(buffer.method_10800(Short.MAX_VALUE));
        this.biomes = this.readArrayList(buffer.method_10800(Short.MAX_VALUE));
        this.dimensions = this.readArrayList(buffer.method_10800(Short.MAX_VALUE));
        this.forms = this.readArrayList(buffer.method_10800(Short.MAX_VALUE));
        this.genders = this.readArrayList(buffer.method_10800(Short.MAX_VALUE));
        this.pokeBallsUsed = this.readArrayList(buffer.method_10800(Short.MAX_VALUE));
        this.pokemonTypes = this.readArrayList(buffer.method_10800(Short.MAX_VALUE));
        this.regions = this.readArrayList(buffer.method_10800(Short.MAX_VALUE));
    }

    public String writeArrayList(ArrayList<String> list) {
        list.removeIf(Objects::isNull);
        list = new ArrayList<String>(new LinkedHashSet<String>(list));
        return String.join((CharSequence)",", list);
    }

    public ArrayList<String> readArrayList(String s) {
        return Arrays.stream(s.split(",")).map(String::trim).filter(obj -> !obj.isEmpty() && !obj.contains("choice_any")).distinct().collect(Collectors.toCollection(ArrayList::new));
    }

    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        assert (class_310.method_1551().field_1687 != null);
        class_5455 registryManager = class_310.method_1551().field_1687.method_30349();
        List<String> actionList = Arrays.asList("catch", "defeat", "evolve", "kill", "level_up", "level_up_to", "release", "trade_away", "trade_for", "obtain", "select_starter", "revive_fossil");
        this.addConfigList(config, "actions", this.actions, actionList, null, null);
        Function<String, String> pokemonNameProcessor = name -> name.split(":")[0] + ".species." + name.split(":")[1] + ".name";
        ArrayList<String> pokemonList = new ArrayList<String>(PokemonSpecies.INSTANCE.getSpecies().stream().map(species -> species.resourceIdentifier.toString()).toList());
        Collections.sort(pokemonList);
        this.addConfigList(config, "pokemons", this.pokemons, pokemonList, this::getPokemonIcon, pokemonNameProcessor);
        config.addLong("amount", this.amount, v -> {
            this.amount = v;
        }, 1L, 1L, Long.MAX_VALUE).setNameKey("cobblemon_quests.task.amount");
        config.addBool("shiny", this.shiny, v -> {
            this.shiny = v;
        }, false).setNameKey("cobblemon_quests.task.shiny");
        Function<String, String> pokeBallNameProcessor = name -> "item." + name.replace(":", ".");
        ArrayList<String> pokeBallList = new ArrayList<String>(PokeBalls.INSTANCE.all().stream().map(pokeBall -> pokeBall.getName().toString()).toList());
        Collections.sort(pokeBallList);
        this.addConfigList(config, "pokeballs", this.pokeBallsUsed, pokeBallList, this::getIconFromIdentifier, pokeBallNameProcessor);
        List<String> formList = Arrays.asList("normal", "alola", "galar", "paldea", "hisui");
        this.addConfigList(config, "forms", this.forms, formList, null, null);
        List<String> genderList = Arrays.asList("male", "female", "genderless");
        this.addConfigList(config, "genders", this.genders, genderList, null, null);
        Function<String, String> pokemonTypeNameProcessor = name -> "cobblemon.type." + name;
        List<String> pokemonTypeList = Arrays.asList("normal", "fire", "water", "grass", "electric", "ice", "fighting", "poison", "ground", "flying", "psychic", "bug", "rock", "ghost", "dragon", "dark", "steel", "fairy");
        this.addConfigList(config, "pokemon_types", this.pokemonTypes, pokemonTypeList, null, pokemonTypeNameProcessor);
        List<String> regionList = Arrays.asList("gen1", "gen2", "gen3", "gen4", "gen5", "gen6", "gen7", "gen8", "gen9");
        this.addConfigList(config, "regions", this.regions, regionList, null, null);
        Function<String, String> biomeAndDimensionNameProcessor = name -> "(" + name.replace("_", " ").replace(":", ") ");
        ArrayList<String> biomesList = new ArrayList<String>(registryManager.method_30530(class_7924.field_41236).method_29722().stream().map(entry -> ((class_5321)entry.getKey()).method_29177().toString()).toList());
        this.addConfigList(config, "biomes", this.biomes, biomesList, null, biomeAndDimensionNameProcessor);
        ArrayList<String> dimensionsList = new ArrayList<String>(registryManager.method_30530(class_7924.field_41241).method_29722().stream().map(entry -> ((class_5321)entry.getKey()).method_29177().toString()).toList());
        dimensionsList.remove("minecraft:overworld_caves");
        this.addConfigList(config, "dimensions", this.dimensions, dimensionsList, null, biomeAndDimensionNameProcessor);
        config.addLong("time_min", this.timeMin, v -> {
            this.timeMin = v;
        }, 0L, 0L, 24000L).setNameKey("cobblemon_quests.task.time_min");
        config.addLong("time_max", this.timeMax, v -> {
            this.timeMax = v;
        }, 24000L, 0L, 24000L).setNameKey("cobblemon_quests.task.time_max");
    }

    private void addConfigList(ConfigGroup config, String listName, List<String> listData, List<String> optionsList, Function<class_2960, Icon> iconProcessor, Function<String, String> nameProcessor) {
        NameMap nameMap = NameMap.of((Object)optionsList.get(0), optionsList).id(s -> s).name(s -> class_2561.method_43471((String)(nameProcessor == null ? "cobblemon_quests." + listName + "." + s : (String)nameProcessor.apply((String)s)))).icon(s -> iconProcessor == null ? this.pokeBallIcon : (Icon)iconProcessor.apply(new class_2960(s))).create();
        config.addList(listName, listData, (ConfigValue)new EnumConfig(nameMap), (Object)optionsList.get(optionsList.size() - 1)).setNameKey("cobblemon_quests.task." + listName);
    }

    @Environment(value=EnvType.CLIENT)
    public class_2561 getAltTitle() {
        StringBuilder titleBuilder = new StringBuilder();
        for (String action : this.actions) {
            titleBuilder.append(class_2561.method_43471((String)("cobblemon_quests.actions." + action)).getString()).append(" ");
        }
        titleBuilder.append(this.amount).append("x ");
        if (this.shiny) {
            titleBuilder.append(class_2561.method_43471((String)"cobblemon_quests.task.shiny").getString()).append(" ");
        }
        for (String gender : this.genders) {
            titleBuilder.append(class_2561.method_43471((String)("cobblemon_quests.genders." + gender)).getString()).append(" ");
        }
        for (String form : this.forms) {
            titleBuilder.append(class_2561.method_43471((String)("cobblemon_quests.forms." + form)).getString()).append(" ");
        }
        for (String region : this.regions) {
            titleBuilder.append(class_2561.method_43471((String)("cobblemon_quests.regions." + region)).getString()).append(" ");
        }
        for (String pokemonType : this.pokemonTypes) {
            titleBuilder.append(class_2561.method_43471((String)("cobblemon.type." + pokemonType)).getString()).append(" ");
        }
        if (this.pokemons.isEmpty()) {
            titleBuilder.append(class_2561.method_43471((String)"cobblemon_quests.task.pokemons").getString()).append(" ");
        } else {
            for (String pokemon : this.pokemons) {
                titleBuilder.append(class_2561.method_43471((String)("cobblemon.species." + pokemon.split(":")[1] + ".name")).getString()).append(" ");
                if (this.pokemons.indexOf(pokemon) == this.pokemons.size() - 1) continue;
                titleBuilder.append("or ");
            }
        }
        for (String pokeballUsed : this.pokeBallsUsed) {
            if (this.pokeBallsUsed.indexOf(pokeballUsed) == 0) {
                titleBuilder.append("using a ");
            } else {
                titleBuilder.append("or ");
            }
            titleBuilder.append(class_2561.method_43471((String)("item." + pokeballUsed.replace(":", "."))).getString()).append(" ");
        }
        for (String dimension : this.dimensions) {
            titleBuilder.append("in ").append(dimension.split(":")[1].replace("_", " ")).append(" ");
        }
        for (String biome : this.biomes) {
            titleBuilder.append("in a ").append(biome.split(":")[1].replace("_", " ")).append(" biome ");
        }
        if (this.timeMin != 0L || this.timeMax != 24000L) {
            titleBuilder.append("between the time ").append(this.timeMin).append(" and ").append(this.timeMax);
        }
        return class_2561.method_30163((String)titleBuilder.toString().trim());
    }

    @Environment(value=EnvType.CLIENT)
    public Icon getAltIcon() {
        if (this.pokemons.isEmpty()) {
            return this.pokeBallIcon;
        }
        return this.getPokemonIcon(new class_2960(this.pokemons.get(0)));
    }

    public Icon getIconFromIdentifier(class_2960 identifier) {
        class_1799 itemStack = ((class_1792)class_7923.field_41178.method_10223(identifier)).method_7854();
        if (itemStack.method_7960()) {
            return this.pokeBallIcon;
        }
        return ItemIcon.getItemIcon((class_1799)itemStack);
    }

    public Icon getPokemonIcon(class_2960 pokemon) {
        class_1792 pokemonModelItem = (class_1792)class_7923.field_41178.method_10223(new class_2960("cobblemon", "pokemon_model"));
        class_2487 nbt = new class_2487();
        nbt.method_10582("species", pokemon.toString());
        pokemonModelItem.method_7854().method_7980(nbt);
        class_1799 stack = new class_1799((class_1935)pokemonModelItem);
        stack.method_7980(nbt);
        return ItemIcon.getItemIcon((class_1799)stack);
    }

    public void CobblemonTaskIncrease(TeamData teamData, Pokemon pokemon, String executedAction, long progress, class_3222 player) {
        String[] obtainingMethods = new String[]{"catch", "evolve", "trade_for", "obtain", "revive_fossil"};
        if (CobblemonQuestsConfig.ignoredPokemon.contains(pokemon.getSpecies().toString().toLowerCase())) {
            return;
        }
        if (this.actions.contains(executedAction) || this.actions.contains("obtain") && Arrays.asList(obtainingMethods).contains(executedAction)) {
            boolean shouldAddProgress;
            if (!this.regions.isEmpty() && !this.regions.contains(pokemon.getSpecies().getLabels().toArray()[0].toString())) {
                return;
            }
            if (this.timeMin != 0L || this.timeMax != 24000L) {
                long timeOfDay = player.method_5770().method_8532() % 24000L;
                long actualMin = this.timeMin;
                long actualMax = this.timeMax;
                if (this.timeMin > this.timeMax) {
                    actualMax = this.timeMax + 24000L;
                    if (timeOfDay < this.timeMin) {
                        timeOfDay += 24000L;
                    }
                }
                if (timeOfDay < actualMin || timeOfDay >= actualMax) {
                    return;
                }
            }
            if (!this.pokeBallsUsed.isEmpty() && !this.pokeBallsUsed.contains(pokemon.getCaughtBall().getName().toString())) {
                return;
            }
            if (!this.dimensions.isEmpty() && !this.dimensions.contains(player.method_5770().method_27983().method_29177().toString())) {
                return;
            }
            if (!this.biomes.isEmpty() && !this.biomes.contains(((class_5321)player.method_5770().method_23753(player.method_24515()).method_40230().get()).method_29177().toString())) {
                return;
            }
            if (!this.genders.isEmpty() && !this.genders.contains(pokemon.getGender().toString().toLowerCase())) {
                return;
            }
            if (!this.forms.isEmpty() && !this.forms.contains(pokemon.getForm().getName().toLowerCase())) {
                return;
            }
            if (!this.pokemonTypes.isEmpty()) {
                ArrayList types = new ArrayList();
                pokemon.getTypes().iterator().forEachRemaining(type -> {
                    String typeName = type.getName().toLowerCase();
                    if (this.pokemonTypes.contains(typeName)) {
                        types.add(typeName);
                    }
                });
                if (types.isEmpty()) {
                    return;
                }
            }
            if (!pokemon.getShiny() && this.shiny) {
                return;
            }
            boolean bl = shouldAddProgress = this.pokemons.stream().anyMatch(p -> p.split(":").length > 1 && p.split(":")[1].equals(pokemon.getSpecies().toString())) || this.pokemons.isEmpty();
            if (shouldAddProgress) {
                if (executedAction.equals("level_up_to")) {
                    if (teamData.getProgress((Task)this) < progress) {
                        teamData.setProgress((Task)this, progress);
                    }
                    return;
                }
                teamData.addProgress((Task)this, progress);
            }
        }
    }
}

