/*
 * Decompiled with CFR 0.152.
 */
package com.turtlehoarder.cobblemonchallenge.gui;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.storage.party.PartyStore;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.item.PokemonItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.turtlehoarder.cobblemonchallenge.battle.ChallengeFormat;
import com.turtlehoarder.cobblemonchallenge.command.ChallengeCommand;
import com.turtlehoarder.cobblemonchallenge.gui.LeadPokemonMenu;
import com.turtlehoarder.cobblemonchallenge.gui.LeadPokemonSelectionSession;
import com.turtlehoarder.cobblemonchallenge.util.ChallengeUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LeadPokemonMenuProvider
implements class_3908 {
    private final class_3222 selector;
    private final class_3222 rival;
    private PartyStore p1Party;
    private Pokemon selectedPokemon;
    private int rivalSelectedPokemon = 0;
    private final LeadPokemonSelectionSession selectionSession;
    private boolean guiModifierFlag = false;
    private MenuState menuState = MenuState.WAITING_FOR_BOTH;
    private LeadPokemonMenu openedMenu;
    public List<Integer> selectedSlots = new ArrayList<Integer>();
    private ChallengeCommand.ChallengeRequest request;

    public LeadPokemonMenuProvider(LeadPokemonSelectionSession wrapper, class_3222 selector, class_3222 rivalPlayer, ChallengeCommand.ChallengeRequest request) {
        this.selector = selector;
        this.rival = rivalPlayer;
        this.selectionSession = wrapper;
        this.request = request;
    }

    @NotNull
    public class_2561 method_5476() {
        return class_2561.method_43470((String)"Select your Lead Pokemon");
    }

    @Nullable
    public class_1703 createMenu(int pContainerId, class_1661 pPlayerInventory, class_1657 pPlayer) {
        LeadPokemonMenu leadPokemonMenu = new LeadPokemonMenu(this, pContainerId, pPlayerInventory);
        this.setupPokemonRepresentation(leadPokemonMenu);
        this.openedMenu = leadPokemonMenu;
        return leadPokemonMenu;
    }

    private void setupPokemonRepresentation(LeadPokemonMenu leadPokemonMenu) {
        Pokemon pokemon;
        int itemSlot;
        int x;
        this.p1Party = Cobblemon.INSTANCE.getStorage().getParty(this.selector);
        PlayerPartyStore p2Party = Cobblemon.INSTANCE.getStorage().getParty(this.rival);
        this.setupGlassFiller(leadPokemonMenu);
        for (x = 0; x < this.p1Party.size(); ++x) {
            itemSlot = x * 9;
            pokemon = this.p1Party.get(x);
            if (pokemon == null) continue;
            BattlePokemon copy = BattlePokemon.Companion.safeCopyOf(pokemon);
            pokemon = ChallengeUtil.applyFormatTransformations(ChallengeFormat.STANDARD_6V6, copy, this.request.level()).getEffectedPokemon();
            class_1799 pokemonItem = PokemonItem.from((Pokemon)pokemon, (int)1);
            pokemonItem.method_7977((class_2561)class_2561.method_43470((String)(class_124.field_1075 + String.format("%s (lvl%d)", pokemon.getDisplayName().getString(), this.request.level()))));
            class_2499 pokemonLoreTag = ChallengeUtil.generateLoreTagForPokemon(pokemon);
            pokemonItem.method_7911("display").method_10566("Lore", (class_2520)pokemonLoreTag);
            leadPokemonMenu.method_7619(itemSlot, leadPokemonMenu.method_37421(), pokemonItem);
        }
        for (x = 0; x < p2Party.size(); ++x) {
            class_1799 pokemonItem;
            itemSlot = x * 9 + 8;
            pokemon = p2Party.get(x);
            if (pokemon == null) continue;
            if (this.selectionSession.teamPreviewOn()) {
                pokemonItem = PokemonItem.from((Pokemon)pokemon, (int)1);
                pokemonItem.method_7977((class_2561)class_2561.method_43470((String)(class_124.field_1061 + String.format("%s's %s (lvl%d)", this.rival.method_5476().getString(), pokemon.getDisplayName().getString(), this.request.level()))));
                leadPokemonMenu.method_7619(itemSlot, leadPokemonMenu.method_37421(), pokemonItem);
                continue;
            }
            pokemonItem = new class_1799((class_1935)CobblemonItems.POKE_BALL.method_8389());
            pokemonItem.method_30268(class_1799.class_5422.field_25773);
            pokemonItem.method_7977((class_2561)class_2561.method_43470((String)(class_124.field_1061 + String.format("%s's Pokemon", this.rival.method_5476().getString()))));
            leadPokemonMenu.method_7619(itemSlot, leadPokemonMenu.method_37421(), pokemonItem);
        }
    }

    private void setGlassDisplayName(class_1799 s, int secondsLeft) {
        s.method_7977((class_2561)class_2561.method_43470((String)(class_124.field_1075 + String.format("Seconds left to choose: %d", secondsLeft))));
        class_2499 glassLoreTag = this.generateLoreTagForGlass(s);
        s.method_7911("display").method_10566("Lore", (class_2520)glassLoreTag);
    }

    private class_2499 generateLoreTagForGlass(class_1799 s) {
        class_2499 loreTag = new class_2499();
        class_5250 additionalInformation = this.menuState == MenuState.WAITING_FOR_RIVAL ? class_2561.method_43470((String)(class_124.field_1068 + String.format("Waiting on %s...", this.rival.method_5476().getString()))) : (this.menuState == MenuState.WAITING_FOR_PLAYER ? class_2561.method_43470((String)(class_124.field_1068 + "Waiting on you to select Lead...")) : class_2561.method_43470((String)(class_124.field_1068 + "Waiting on both players to select leads...")));
        loreTag.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)additionalInformation)));
        return loreTag;
    }

    private void setupGlassFiller(LeadPokemonMenu leadPokemonMenu) {
        int timeLeft = (int)Math.ceil((float)(this.selectionSession.creationTime + (long)LeadPokemonSelectionSession.LEAD_TIMEOUT_MILLIS - System.currentTimeMillis()) / 1000.0f);
        for (int column = 1; column <= 7; ++column) {
            for (int row = 0; row < 6; ++row) {
                int itemSlot = row * 9 + column;
                class_1799 itemFiller = column == 1 ? ((row + (this.guiModifierFlag ? 0 : 1)) % 2 == 0 || this.menuState == MenuState.WAITING_FOR_RIVAL ? new class_1799((class_1935)class_1802.field_8581) : new class_1799((class_1935)class_1802.field_8656)) : (column == 7 ? ((row + (this.guiModifierFlag ? 0 : 1)) % 2 == 0 || this.menuState == MenuState.WAITING_FOR_PLAYER ? new class_1799((class_1935)class_1802.field_8500) : new class_1799((class_1935)class_1802.field_8879)) : new class_1799((class_1935)class_1802.field_8871));
                this.setGlassDisplayName(itemFiller, timeLeft);
                if (this.selectedPokemon != null) {
                    if (itemSlot == 12 || itemSlot == 30 || itemSlot == 20) {
                        itemFiller = new class_1799(ChallengeUtil.getDisplayBlockForPokemon(this.selectedPokemon));
                        this.setGlassDisplayName(itemFiller, timeLeft);
                    } else if (itemSlot == 21) {
                        itemFiller = PokemonItem.from((Pokemon)this.selectedPokemon, (int)1);
                        itemFiller.method_7977((class_2561)class_2561.method_43470((String)(class_124.field_1060 + String.format("You've selected %s as your lead", this.selectedPokemon.getDisplayName().getString()))));
                    }
                }
                if (this.rivalSelectedPokemon == this.selectionSession.getMaxPokemonSelection()) {
                    if (itemSlot == 23 || itemSlot == 13 || itemSlot == 31) {
                        itemFiller = new class_1799((class_1935)class_2246.field_10285);
                        this.setGlassDisplayName(itemFiller, timeLeft);
                    }
                    if (itemSlot == 22) {
                        itemFiller = new class_1799((class_1935)CobblemonItems.POKE_BALL.method_8389());
                        itemFiller.method_30268(class_1799.class_5422.field_25773);
                        itemFiller.method_7977((class_2561)class_2561.method_43470((String)(class_124.field_1061 + String.format("%s has selected their lead", this.rival.method_5476().getString()))));
                    }
                }
                leadPokemonMenu.method_7619(itemSlot, leadPokemonMenu.method_37421(), itemFiller);
            }
        }
    }

    protected void onSelectPokemonSlot(LeadPokemonMenu menu, int slotId) {
        Pokemon selectedPokemon;
        if (this.selectedSlots.size() < this.selectionSession.getMaxPokemonSelection() && (selectedPokemon = this.p1Party.get(slotId)) != null) {
            this.selectedPokemon = selectedPokemon;
            this.selectedSlots.add(slotId);
            this.setupGlassFiller(menu);
            this.selectionSession.onPokemonSelected(this);
            this.updateMenuState();
        }
    }

    public void timedGuiUpdate() {
        this.guiModifierFlag = !this.guiModifierFlag;
        this.setupGlassFiller(this.openedMenu);
    }

    public void forceCloseMenu() {
        if (this.openedMenu != null) {
            this.openedMenu.invalidateMenu();
        }
    }

    protected void onPlayerCloseContainer() {
        this.selectionSession.onPlayerCloseMenu(this.selector);
    }

    private void updateMenuState() {
        this.menuState = this.rivalSelectedPokemon == this.selectionSession.getMaxPokemonSelection() && this.selectedSlots.size() < this.selectionSession.getMaxPokemonSelection() ? MenuState.WAITING_FOR_PLAYER : (this.selectedSlots.size() == this.selectionSession.getMaxPokemonSelection() && this.rivalSelectedPokemon < this.selectionSession.getMaxPokemonSelection() ? MenuState.WAITING_FOR_RIVAL : MenuState.WAITING_FOR_BOTH);
    }

    public void updateRivalCount(int newCount) {
        this.rivalSelectedPokemon = newCount;
        this.updateMenuState();
    }

    private static enum MenuState {
        WAITING_FOR_BOTH,
        WAITING_FOR_RIVAL,
        WAITING_FOR_PLAYER;

    }
}

