/*
 * Decompiled with CFR 0.152.
 */
package com.turtlehoarder.cobblemonchallenge.gui;

import com.cobblemon.mod.common.battles.BattleFormat;
import com.turtlehoarder.cobblemonchallenge.CobblemonChallenge;
import com.turtlehoarder.cobblemonchallenge.battle.ChallengeBattleBuilder;
import com.turtlehoarder.cobblemonchallenge.battle.ChallengeBuilderException;
import com.turtlehoarder.cobblemonchallenge.command.ChallengeCommand;
import com.turtlehoarder.cobblemonchallenge.gui.LeadPokemonMenuProvider;
import com.turtlehoarder.cobblemonchallenge.util.ChallengeUtil;
import java.util.UUID;
import java.util.Vector;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;

public class LeadPokemonSelectionSession {
    private final LeadPokemonMenuProvider challengerMenuProvider;
    private final LeadPokemonMenuProvider challengedMenuProvider;
    private final ChallengeCommand.ChallengeRequest originRequest;
    private final UUID uuid;
    public long creationTime;
    private int pokemonToSelect = 1;
    private boolean timedOut = false;
    private boolean closedOut = false;
    public static Vector<LeadPokemonSelectionSession> SESSIONS_TO_CANCEL = new Vector();
    public static int LEAD_TIMEOUT_MILLIS = 90000;

    public LeadPokemonSelectionSession(UUID uuid, long creationTime, ChallengeCommand.ChallengeRequest request) {
        this.originRequest = request;
        this.uuid = uuid;
        this.creationTime = creationTime;
        this.challengerMenuProvider = new LeadPokemonMenuProvider(this, request.challengerPlayer(), request.challengedPlayer(), request);
        this.challengedMenuProvider = new LeadPokemonMenuProvider(this, request.challengedPlayer(), request.challengerPlayer(), request);
    }

    public void openPlayerMenus() {
        this.originRequest.challengedPlayer().method_17355((class_3908)this.challengedMenuProvider);
        this.originRequest.challengerPlayer().method_17355((class_3908)this.challengerMenuProvider);
    }

    private class_3222 getOtherPlayer(class_3222 player) {
        if (player == this.originRequest.challengerPlayer()) {
            return this.originRequest.challengedPlayer();
        }
        return this.originRequest.challengerPlayer();
    }

    public void onPokemonSelected(LeadPokemonMenuProvider menuProvider) {
        if (this.isBattleReady()) {
            CobblemonChallenge.LOGGER.info("All pokemon selected, initiating battle sequence");
            this.beginBattle();
        } else {
            this.getOtherMenu(menuProvider).updateRivalCount(menuProvider.selectedSlots.size());
        }
    }

    private void beginBattle() {
        int level = this.originRequest.level();
        SESSIONS_TO_CANCEL.add(this);
        this.challengerMenuProvider.forceCloseMenu();
        this.challengedMenuProvider.forceCloseMenu();
        ChallengeBattleBuilder challengeBuilder = new ChallengeBattleBuilder();
        try {
            challengeBuilder.lvlxpvp(this.originRequest.challengerPlayer(), this.originRequest.challengedPlayer(), BattleFormat.Companion.getGEN_9_SINGLES(), level, this.challengerMenuProvider.selectedSlots, this.challengedMenuProvider.selectedSlots);
        }
        catch (ChallengeBuilderException e) {
            e.printStackTrace();
        }
    }

    public boolean teamPreviewOn() {
        return this.originRequest.preview();
    }

    private boolean isBattleReady() {
        return this.challengedMenuProvider.selectedSlots.size() == this.getMaxPokemonSelection() && this.challengerMenuProvider.selectedSlots.size() == this.getMaxPokemonSelection();
    }

    public int getMaxPokemonSelection() {
        return this.pokemonToSelect;
    }

    private LeadPokemonMenuProvider getOtherMenu(LeadPokemonMenuProvider menu) {
        if (menu == this.challengedMenuProvider) {
            return this.challengerMenuProvider;
        }
        return this.challengedMenuProvider;
    }

    public void timeoutRequest() {
        this.timedOut = true;
        if (ChallengeUtil.isPlayerOnline(this.originRequest.challengerPlayer())) {
            this.originRequest.challengerPlayer().method_43496((class_2561)class_2561.method_43470((String)(class_124.field_1061 + "Challenge timed out: Selecting lead took too long")));
        }
        if (ChallengeUtil.isPlayerOnline(this.originRequest.challengedPlayer())) {
            this.originRequest.challengedPlayer().method_43496((class_2561)class_2561.method_43470((String)(class_124.field_1061 + "Challenge timed out: Selecting lead took too long")));
        }
        this.challengedMenuProvider.forceCloseMenu();
        this.challengerMenuProvider.forceCloseMenu();
    }

    public void onPlayerCloseMenu(class_3222 player) {
        if (!(this.timedOut || this.isBattleReady() || this.closedOut)) {
            this.closedOut = true;
            class_3222 otherPlayer = this.getOtherPlayer(player);
            player.method_43496((class_2561)class_2561.method_43470((String)(class_124.field_1061 + String.format(String.format("You have cancelled the challenge to %s", otherPlayer.method_5476().getString()), new Object[0]))));
            otherPlayer.method_43496((class_2561)class_2561.method_43470((String)(class_124.field_1061 + String.format("%s has cancelled the request", player.method_5476().getString()))));
            this.challengerMenuProvider.forceCloseMenu();
            this.challengedMenuProvider.forceCloseMenu();
            SESSIONS_TO_CANCEL.add(this);
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void doTick() {
        this.challengedMenuProvider.timedGuiUpdate();
        this.challengerMenuProvider.timedGuiUpdate();
    }
}

