/*
 * Decompiled with CFR 0.152.
 */
package dev.zanckor.cobblemonridingfabric.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PokemonJsonObject {
    Boolean mustAllowEntityRiding = false;
    Map<String, PokemonConfigData> pokemonTypes = new HashMap<String, PokemonConfigData>();

    public void add(String pokemonType, PokemonConfigData pokemonConfigData) {
        this.pokemonTypes.put(pokemonType, pokemonConfigData);
    }

    public boolean mustAllowEntityRiding() {
        return this.mustAllowEntityRiding == null ? false : this.mustAllowEntityRiding;
    }

    public Set<String> getPokemonIDs() {
        return this.pokemonTypes.keySet();
    }

    public PokemonConfigData getPokemonData(String pokemonType) {
        return this.pokemonTypes.get(pokemonType);
    }

    public static class PokemonConfigData {
        String formName;
        int stamina;
        ArrayList<MountType> mountType;
        ArrayList<Float> ridingOffSet;
        ArrayList<ArrayList<Float>> passengersOffSet;
        float speedModifier = 1.0f;

        public PokemonConfigData(ArrayList<MountType> mountType, ArrayList<Float> offSet, ArrayList<ArrayList<Float>> passengersOffset) {
            this.mountType = mountType;
            this.ridingOffSet = offSet;
            this.passengersOffSet = passengersOffset;
        }

        public PokemonConfigData(ArrayList<MountType> mountType, ArrayList<Float> offSet) {
            this.mountType = mountType;
            this.ridingOffSet = offSet;
            this.passengersOffSet = new ArrayList();
            this.passengersOffSet.add(new ArrayList<Float>(List.of(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f))));
        }

        public PokemonConfigData(ArrayList<MountType> mountType) {
            this.mountType = mountType;
            this.ridingOffSet = new ArrayList<Float>(List.of(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)));
            this.passengersOffSet = new ArrayList();
        }

        public PokemonConfigData() {
            this.mountType = new ArrayList<MountType>(List.of(MountType.WALK));
            this.ridingOffSet = new ArrayList<Float>(List.of(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)));
            this.passengersOffSet = new ArrayList();
        }

        public int getMaxStamina() {
            return this.stamina != 0 ? this.stamina : 200;
        }

        public String getFormName() {
            return this.formName == null ? "none" : this.formName;
        }

        public ArrayList<MountType> getMountTypes() {
            return this.mountType;
        }

        public ArrayList<Float> getRidingOffSet() {
            return this.ridingOffSet;
        }

        public float getSpeedModifier() {
            return this.speedModifier;
        }

        public ArrayList<Float> getPassengerOffSet(int passenger) {
            return passenger >= 0 && passenger < this.passengersOffSet.size() ? this.passengersOffSet.get(passenger) : null;
        }

        public ArrayList<ArrayList<Float>> getPassengersOffSet() {
            return this.passengersOffSet;
        }
    }

    public static enum MountType {
        WALK,
        SWIM,
        LAVA_SWIM,
        FLY;

    }
}

