/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage;

import com.witchica.compactstorage.common.item.StorageUpgradeItem;
import com.witchica.compactstorage.common.screen.CompactChestScreenHandler;
import com.witchica.compactstorage.common.util.CompactStorageUtil;
import com.witchica.compactstorage.fabric.block.FabricCompactBarrelBlock;
import com.witchica.compactstorage.fabric.block.FabricCompactChestBlock;
import com.witchica.compactstorage.fabric.block.FabricDrumBlock;
import com.witchica.compactstorage.fabric.block.entity.FabricCompactBarrelBlockEntity;
import com.witchica.compactstorage.fabric.block.entity.FabricCompactChestBlockEntity;
import com.witchica.compactstorage.fabric.block.entity.FabricDrumBlockEntity;
import com.witchica.compactstorage.fabric.item.FabricBackpackItem;
import com.witchica.compactstorage.util.RegistryHolder;
import java.util.Arrays;
import java.util.HashMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.minecraft.class_156;
import net.minecraft.class_1761;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactStorage
implements ModInitializer {
    public static final String MOD_ID = "compact_storage";
    public static final String MOD_NAME = "CompactStorage";
    public static final Logger LOGGER;
    public static class_2960 COMPACT_CHEST_GENERIC_IDENTIFIER;
    public static class_2960 COMPACT_BARREL_GENERIC_IDENTIFIER;
    public static class_2591<FabricCompactChestBlockEntity> COMPACT_CHEST_ENTITY_TYPE;
    public static class_2591<FabricCompactBarrelBlockEntity> COMPACT_BARREL_ENTITY_TYPE;
    public static final String COMPACT_CHEST_TRANSLATION_KEY;
    public static final ExtendedScreenHandlerType<CompactChestScreenHandler> COMPACT_CHEST_SCREEN_HANDLER;
    public static final RegistryHolder.Blocks[] COMPACT_CHEST_BLOCKS;
    public static final RegistryHolder.Blocks[] COMPACT_BARREL_BLOCKS;
    public static final RegistryHolder.Blocks[] DRUM_BLOCKS;
    public static final RegistryHolder.Items[] BACKPACK_ITEMS;
    public static RegistryHolder<class_2591<FabricDrumBlockEntity>> DRUM_BLOCK_ENTITY_TYPE;
    public static final HashMap<class_1767, RegistryHolder.Blocks> DYE_COLOR_TO_COMPACT_CHEST_MAP;
    public static final HashMap<class_1767, RegistryHolder.Blocks> DYE_COLOR_TO_COMPACT_BARREL_MAP;
    public static final RegistryHolder.Items UPGRADE_ROW_ITEM;
    public static final RegistryHolder.Items UPGRADE_COLUMN_ITEM;
    public static final HashMap<class_1767, RegistryHolder.Items> DYE_COLOR_TO_BACKPACK_MAP;
    public static final class_1761 COMPACT_STORAGE_ITEM_GROUP;

    public void onInitialize() {
        LOGGER.info("Welcome to Compact Storage!");
        for (int i = 0; i < 16; ++i) {
            COMPACT_CHEST_BLOCKS[i].registerBlockAndItem();
            COMPACT_BARREL_BLOCKS[i].registerBlockAndItem();
            BACKPACK_ITEMS[i].register((class_2378)class_7923.field_41178);
        }
        Arrays.stream(DRUM_BLOCKS).forEach(RegistryHolder.Blocks::registerBlockAndItem);
        class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)COMPACT_CHEST_GENERIC_IDENTIFIER, COMPACT_CHEST_SCREEN_HANDLER);
        COMPACT_CHEST_ENTITY_TYPE = (class_2591)class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)COMPACT_CHEST_GENERIC_IDENTIFIER, (Object)FabricBlockEntityTypeBuilder.create(FabricCompactChestBlockEntity::new, (class_2248[])((class_2248[])Arrays.stream(COMPACT_CHEST_BLOCKS).map(RegistryHolder::get).toArray(class_2248[]::new))).build(null));
        COMPACT_BARREL_ENTITY_TYPE = (class_2591)class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)COMPACT_BARREL_GENERIC_IDENTIFIER, (Object)FabricBlockEntityTypeBuilder.create(FabricCompactBarrelBlockEntity::new, (class_2248[])((class_2248[])Arrays.stream(COMPACT_BARREL_BLOCKS).map(RegistryHolder::get).toArray(class_2248[]::new))).build(null));
        DRUM_BLOCK_ENTITY_TYPE = new RegistryHolder<class_2591>("drum", FabricBlockEntityTypeBuilder.create(FabricDrumBlockEntity::new, (class_2248[])((class_2248[])Arrays.stream(DRUM_BLOCKS).map(RegistryHolder::get).toArray(class_2248[]::new))).build(null));
        DRUM_BLOCK_ENTITY_TYPE.register(class_7923.field_41181);
        UPGRADE_ROW_ITEM.register((class_2378)class_7923.field_41178);
        UPGRADE_COLUMN_ITEM.register((class_2378)class_7923.field_41178);
        class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)new class_2960(MOD_ID, "general"), (Object)COMPACT_STORAGE_ITEM_GROUP);
        ItemStorage.SIDED.registerForBlockEntity((blockEntity, direction) -> blockEntity.inventoryStorage, COMPACT_CHEST_ENTITY_TYPE);
        ItemStorage.SIDED.registerForBlockEntity((blockEntity, direction) -> blockEntity.inventoryStorage, COMPACT_BARREL_ENTITY_TYPE);
        ItemStorage.SIDED.registerForBlockEntity((blockEntity, direction) -> blockEntity.inventoryWrapper, DRUM_BLOCK_ENTITY_TYPE.get());
    }

    static {
        int i;
        LOGGER = LoggerFactory.getLogger((String)MOD_ID);
        COMPACT_CHEST_GENERIC_IDENTIFIER = new class_2960(MOD_ID, "compact_chest");
        COMPACT_BARREL_GENERIC_IDENTIFIER = new class_2960(MOD_ID, "compact_barrel");
        COMPACT_CHEST_TRANSLATION_KEY = class_156.method_646((String)"container", (class_2960)COMPACT_CHEST_GENERIC_IDENTIFIER);
        COMPACT_CHEST_SCREEN_HANDLER = new ExtendedScreenHandlerType(CompactChestScreenHandler::new);
        COMPACT_CHEST_BLOCKS = new RegistryHolder.Blocks[16];
        COMPACT_BARREL_BLOCKS = new RegistryHolder.Blocks[16];
        DRUM_BLOCKS = new RegistryHolder.Blocks[CompactStorageUtil.DRUM_TYPES.length];
        BACKPACK_ITEMS = new RegistryHolder.Items[16];
        DYE_COLOR_TO_COMPACT_CHEST_MAP = new HashMap();
        DYE_COLOR_TO_COMPACT_BARREL_MAP = new HashMap();
        UPGRADE_ROW_ITEM = new RegistryHolder.Items("upgrade_row", (class_1792)new StorageUpgradeItem((class_1792.class_1793)new FabricItemSettings()));
        UPGRADE_COLUMN_ITEM = new RegistryHolder.Items("upgrade_column", (class_1792)new StorageUpgradeItem((class_1792.class_1793)new FabricItemSettings()));
        DYE_COLOR_TO_BACKPACK_MAP = new HashMap();
        for (i = 0; i < 16; ++i) {
            String dyeName = class_1767.method_7791((int)i).method_7792().toLowerCase();
            CompactStorage.COMPACT_CHEST_BLOCKS[i] = new RegistryHolder.Blocks("compact_chest_" + dyeName, (class_2248)new FabricCompactChestBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10034).method_22488().method_9629(2.0f, 5.0f)));
            DYE_COLOR_TO_COMPACT_CHEST_MAP.put(class_1767.method_7791((int)i), COMPACT_CHEST_BLOCKS[i]);
            CompactStorage.BACKPACK_ITEMS[i] = new RegistryHolder.Items("backpack_" + dyeName, (class_1792)new FabricBackpackItem(new FabricItemSettings().method_7889(1)));
            DYE_COLOR_TO_BACKPACK_MAP.put(class_1767.method_7791((int)i), BACKPACK_ITEMS[i]);
            CompactStorage.COMPACT_BARREL_BLOCKS[i] = new RegistryHolder.Blocks("compact_barrel_" + dyeName, (class_2248)new FabricCompactBarrelBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_16328).method_9629(2.0f, 5.0f)));
            DYE_COLOR_TO_COMPACT_BARREL_MAP.put(class_1767.method_7791((int)i), COMPACT_BARREL_BLOCKS[i]);
        }
        for (i = 0; i < CompactStorageUtil.DRUM_TYPES.length; ++i) {
            CompactStorage.DRUM_BLOCKS[i] = new RegistryHolder.Blocks(CompactStorageUtil.DRUM_TYPES[i] + "_drum", (class_2248)new FabricDrumBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_16328)));
        }
        COMPACT_STORAGE_ITEM_GROUP = FabricItemGroup.builder().method_47321((class_2561)class_2561.method_43471((String)"itemGroup.compact_storage.general")).method_47320(() -> new class_1799((class_1935)COMPACT_CHEST_BLOCKS[0].get(), 1)).method_47317((displayContext, entries) -> {
            entries.method_45423(Arrays.stream(COMPACT_CHEST_BLOCKS).map(block -> new class_1799((class_1935)block.get(), 1)).toList());
            entries.method_45423(Arrays.stream(COMPACT_BARREL_BLOCKS).map(block -> new class_1799((class_1935)block.get(), 1)).toList());
            entries.method_45423(Arrays.stream(DRUM_BLOCKS).map(block -> new class_1799((class_1935)block.get(), 1)).toList());
            entries.method_45423(Arrays.stream(BACKPACK_ITEMS).map(block -> new class_1799((class_1935)block.get(), 1)).toList());
            entries.method_45421((class_1935)UPGRADE_COLUMN_ITEM.get());
            entries.method_45421((class_1935)UPGRADE_ROW_ITEM.get());
        }).method_47324();
    }
}

