/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor.overlay;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.ProcessingDataProvider;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.client.processor.AbstractQuadProcessor;
import me.pepperbell.continuity.client.processor.AbstractQuadProcessorFactory;
import me.pepperbell.continuity.client.processor.ConnectionPredicate;
import me.pepperbell.continuity.client.processor.DirectionMaps;
import me.pepperbell.continuity.client.processor.ProcessingDataKeys;
import me.pepperbell.continuity.client.processor.ProcessingPredicate;
import me.pepperbell.continuity.client.processor.overlay.OverlayProcessingPredicate;
import me.pepperbell.continuity.client.properties.overlay.OverlayPropertiesSection;
import me.pepperbell.continuity.client.properties.overlay.StandardOverlayCtmProperties;
import me.pepperbell.continuity.client.util.QuadUtil;
import me.pepperbell.continuity.client.util.RenderUtil;
import me.pepperbell.continuity.client.util.SpriteCalculator;
import me.pepperbell.continuity.client.util.TextureUtil;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class StandardOverlayQuadProcessor
extends AbstractQuadProcessor {
    @Nullable
    protected Set<class_2960> matchTilesSet;
    @Nullable
    protected Predicate<class_2680> matchBlocksPredicate;
    @Nullable
    protected Set<class_2960> connectTilesSet;
    @Nullable
    protected Predicate<class_2680> connectBlocksPredicate;
    protected ConnectionPredicate connectionPredicate;
    protected int tintIndex;
    @Nullable
    protected class_2680 tintBlock;
    protected RenderMaterial material;

    public StandardOverlayQuadProcessor(class_1058[] sprites, ProcessingPredicate processingPredicate, @Nullable Set<class_2960> matchTilesSet, @Nullable Predicate<class_2680> matchBlocksPredicate, @Nullable Set<class_2960> connectTilesSet, @Nullable Predicate<class_2680> connectBlocksPredicate, ConnectionPredicate connectionPredicate, int tintIndex, @Nullable class_2680 tintBlock, BlendMode layer) {
        super(sprites, processingPredicate);
        this.matchTilesSet = matchTilesSet;
        this.matchBlocksPredicate = matchBlocksPredicate;
        this.connectTilesSet = connectTilesSet;
        this.connectBlocksPredicate = connectBlocksPredicate;
        this.connectionPredicate = connectionPredicate;
        this.tintIndex = tintIndex;
        this.tintBlock = tintBlock;
        this.material = RenderUtil.findOverlayMaterial(layer, this.tintBlock);
    }

    @Override
    public QuadProcessor.ProcessingResult processQuadInner(MutableQuadView quad, class_1058 sprite, class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, int pass, QuadProcessor.ProcessingContext context) {
        class_2350 lightFace = quad.lightFace();
        OverlayEmitter emitter = this.getEmitter(blockView, pos, state, lightFace, sprite, DirectionMaps.getMap(lightFace)[0], context);
        if (emitter != null) {
            context.addEmitterConsumer(emitter);
        }
        return QuadProcessor.ProcessingResult.NEXT_PROCESSOR;
    }

    protected boolean appliesOverlay(class_2680 other, class_1920 blockView, class_2680 state, class_2338 pos, class_2350 face, class_1058 quadSprite) {
        if (other.method_26204().method_9543()) {
            return false;
        }
        if (!other.method_26234((class_1922)class_2682.field_12294, class_2338.field_10980)) {
            return false;
        }
        if (this.connectBlocksPredicate != null && !this.connectBlocksPredicate.test(other)) {
            return false;
        }
        if (this.connectTilesSet != null && !this.connectTilesSet.contains(SpriteCalculator.getSprite(other, face).method_45851().method_45816())) {
            return false;
        }
        return !this.connectionPredicate.shouldConnect(blockView, state, pos, other, face, quadSprite);
    }

    protected boolean hasSameOverlay(class_2680 other, class_1920 blockView, class_2680 state, class_2338 pos, class_2350 face, class_1058 quadSprite) {
        if (this.matchBlocksPredicate != null && !this.matchBlocksPredicate.test(other)) {
            return false;
        }
        return this.matchTilesSet == null || this.matchTilesSet.contains(SpriteCalculator.getSprite(other, face).method_45851().method_45816());
    }

    protected boolean appliesOverlayUnobscured(class_2680 state0, class_2350 direction0, class_1920 blockView, class_2338 pos, class_2680 state, class_2350 lightFace, class_1058 quadSprite, class_2338.class_2339 mutablePos) {
        boolean a0 = this.appliesOverlay(state0, blockView, state, pos, lightFace, quadSprite);
        if (a0) {
            mutablePos.method_25505((class_2382)pos, direction0).method_10098(lightFace);
            a0 = !blockView.method_8320((class_2338)mutablePos).method_26216((class_1922)blockView, (class_2338)mutablePos);
        }
        return a0;
    }

    protected boolean hasSameOverlayUnobscured(class_2680 state0, class_2350 direction0, class_1920 blockView, class_2338 pos, class_2680 state, class_2350 lightFace, class_1058 quadSprite, class_2338.class_2339 mutablePos) {
        boolean s0 = this.hasSameOverlay(state0, blockView, state, pos, lightFace, quadSprite);
        if (s0) {
            mutablePos.method_25505((class_2382)pos, direction0).method_10098(lightFace);
            s0 = !blockView.method_8320((class_2338)mutablePos).method_26216((class_1922)blockView, (class_2338)mutablePos);
        }
        return s0;
    }

    protected boolean appliesOverlayCorner(class_2350 direction0, class_2350 direction1, class_1920 blockView, class_2338 pos, class_2680 state, class_2350 lightFace, class_1058 quadSprite, class_2338.class_2339 mutablePos) {
        mutablePos.method_25505((class_2382)pos, direction0).method_10098(direction1);
        boolean corner0 = this.appliesOverlay(blockView.method_8320((class_2338)mutablePos), blockView, state, pos, lightFace, quadSprite);
        if (corner0) {
            mutablePos.method_10098(lightFace);
            corner0 = !blockView.method_8320((class_2338)mutablePos).method_26216((class_1922)blockView, (class_2338)mutablePos);
        }
        return corner0;
    }

    protected OverlayEmitter fromCorner(class_2350 direction0, class_2350 direction1, int sprite0, int sprite1, OverlayEmitter emitter, class_1920 blockView, class_2338 pos, class_2680 state, class_2350 lightFace, class_1058 quadSprite, class_2338.class_2339 mutablePos) {
        this.prepareEmitter(emitter, lightFace, blockView, pos);
        emitter.addSprite(this.sprites[sprite0]);
        mutablePos.method_25505((class_2382)pos, direction0).method_10098(direction1);
        if (this.appliesOverlay(blockView.method_8320((class_2338)mutablePos), blockView, state, pos, lightFace, quadSprite)) {
            mutablePos.method_10098(lightFace);
            if (!blockView.method_8320((class_2338)mutablePos).method_26216((class_1922)blockView, (class_2338)mutablePos)) {
                emitter.addSprite(this.sprites[sprite1]);
            }
        }
        return emitter;
    }

    protected OverlayEmitter fromOneSide(class_2680 state0, class_2680 state1, class_2680 state2, class_2350 direction0, class_2350 direction1, class_2350 direction2, int sprite0, int sprite1, int sprite2, OverlayEmitter emitter, class_1920 blockView, class_2338 pos, class_2680 state, class_2350 lightFace, class_1058 quadSprite, class_2338.class_2339 mutablePos) {
        boolean s0 = this.hasSameOverlayUnobscured(state0, direction0, blockView, pos, state, lightFace, quadSprite, mutablePos);
        boolean s1 = this.hasSameOverlayUnobscured(state1, direction1, blockView, pos, state, lightFace, quadSprite, mutablePos);
        boolean s2 = this.hasSameOverlayUnobscured(state2, direction2, blockView, pos, state, lightFace, quadSprite, mutablePos);
        this.prepareEmitter(emitter, lightFace, blockView, pos);
        emitter.addSprite(this.sprites[sprite0]);
        if (s0 | s1 && this.appliesOverlayCorner(direction0, direction1, blockView, pos, state, lightFace, quadSprite, mutablePos)) {
            emitter.addSprite(this.sprites[sprite1]);
        }
        if (s1 | s2 && this.appliesOverlayCorner(direction1, direction2, blockView, pos, state, lightFace, quadSprite, mutablePos)) {
            emitter.addSprite(this.sprites[sprite2]);
        }
        return emitter;
    }

    protected static OverlayEmitter getEmitter(ProcessingDataProvider dataProvider) {
        return dataProvider.getData(ProcessingDataKeys.STANDARD_OVERLAY_EMITTER_POOL_KEY).get();
    }

    protected void prepareEmitter(OverlayEmitter emitter, class_2350 face, class_1920 blockView, class_2338 pos) {
        emitter.prepare(face, RenderUtil.getTintColor(this.tintBlock, blockView, pos, this.tintIndex), this.material);
    }

    protected OverlayEmitter prepareEmitter(OverlayEmitter emitter, class_2350 face, class_1920 blockView, class_2338 pos, int sprite1) {
        this.prepareEmitter(emitter, face, blockView, pos);
        emitter.addSprite(this.sprites[sprite1]);
        return emitter;
    }

    protected OverlayEmitter prepareEmitter(OverlayEmitter emitter, class_2350 face, class_1920 blockView, class_2338 pos, int sprite1, int sprite2) {
        this.prepareEmitter(emitter, face, blockView, pos);
        emitter.addSprite(this.sprites[sprite1]);
        emitter.addSprite(this.sprites[sprite2]);
        return emitter;
    }

    @Nullable
    protected OverlayEmitter getEmitter(class_1920 blockView, class_2338 pos, class_2680 state, class_2350 lightFace, class_1058 quadSprite, class_2350[] directions, ProcessingDataProvider dataProvider) {
        class_2338.class_2339 mutablePos = dataProvider.getData(ProcessingDataKeys.MUTABLE_POS_KEY);
        mutablePos.method_25505((class_2382)pos, directions[0]);
        class_2680 state0 = blockView.method_8320((class_2338)mutablePos);
        boolean left = this.appliesOverlayUnobscured(state0, directions[0], blockView, pos, state, lightFace, quadSprite, mutablePos);
        mutablePos.method_25505((class_2382)pos, directions[1]);
        class_2680 state1 = blockView.method_8320((class_2338)mutablePos);
        boolean down = this.appliesOverlayUnobscured(state1, directions[1], blockView, pos, state, lightFace, quadSprite, mutablePos);
        mutablePos.method_25505((class_2382)pos, directions[2]);
        class_2680 state2 = blockView.method_8320((class_2338)mutablePos);
        boolean right = this.appliesOverlayUnobscured(state2, directions[2], blockView, pos, state, lightFace, quadSprite, mutablePos);
        mutablePos.method_25505((class_2382)pos, directions[3]);
        class_2680 state3 = blockView.method_8320((class_2338)mutablePos);
        boolean up = this.appliesOverlayUnobscured(state3, directions[3], blockView, pos, state, lightFace, quadSprite, mutablePos);
        if (left & down & right & up) {
            return this.prepareEmitter(StandardOverlayQuadProcessor.getEmitter(dataProvider), lightFace, blockView, pos, 8);
        }
        if (left & down & right) {
            return this.prepareEmitter(StandardOverlayQuadProcessor.getEmitter(dataProvider), lightFace, blockView, pos, 5);
        }
        if (left & down & up) {
            return this.prepareEmitter(StandardOverlayQuadProcessor.getEmitter(dataProvider), lightFace, blockView, pos, 6);
        }
        if (left & right & up) {
            return this.prepareEmitter(StandardOverlayQuadProcessor.getEmitter(dataProvider), lightFace, blockView, pos, 13);
        }
        if (down & right & up) {
            return this.prepareEmitter(StandardOverlayQuadProcessor.getEmitter(dataProvider), lightFace, blockView, pos, 12);
        }
        if (left & right) {
            return this.prepareEmitter(StandardOverlayQuadProcessor.getEmitter(dataProvider), lightFace, blockView, pos, 9, 7);
        }
        if (up & down) {
            return this.prepareEmitter(StandardOverlayQuadProcessor.getEmitter(dataProvider), lightFace, blockView, pos, 15, 1);
        }
        if (left & down) {
            return this.fromCorner(directions[2], directions[3], 4, 14, StandardOverlayQuadProcessor.getEmitter(dataProvider), blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (down & right) {
            return this.fromCorner(directions[0], directions[3], 3, 16, StandardOverlayQuadProcessor.getEmitter(dataProvider), blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (right & up) {
            return this.fromCorner(directions[0], directions[1], 10, 2, StandardOverlayQuadProcessor.getEmitter(dataProvider), blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (up & left) {
            return this.fromCorner(directions[1], directions[2], 11, 0, StandardOverlayQuadProcessor.getEmitter(dataProvider), blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (left) {
            return this.fromOneSide(state1, state2, state3, directions[1], directions[2], directions[3], 9, 0, 14, StandardOverlayQuadProcessor.getEmitter(dataProvider), blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (down) {
            return this.fromOneSide(state2, state3, state0, directions[2], directions[3], directions[0], 1, 14, 16, StandardOverlayQuadProcessor.getEmitter(dataProvider), blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (right) {
            return this.fromOneSide(state3, state0, state1, directions[3], directions[0], directions[1], 7, 16, 2, StandardOverlayQuadProcessor.getEmitter(dataProvider), blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (up) {
            return this.fromOneSide(state0, state1, state2, directions[0], directions[1], directions[2], 15, 2, 0, StandardOverlayQuadProcessor.getEmitter(dataProvider), blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        boolean s0 = this.hasSameOverlayUnobscured(state0, directions[0], blockView, pos, state, lightFace, quadSprite, mutablePos);
        boolean s1 = this.hasSameOverlayUnobscured(state1, directions[1], blockView, pos, state, lightFace, quadSprite, mutablePos);
        boolean s2 = this.hasSameOverlayUnobscured(state2, directions[2], blockView, pos, state, lightFace, quadSprite, mutablePos);
        boolean s3 = this.hasSameOverlayUnobscured(state3, directions[3], blockView, pos, state, lightFace, quadSprite, mutablePos);
        boolean corner0 = false;
        boolean corner1 = false;
        boolean corner2 = false;
        boolean corner3 = false;
        if (s0 | s1) {
            corner0 = this.appliesOverlayCorner(directions[0], directions[1], blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (s1 | s2) {
            corner1 = this.appliesOverlayCorner(directions[1], directions[2], blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (s2 | s3) {
            corner2 = this.appliesOverlayCorner(directions[2], directions[3], blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (s3 | s0) {
            corner3 = this.appliesOverlayCorner(directions[3], directions[0], blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (corner0 | corner1 | corner2 | corner3) {
            OverlayEmitter emitter = StandardOverlayQuadProcessor.getEmitter(dataProvider);
            this.prepareEmitter(emitter, lightFace, blockView, pos);
            if (corner0) {
                emitter.addSprite(this.sprites[2]);
            }
            if (corner1) {
                emitter.addSprite(this.sprites[0]);
            }
            if (corner2) {
                emitter.addSprite(this.sprites[14]);
            }
            if (corner3) {
                emitter.addSprite(this.sprites[16]);
            }
            return emitter;
        }
        return null;
    }

    public static class OverlayEmitter
    implements Consumer<QuadEmitter> {
        protected static final class_1058[] EMPTY_SPRITES = new class_1058[4];
        protected class_1058[] sprites = new class_1058[4];
        protected int spriteAmount;
        protected class_2350 face;
        protected int color;
        protected RenderMaterial material;

        @Override
        public void accept(QuadEmitter emitter) {
            for (int i = 0; i < this.spriteAmount; ++i) {
                QuadUtil.emitOverlayQuad(emitter, this.face, this.sprites[i], this.color, this.material);
            }
        }

        public void prepare(class_2350 face, int color, RenderMaterial material) {
            System.arraycopy(EMPTY_SPRITES, 0, this.sprites, 0, EMPTY_SPRITES.length);
            this.spriteAmount = 0;
            this.face = face;
            this.color = color;
            this.material = material;
        }

        public void addSprite(class_1058 sprite) {
            if (sprite != null && !TextureUtil.isMissingSprite(sprite)) {
                this.sprites[this.spriteAmount] = sprite;
                ++this.spriteAmount;
            }
        }
    }

    public static class OverlayEmitterPool {
        protected final List<OverlayEmitter> list = new ObjectArrayList();
        protected int nextIndex = 0;

        public OverlayEmitter get() {
            if (this.nextIndex >= this.list.size()) {
                this.list.add(new OverlayEmitter());
            }
            OverlayEmitter emitter = this.list.get(this.nextIndex);
            ++this.nextIndex;
            return emitter;
        }

        public void reset() {
            this.nextIndex = 0;
        }
    }

    public static class Factory
    extends AbstractQuadProcessorFactory<StandardOverlayCtmProperties> {
        @Override
        public QuadProcessor createProcessor(StandardOverlayCtmProperties properties, class_1058[] sprites) {
            OverlayPropertiesSection overlaySection = properties.getOverlayPropertiesSection();
            return new StandardOverlayQuadProcessor(sprites, OverlayProcessingPredicate.fromProperties(properties), properties.getMatchTilesSet(), properties.getMatchBlocksPredicate(), properties.getConnectTilesSet(), properties.getConnectBlocksPredicate(), properties.getConnectionPredicate(), overlaySection.getTintIndex(), overlaySection.getTintBlock(), overlaySection.getLayer());
        }

        @Override
        public int getTextureAmount(StandardOverlayCtmProperties properties) {
            return 17;
        }

        @Override
        public boolean supportsNullSprites(StandardOverlayCtmProperties properties) {
            return false;
        }
    }
}

